import os
import myutils
import json

for mlm in myutils.mlms:
    for start in ['notok', 'tok']:
        options = ['']
        if start == 'tok':
            options = ['False.False', 'single', 'True.False', 'True.True']
        for option in options:
            for udVersion in myutils.udVersions:
                udPath = 'data/ud-treebanks-v' + udVersion + '.singleToken/'
                for UDdir in sorted(os.listdir(udPath)):
                    if not UDdir.startswith("UD") or not os.path.isdir(udPath + UDdir):
                        continue
                    modelName = start + '.' + mlm.replace('/', '_') + '.' + UDdir + '.' + option + '.' + udVersion
                    modelName = modelName.replace('..', '.')
                    model_path = myutils.getModel(modelName)
                    if model_path == '':
                        continue
                    dev_out = model_path.replace('model.pt', UDdir + '.out')
                    if not os.path.isfile(dev_out):
                        data_config = json.load(open(model_path.replace('model.pt', 'dataset-configs.json')))
                        if 'dev_data_path' in data_config[UDdir]:
                            cmd = 'python3 predict.py ' + model_path.replace('machamp/', '') + ' ' + data_config[UDdir]['dev_data_path'] + ' ' + dev_out.replace('machamp/', '')
                            print(cmd)
                
    for udVersion in myutils.udVersions:
        for split in ['False', 'True']:
            modelName = 'multi.' + mlm.replace('/', '_') + '.' + split + '.' + udVersion
            model_path = myutils.getModel(modelName)
            data_config = json.load(open(model_path.replace('model.pt', 'dataset-configs.json')))
            files = []
            for dataset in data_config:
                if 'dev_data_path' in data_config[dataset]:
                    dev_in = data_config[dataset]['dev_data_path']
                    dev_out = model_path.replace('model.pt', dataset + '.out')
                    if not os.path.isfile(dev_out):
                         files.extend([dev_in, dev_out.replace('machamp/', '')])
            if len(files) > 0:
                cmd = 'python3 predict.py ' + model_path.replace('machamp/', '') + ' ' + ' '.join(files) + ' --dataset ' + dataset
                print(cmd)
                


