import os
import myutils
import json

if not os.path.isdir('configs/'):
    os.mkdir('configs/')

dataConfigsSplit = []
dataConfigsNoSplit = []
for udVersion in myutils.udVersions:
    udPath = 'data/ud-treebanks-v' + udVersion + '.singleToken/'
    for mlm in myutils.mlms: 
        paths = []
        for UDdir in sorted(os.listdir(udPath)):
            if not UDdir.startswith("UD") or not os.path.isdir(udPath + UDdir):
                continue
            train, dev, test = myutils.getTrainDevTest(udPath + UDdir)
            if not myutils.hasColumn(test, 1, threshold=.1):
                #print('noWords ', train)
                continue
            testOut = '../preds/multi.' + mlm.replace('/', '_') + '.' + UDdir + '.' + udVersion
            if os.path.isfile(testOut[3:]):
                continue
            paths.extend(['../' + test, testOut])
            if train != '':
                modelName = 'tok.' + mlm.replace('/', '_') + '.' + UDdir + '.single.' + udVersion
                modelPath = myutils.getModel(modelName)
                testOut = 'preds/' + modelName + '.' + test.split('/')[-1]
                if modelPath != '' and not os.path.isfile(testOut):
                    cmd = 'python3 predict.py ' + modelPath.replace('machamp/', '')  + ' ../' + test + ' ../' + testOut + ' --dataset ' + UDdir
                    print(cmd)
        modelName = 'multi.' + mlm.replace('/', '_') + '.True.' + udVersion
        modelPath = myutils.getModel(modelName)
        testOut = 'preds/' + modelName + '.' + test.split('/')[-1]
        if modelPath != '' and len(paths) > 0:
            cmd = 'python3 predict.py ' + modelPath.replace('machamp/', '')  + ' ' + ' '.join(paths) + ' --dataset UD_English-EWT'
            print(cmd)



