var all_symptom_values = [
	{
		"code": "fever",
		"display_name": "fever",
		"description": "patient has fever (either felt or measured with a thermometer)",
		"keywords": [
			"Fever",
			"body temperature increased",
			"febrile",
			"fever",
			"fever, unspecified",
			"fevered",
			"feverish",
			"high body temperature",
			"increased body temperature",
			"pyrexia",
			"pyrexia nos",
			"temperature elevation",
			"temperature;high",
			"Fever",
			"body temperature increased",
			"febrile",
			"fever",
			"fever, unspecified",
			"fevered",
			"feverish",
			"high body temperature",
			"increased body temperature",
			"pyrexia",
			"pyrexia nos",
			"temperature elevation",
			"temperature;high",
			"Fever",
			"body temperature increased",
			"febrile",
			"fever",
			"fever, unspecified",
			"fevered",
			"feverish",
			"high body temperature",
			"increased body temperature",
			"pyrexia",
			"pyrexia nos",
			"temperature elevation",
			"temperature;high"
		]
	},
	{
		"code": "pain",
		"display_name": "pain",
		"description": "patient feels pain somewhere",
		"keywords": [
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful"
		]
	},
	{
		"code": "fainting",
		"display_name": "fainting",
		"description": "patient lost consciousness",
		"keywords": [
			"Syncope",
			"faint",
			"fainted",
			"fainting",
			"syncope",
			"syncope and collapse",
			"syncopes",
			"Syncope",
			"faint",
			"fainted",
			"fainting",
			"syncope",
			"syncope and collapse",
			"syncopes"
		]
	},
	{
		"code": "pallor",
		"display_name": "pallor",
		"description": "patient has pale skin",
		"keywords": []
	},
	{
		"code": "palpitation",
		"display_name": "palpitation",
		"description": "patient feels his/her heart is beating fast, irregularly (missing a beat) or patient has palpitations",
		"keywords": [
			"Chest>Heart",
			"chest>heart",
			"heart",
			"Heart",
			"cardiac",
			"cardio-",
			"cor",
			"heart",
			"heart structure",
			"heart structure (body structure)",
			"structure of heart, unspecified"
		]
	},
	{
		"code": "coffee ground vomitus",
		"display_name": "coffee ground vomitus",
		"description": "patient threw up blood or coffee beans like substance",
		"keywords": [
			"Coffee ground vomiting",
			"coffee ground emesis",
			"coffee ground vomiting",
			"coffee ground vomiting (disorder)",
			"coffee ground vomitus",
			"coffee grounds emesis",
			"coffee grounds vomiting",
			"hematemesis ('coffee grounds')",
			"vomiting 'coffee grounds'",
			"vomiting 'coffee grounds' (physical finding)",
			"vomiting 'coffee grounds' material",
			"vomiting 'coffee grounds' material (hematemesis)",
			"vomiting 'coffee grounds' material (symptom)",
			"vomiting blood - coffee ground",
			"vomiting of 'coffee grounds' material was observed",
			"vomiting old blood",
			"vomiting stale blood",
			"Coffee ground vomiting",
			"coffee ground emesis",
			"coffee ground vomiting",
			"coffee ground vomiting (disorder)",
			"coffee ground vomitus",
			"coffee grounds emesis",
			"coffee grounds vomiting",
			"hematemesis ('coffee grounds')",
			"vomiting 'coffee grounds'",
			"vomiting 'coffee grounds' (physical finding)",
			"vomiting 'coffee grounds' material",
			"vomiting 'coffee grounds' material (hematemesis)",
			"vomiting 'coffee grounds' material (symptom)",
			"vomiting blood - coffee ground",
			"vomiting of 'coffee grounds' material was observed",
			"vomiting old blood",
			"vomiting stale blood"
		]
	},
	{
		"code": "black or tarry stools",
		"display_name": "black or tarry stools",
		"description": "patient has black stools (like coal)",
		"keywords": [
			"Feces color: tarry",
			"black color stools",
			"black colored stool",
			"black faeces",
			"black feces",
			"black feces symptom",
			"black stool",
			"black stools",
			"dark stool",
			"dark stools",
			"faeces colour: tarry",
			"feces color: tarry",
			"stool black",
			"stool tarry",
			"tarry stool",
			"tarry stools",
			"Feces color: tarry",
			"black color stools",
			"black colored stool",
			"black faeces",
			"black feces",
			"black feces symptom",
			"black stool",
			"black stools",
			"dark stool",
			"dark stools",
			"faeces colour: tarry",
			"feces color: tarry",
			"stool black",
			"stool tarry",
			"tarry stool",
			"tarry stools",
			"Feces color: tarry",
			"black color stools",
			"black colored stool",
			"black faeces",
			"black feces",
			"black feces symptom",
			"black stool",
			"black stools",
			"dark stool",
			"dark stools",
			"faeces colour: tarry",
			"feces color: tarry",
			"stool black",
			"stool tarry",
			"tarry stool",
			"tarry stools"
		]
	},
	{
		"code": "diarrhoea",
		"display_name": "diarrhoea",
		"description": "patient had diarrhea (increase in stool frequency)",
		"keywords": [
			"Diarrhea",
			"d - diarrhoea",
			"diarrhea",
			"diarrhea running",
			"diarrhea symptom",
			"diarrhea, nos",
			"diarrhoea",
			"diarrhoea symptoms",
			"loose bowel motion",
			"runs(diarrhoea)",
			"stools loose",
			"watery stool",
			"Diarrhea",
			"d - diarrhoea",
			"diarrhea",
			"diarrhea running",
			"diarrhea symptom",
			"diarrhea, nos",
			"diarrhoea",
			"diarrhoea symptoms",
			"loose bowel motion",
			"runs(diarrhoea)",
			"stools loose",
			"watery stool",
			"Diarrhea",
			"d - diarrhoea",
			"diarrhea",
			"diarrhea running",
			"diarrhea symptom",
			"diarrhea, nos",
			"diarrhoea",
			"diarrhoea symptoms",
			"loose bowel motion",
			"runs(diarrhoea)",
			"stools loose",
			"watery stool"
		]
	},
	{
		"code": "suffocation",
		"display_name": "suffocation",
		"description": "patient feels or like choking or suffocating",
		"keywords": [
			"Asphyxia",
			"asphyxia",
			"asphyxias",
			"asphyxiation",
			"suffocation",
			"suffocation (diagnosis)",
			"suffocation nos",
			"suffocation, nos",
			"suffocations",
			"Asphyxia",
			"asphyxia",
			"asphyxias",
			"asphyxiation",
			"suffocation",
			"suffocation (diagnosis)",
			"suffocation nos",
			"suffocation, nos",
			"suffocations",
			"Decompression Sickness",
			"bends",
			"decompression sickness",
			"sickness, decompression",
			"Choking",
			"choke",
			"choking",
			"choking (finding)",
			"choking (symptom)",
			"Asphyxia",
			"asphyxia",
			"asphyxias",
			"asphyxiation",
			"suffocation",
			"suffocation (diagnosis)",
			"suffocation nos",
			"suffocation, nos",
			"suffocations"
		]
	},
	{
		"code": "fatigue sleep",
		"display_name": "fatigue sleep",
		"description": "patient feels tired, fatigued or patient has non-restful sleep",
		"keywords": [
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues"
		]
	},
	{
		"code": "irritable",
		"display_name": "irritable",
		"description": "patient feels irritable recently or has had a unstable mood",
		"keywords": []
	},
	{
		"code": "dizzyness",
		"display_name": "dizzyness",
		"description": "patient feels lightheaded and dizzy or feels like he/she is about to faint",
		"keywords": [
			"Dizziness",
			"dizziness",
			"Lightheadedness",
			"dizziness - light-headed",
			"feel headed light",
			"feeling headed light",
			"headed lighted",
			"headedness light",
			"light head",
			"light headed",
			"light headedness",
			"light-headed",
			"light-headed feeling",
			"light-headedness",
			"lightheaded",
			"lightheadedness",
			"Dizziness",
			"dizziness",
			"Syncope",
			"faint",
			"fainted",
			"fainting",
			"syncope",
			"syncope and collapse",
			"syncopes",
			"Dizziness",
			"dizziness"
		]
	},
	{
		"code": "nausea",
		"display_name": "nausea",
		"description": "patient is nauseous or feels like vomiting",
		"keywords": [
			"Nausea",
			"nausea",
			"nausea (finding)",
			"nausea (symptom)",
			"nausea symptom",
			"nausea symptoms",
			"nauseated",
			"nauseating",
			"nauseous",
			"Nausea",
			"nausea",
			"nausea (finding)",
			"nausea (symptom)",
			"nausea symptom",
			"nausea symptoms",
			"nauseated",
			"nauseating",
			"nauseous",
			"Vomiting",
			"vomiting",
			"vomiting, nos",
			"vomits",
			"Nausea",
			"nausea",
			"nausea (finding)",
			"nausea (symptom)",
			"nausea symptom",
			"nausea symptoms",
			"nauseated",
			"nauseating",
			"nauseous"
		]
	},
	{
		"code": "rigor",
		"display_name": "rigor",
		"description": "patient has shivers",
		"keywords": [
			"Muscle Rigidity",
			"muscle rigidity",
			"muscular rigidity",
			"rigid",
			"rigidity",
			"rigidity, muscle",
			"rigidity, nos",
			"rigor",
			"Chills",
			"ague",
			"chill",
			"chill (finding)",
			"chill shaking",
			"chilling",
			"chills",
			"chills (symptom)",
			"chills nos",
			"chills shakes",
			"shaking chills",
			"Muscle Rigidity",
			"muscle rigidity",
			"muscular rigidity",
			"rigid",
			"rigidity",
			"rigidity, muscle",
			"rigidity, nos",
			"rigor"
		]
	},
	{
		"code": "chills",
		"display_name": "chills",
		"description": "patient has chills",
		"keywords": [
			"Muscle Rigidity",
			"muscle rigidity",
			"muscular rigidity",
			"rigid",
			"rigidity",
			"rigidity, muscle",
			"rigidity, nos",
			"rigor",
			"Chills",
			"ague",
			"chill",
			"chill (finding)",
			"chill shaking",
			"chilling",
			"chills",
			"chills (symptom)",
			"chills nos",
			"chills shakes",
			"shaking chills",
			"Muscle Rigidity",
			"muscle rigidity",
			"muscular rigidity",
			"rigid",
			"rigidity",
			"rigidity, muscle",
			"rigidity, nos",
			"rigor"
		]
	},
	{
		"code": "loss of appetite",
		"display_name": "loss of appetite",
		"description": "patient has lost appetite (does not feel like eating) or patient gets full quickly",
		"keywords": [
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite",
			"Decrease in appetite",
			"appetite decrease",
			"appetite decreased",
			"appetite reducing",
			"decrease in appetite",
			"decreased appetite",
			"decreased appetite (symptom)",
			"hyporexia",
			"poor appetite",
			"reduced appetite",
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite",
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite",
			"Decrease in appetite",
			"appetite decrease",
			"appetite decreased",
			"appetite reducing",
			"decrease in appetite",
			"decreased appetite",
			"decreased appetite (symptom)",
			"hyporexia",
			"poor appetite",
			"reduced appetite"
		]
	},
	{
		"code": "rectal bleeding",
		"display_name": "rectal bleeding",
		"description": "patient reports blood in stool or blood clots in his/her stool",
		"keywords": [
			"Hematochezia",
			"blood bright red stools",
			"blood in feces",
			"blood in stool",
			"bloody feces",
			"bloody stool",
			"bright red blood in stool",
			"bright red blood per rectum",
			"bright red blood per rectum (symptom)",
			"faeces: blood",
			"feces: blood",
			"fresh blood passed per rectum",
			"haematochezia",
			"hematochezia",
			"passage of bloody stools",
			"red blood in bowel movement",
			"red blood in bowel movement (hematochezia)",
			"red blood in bowel movement (symptom)",
			"Rectal hemorrhage",
			"bleeding per rectum",
			"bleeding-rectal",
			"bleeding;anal",
			"bleeding;rectal",
			"blood per rectum",
			"haemorrhage of rectum",
			"hemorrhage of rectum",
			"hemorrhage rectum",
			"pr - bleeding per rectum",
			"prb - rectal bleeding",
			"rectal bleeding",
			"rectal haemorrhage",
			"rectal hemorrhage",
			"rectorrhagia",
			"Thrombus",
			"blood clot",
			"blood clots",
			"clot, blood",
			"clots, blood",
			"thrombi",
			"thrombotic",
			"thrombus",
			"thrombus (morphologic abnormality)",
			"thrombus, nos",
			"Blood Clot",
			"blood clot",
			"blood clot, nos",
			"blood clots",
			"blood clotting",
			"blood coagulum",
			"blood coagulum, nos",
			"blooding clotting",
			"clot",
			"clot blood",
			"clots",
			"thrombus",
			"Hematochezia",
			"blood bright red stools",
			"blood in feces",
			"blood in stool",
			"bloody feces",
			"bloody stool",
			"bright red blood in stool",
			"bright red blood per rectum",
			"bright red blood per rectum (symptom)",
			"faeces: blood",
			"feces: blood",
			"fresh blood passed per rectum",
			"haematochezia",
			"hematochezia",
			"passage of bloody stools",
			"red blood in bowel movement",
			"red blood in bowel movement (hematochezia)",
			"red blood in bowel movement (symptom)",
			"Rectal hemorrhage",
			"bleeding per rectum",
			"bleeding-rectal",
			"bleeding;anal",
			"bleeding;rectal",
			"blood per rectum",
			"haemorrhage of rectum",
			"hemorrhage of rectum",
			"hemorrhage rectum",
			"pr - bleeding per rectum",
			"prb - rectal bleeding",
			"rectal bleeding",
			"rectal haemorrhage",
			"rectal hemorrhage",
			"rectorrhagia"
		]
	},
	{
		"code": "unexplained weight loss",
		"display_name": "unexplained weight loss",
		"description": "patient has involuntary lost weight over last three months",
		"keywords": []
	},
	{
		"code": "pyrosis",
		"display_name": "pyrosis",
		"description": "patient has burning sensation that starts in the stomach then goes up into the throat, and can be associated with a bitter taste in the mouth",
		"keywords": [
			"Heartburn",
			"acidity",
			"brash",
			"burning reflux",
			"heart burn",
			"heartburn",
			"heartburn symptom",
			"pyrosis",
			"Burning sensation",
			"burning",
			"burning sensation",
			"burning sensation (finding)",
			"burning sensation nos",
			"burning sensations",
			"burning; sensation",
			"sense; burning",
			"Stomach Diseases",
			"disease of stomach",
			"disease of stomach, nos",
			"disease, gastric",
			"diseases of the stomach",
			"diseases, gastric",
			"diseases, stomach",
			"disorder of stomach",
			"disorder of stomach (disorder)",
			"gastric disease",
			"gastric diseases",
			"gastric disorder",
			"gastropathy",
			"stomach disease",
			"stomach diseases",
			"stomach disorder",
			"stomach--diseases",
			"stomach; disorder",
			"Abdomen>Stomach",
			"abdomen>stomach",
			"stomach",
			"Stomach",
			"gaster",
			"gastr(o)-",
			"gastric",
			"gastro",
			"gastro-",
			"gastrointestinal tract, stomach",
			"stomach",
			"stomachs",
			"ventriculus",
			"Pharyngeal structure",
			"pharyngeal",
			"pharyngeal structure",
			"pharynx",
			"pharynx, nos",
			"pharynxs",
			"structure of pharynx, unspecified",
			"throat",
			"thrt",
			"Throat",
			"throat",
			"Oral region",
			"circumoral region of face",
			"mouth",
			"mouth region",
			"mouth region structure (body structure)",
			"mouth structure",
			"mouth structures",
			"oral part of face",
			"oral region",
			"oral region of face",
			"os",
			"perioral region of face",
			"regio oralis",
			"structure of mouth",
			"structure of oral region of face",
			"structure of oral region of face (body structure)",
			"Heartburn",
			"acidity",
			"brash",
			"burning reflux",
			"heart burn",
			"heartburn",
			"heartburn symptom",
			"pyrosis"
		]
	},
	{
		"code": "peripheral neuropathy",
		"display_name": "peripheral neuropathy",
		"description": "patient has numbness, loss of sensation or tingling in the feet",
		"keywords": [
			"Peripheral Nervous System Diseases",
			"disorders of the peripheral nervous system",
			"nerve disease, peripheral",
			"nerve diseases, peripheral",
			"nerves, peripheral--diseases",
			"neuropathy peripheral",
			"peripheral nerve disease",
			"peripheral nerve diseases",
			"peripheral nervous system disease",
			"peripheral nervous system diseases",
			"peripheral neuropathies",
			"peripheral neuropathy",
			"peripheral neuropathy nos",
			"Peripheral Neuropathy",
			"neuropathy;peripheral",
			"peripheral nerve damage",
			"peripheral neuritis",
			"peripheral neuropathy",
			"peripheral neuropathy (diagnosis)",
			"peripheral neuropathy (physical finding)",
			"pn - peripheral neuropathy",
			"Numbness",
			"deadness - numbness",
			"loss of sensation",
			"loss; sensation",
			"numbness",
			"sensation loss",
			"Numbness",
			"deadness - numbness",
			"loss of sensation",
			"loss; sensation",
			"numbness",
			"sensation loss",
			"Paresthesia",
			"abnormal sensation",
			"paraesthesia",
			"parasthesia",
			"paresthesia",
			"paresthesia (finding)",
			"paresthesias",
			"Has tingling sensation",
			"has tingling sensation",
			"paraesthesia",
			"paresthesia",
			"sensations tingling",
			"sense; tingling",
			"tingling",
			"tingling (paresthesia)",
			"tingling sensation",
			"tingling; sensation",
			"Foot",
			"feet",
			"foot",
			"foot structure",
			"foot structure (body structure)",
			"foot, nos",
			"pedal",
			"pes",
			"terminal segment of free lower limb",
			"Peripheral Nervous System Diseases",
			"disorders of the peripheral nervous system",
			"nerve disease, peripheral",
			"nerve diseases, peripheral",
			"nerves, peripheral--diseases",
			"neuropathy peripheral",
			"peripheral nerve disease",
			"peripheral nerve diseases",
			"peripheral nervous system disease",
			"peripheral nervous system diseases",
			"peripheral neuropathies",
			"peripheral neuropathy",
			"peripheral neuropathy nos",
			"Peripheral Neuropathy",
			"neuropathy;peripheral",
			"peripheral nerve damage",
			"peripheral neuritis",
			"peripheral neuropathy",
			"peripheral neuropathy (diagnosis)",
			"peripheral neuropathy (physical finding)",
			"pn - peripheral neuropathy"
		]
	},
	{
		"code": "dyspnea",
		"display_name": "dyspnea",
		"description": "patient feels shortness of breath or has difficulty breathing in a significant way",
		"keywords": [
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath",
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath",
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath",
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath"
		]
	},
	{
		"code": "vaginal discharge",
		"display_name": "vaginal discharge",
		"description": "patient had vaginal discharge",
		"keywords": [
			"Vaginal discharge symptom",
			"vaginal discharge",
			"vaginal discharge (other than normal menstruation)",
			"vaginal discharge (symptom)",
			"vaginal discharge symptom",
			"vaginal discharge symptom (finding)",
			"Vaginal discharge symptom",
			"vaginal discharge",
			"vaginal discharge (other than normal menstruation)",
			"vaginal discharge (symptom)",
			"vaginal discharge symptom",
			"vaginal discharge symptom (finding)",
			"Vaginal discharge symptom",
			"vaginal discharge",
			"vaginal discharge (other than normal menstruation)",
			"vaginal discharge (symptom)",
			"vaginal discharge symptom",
			"vaginal discharge symptom (finding)"
		]
	},
	{
		"code": "abdominal distension",
		"display_name": "abdominal distension",
		"description": "patient feels his/her abdomen is bloated or distended (swollen due to pressure from inside)",
		"keywords": [
			"Abdominal Cavity",
			"abdomen",
			"abdominal cavities",
			"abdominal cavity",
			"abdominal cavity structure",
			"abdominal cavity, nos",
			"cavitas abdominalis",
			"cavitas abdominis",
			"cavities, abdominal",
			"cavity of abdominal compartment",
			"cavity of compartment of abdomen",
			"cavity, abdominal",
			"intraabdominal",
			"space of abdominal compartment",
			"Abdomen",
			"abdomen",
			"abdomen (volume)",
			"abdomen and",
			"abdomen+",
			"abdomen, nos",
			"abdomens",
			"abdominal",
			"abdominopelvic region",
			"abdominopelvic regions",
			"structure of abdominopelvic cavity and/or content of abdominopelvic cavity and/or anterior abdominal wall (body structure)"
		]
	},
	{
		"code": "watery eyes",
		"display_name": "watery eyes",
		"description": "patient feels teary/watery eyes or feels like his/her eyes produce excessive tears",
		"keywords": [
			"Excessive tearing",
			"crocodile tears",
			"epiphora",
			"epiphora (diagnosis)",
			"epiphora, nos",
			"epiphora, unspecified as to cause",
			"excessive lacrimation",
			"excessive tear production",
			"excessive tearing",
			"excessive tears",
			"illacrimation",
			"illacrimation, nos",
			"increased tears",
			"lacrimation increased",
			"overflow of tears",
			"tearing excessive",
			"watery eyes",
			"Watery eyes",
			"eyes tearing",
			"eyes watering",
			"eyes watering (symptom)",
			"tearing eye",
			"tearing eyes",
			"tearing of the eyes",
			"teary eyes",
			"watering eye",
			"watering eyes",
			"watery eye",
			"watery eye (finding)",
			"watery eyes",
			"watery;eye",
			"Excessive tearing",
			"crocodile tears",
			"epiphora",
			"epiphora (diagnosis)",
			"epiphora, nos",
			"epiphora, unspecified as to cause",
			"excessive lacrimation",
			"excessive tear production",
			"excessive tearing",
			"excessive tears",
			"illacrimation",
			"illacrimation, nos",
			"increased tears",
			"lacrimation increased",
			"overflow of tears",
			"tearing excessive",
			"watery eyes",
			"Excessive tearing",
			"crocodile tears",
			"epiphora",
			"epiphora (diagnosis)",
			"epiphora, nos",
			"epiphora, unspecified as to cause",
			"excessive lacrimation",
			"excessive tear production",
			"excessive tearing",
			"excessive tears",
			"illacrimation",
			"illacrimation, nos",
			"increased tears",
			"lacrimation increased",
			"overflow of tears",
			"tearing excessive",
			"watery eyes",
			"Watery eyes",
			"eyes tearing",
			"eyes watering",
			"eyes watering (symptom)",
			"tearing eye",
			"tearing eyes",
			"tearing of the eyes",
			"teary eyes",
			"watering eye",
			"watering eyes",
			"watery eye",
			"watery eye (finding)",
			"watery eyes",
			"watery;eye",
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball",
			"Excessive tearing",
			"crocodile tears",
			"epiphora",
			"epiphora (diagnosis)",
			"epiphora, nos",
			"epiphora, unspecified as to cause",
			"excessive lacrimation",
			"excessive tear production",
			"excessive tearing",
			"excessive tears",
			"illacrimation",
			"illacrimation, nos",
			"increased tears",
			"lacrimation increased",
			"overflow of tears",
			"tearing excessive",
			"watery eyes",
			"Watery eyes",
			"eyes tearing",
			"eyes watering",
			"eyes watering (symptom)",
			"tearing eye",
			"tearing eyes",
			"tearing of the eyes",
			"teary eyes",
			"watering eye",
			"watering eyes",
			"watery eye",
			"watery eye (finding)",
			"watery eyes",
			"watery;eye"
		]
	},
	{
		"code": "nasal congestion",
		"display_name": "nasal congestion",
		"description": "patient has nasal congestions",
		"keywords": [
			"Nasal congestion (finding)",
			"blocked nose",
			"congested nose",
			"congestion nasal",
			"congestion of nose",
			"congestion;nasal",
			"nasal congestion",
			"nasal congestion (finding)",
			"nasal passage blockage",
			"nasal passage blockage (stuffiness) (symptom)",
			"nasal stuffiness",
			"stuffed-up nose",
			"stuffy nose",
			"Rhinorrhea",
			"catarrh; nasal",
			"discharge nasal",
			"increased nasal secretion",
			"nasal catarrh",
			"nasal discharge",
			"nasal discharge present",
			"nasal; catarrh",
			"nose run",
			"rhinorrhea",
			"rhinorrhoea",
			"runny nose",
			"runny;nose",
			"snuffling",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses",
			"Nasal congestion (finding)",
			"blocked nose",
			"congested nose",
			"congestion nasal",
			"congestion of nose",
			"congestion;nasal",
			"nasal congestion",
			"nasal congestion (finding)",
			"nasal passage blockage",
			"nasal passage blockage (stuffiness) (symptom)",
			"nasal stuffiness",
			"stuffed-up nose",
			"stuffy nose"
		]
	},
	{
		"code": "runny nose",
		"display_name": "runny nose",
		"description": "patient has a clear runny nose",
		"keywords": [
			"Nasal congestion (finding)",
			"blocked nose",
			"congested nose",
			"congestion nasal",
			"congestion of nose",
			"congestion;nasal",
			"nasal congestion",
			"nasal congestion (finding)",
			"nasal passage blockage",
			"nasal passage blockage (stuffiness) (symptom)",
			"nasal stuffiness",
			"stuffed-up nose",
			"stuffy nose",
			"Rhinorrhea",
			"catarrh; nasal",
			"discharge nasal",
			"increased nasal secretion",
			"nasal catarrh",
			"nasal discharge",
			"nasal discharge present",
			"nasal; catarrh",
			"nose run",
			"rhinorrhea",
			"rhinorrhoea",
			"runny nose",
			"runny;nose",
			"snuffling",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses",
			"Nasal congestion (finding)",
			"blocked nose",
			"congested nose",
			"congestion nasal",
			"congestion of nose",
			"congestion;nasal",
			"nasal congestion",
			"nasal congestion (finding)",
			"nasal passage blockage",
			"nasal passage blockage (stuffiness) (symptom)",
			"nasal stuffiness",
			"stuffed-up nose",
			"stuffy nose"
		]
	},
	{
		"code": "fatigue extended",
		"display_name": "fatigue extended",
		"description": "patient feels so tired that he/she is unable to do usual activities or patient is stuck in the bed for all day",
		"keywords": [
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"BORNHOLM EYE DISEASE",
			"bed",
			"bornholm eye disease",
			"myopia, high, with nonprogressive cone dysfunction",
			"x-linked cone dysfunction syndrome with myopia",
			"x-linked cone dysfunction syndrome with myopia (disorder)",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues"
		]
	},
	{
		"code": "convulsion",
		"display_name": "convulsion",
		"description": "patient has lost consciousness associated with violent and sustained muscle contractions or had an absence episode",
		"keywords": [
			"Seizures",
			"seizure",
			"seizures",
			"Convulsions",
			"convulsion",
			"convulsions",
			"fit nos",
			"unspecified convulsions",
			"Seizures",
			"seizure",
			"seizures",
			"Convulsions",
			"convulsion",
			"convulsions",
			"fit nos",
			"unspecified convulsions"
		]
	},
	{
		"code": "face paralysis",
		"display_name": "face paralysis",
		"description": "patient has weakness or paralysis on one side of the face, which may still be present or completely resolved",
		"keywords": [
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies",
			"Side of face",
			"side of face",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies"
		]
	},
	{
		"code": "widespread pain",
		"display_name": "widespread pain",
		"description": "patient has diffuse (widespread) muscle pain",
		"keywords": [
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Myalgia",
			"ache muscle",
			"muscle ache",
			"muscle aches",
			"muscle discomfort",
			"muscle pain",
			"muscle pains",
			"muscle soreness",
			"muscle; pain",
			"myalgia",
			"myalgias",
			"myalgic",
			"pain; muscle",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful"
		]
	},
	{
		"code": "cough",
		"display_name": "cough",
		"description": "patient has cough",
		"keywords": [
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough"
		]
	},
	{
		"code": "soboe",
		"display_name": "soboe",
		"description": "patient feels out of breath with minimal physical effort",
		"keywords": []
	},
	{
		"code": "weight gain",
		"display_name": "weight gain",
		"description": "patient has gained weight recently",
		"keywords": []
	},
	{
		"code": "hyperhidrosis",
		"display_name": "hyperhidrosis",
		"description": "patient has increased sweating significantly",
		"keywords": []
	},
	{
		"code": "sore throat",
		"display_name": "sore throat",
		"description": "patient has a sore throat",
		"keywords": [
			"Pharyngitis",
			"infections throat",
			"inflamed throat",
			"inflammation throat",
			"inflammation; throat",
			"inflammation;throat",
			"pharyngeal inflammation",
			"pharyngitis",
			"pharyngitis nos",
			"pharyngitis, nos",
			"pharynx inflammation",
			"sore throat",
			"throat inflammation",
			"throat soreness",
			"Pharyngalgia",
			"pharyngalgia",
			"sore throat",
			"throat pain",
			"Sore Throat",
			"pain in the pharynx",
			"pain in throat",
			"pain pharynx",
			"pain; pharynx",
			"pain; throat",
			"pharyngeal pain",
			"sore throat",
			"sore throat (symptom)",
			"sore throats",
			"sorethroat",
			"throat discomfort",
			"throat pain",
			"throat sore",
			"throat soreness",
			"Pharyngitis",
			"infections throat",
			"inflamed throat",
			"inflammation throat",
			"inflammation; throat",
			"inflammation;throat",
			"pharyngeal inflammation",
			"pharyngitis",
			"pharyngitis nos",
			"pharyngitis, nos",
			"pharynx inflammation",
			"sore throat",
			"throat inflammation",
			"throat soreness",
			"Pharyngalgia",
			"pharyngalgia",
			"sore throat",
			"throat pain",
			"Sore Throat",
			"pain in the pharynx",
			"pain in throat",
			"pain pharynx",
			"pain; pharynx",
			"pain; throat",
			"pharyngeal pain",
			"sore throat",
			"sore throat (symptom)",
			"sore throats",
			"sorethroat",
			"throat discomfort",
			"throat pain",
			"throat sore",
			"throat soreness",
			"Pharyngitis",
			"infections throat",
			"inflamed throat",
			"inflammation throat",
			"inflammation; throat",
			"inflammation;throat",
			"pharyngeal inflammation",
			"pharyngitis",
			"pharyngitis nos",
			"pharyngitis, nos",
			"pharynx inflammation",
			"sore throat",
			"throat inflammation",
			"throat soreness",
			"Pharyngalgia",
			"pharyngalgia",
			"sore throat",
			"throat pain",
			"Sore Throat",
			"pain in the pharynx",
			"pain in throat",
			"pain pharynx",
			"pain; pharynx",
			"pain; throat",
			"pharyngeal pain",
			"sore throat",
			"sore throat (symptom)",
			"sore throats",
			"sorethroat",
			"throat discomfort",
			"throat pain",
			"throat sore",
			"throat soreness"
		]
	},
	{
		"code": "lymphadenitis",
		"display_name": "lymphadenitis",
		"description": "patient has a swollen or painful lymph nodes",
		"keywords": [
			"Lymphadenitis",
			"adenitis",
			"glands infection lymph",
			"infection;lymph glands",
			"inflammation of the lymph nodes",
			"lymph gland infection",
			"lymph gland; infection",
			"lymphadenitides",
			"lymphadenitis",
			"lymphadenitis (diagnosis)",
			"lymphadenitis nos",
			"gland lymph",
			"glands lymphatic",
			"ln - lymph node",
			"lymph gland",
			"lymph node",
			"lymph node structure",
			"lymph node(s)",
			"lymph nodes",
			"lymphs nodes",
			"node, lymph",
			"nodes lymph",
			"nodus lymphaticus",
			"reticuloendothelial system, lymph node",
			"xxx>lymph node",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Lymphadenitis",
			"adenitis",
			"glands infection lymph",
			"infection;lymph glands",
			"inflammation of the lymph nodes",
			"lymph gland infection",
			"lymph gland; infection",
			"lymphadenitides",
			"lymphadenitis",
			"lymphadenitis (diagnosis)",
			"lymphadenitis nos"
		]
	},
	{
		"code": "stunning",
		"display_name": "stunning",
		"description": "patient feels somewhat dizzy or lightheaded",
		"keywords": [
			"Lightheadedness",
			"dizziness - light-headed",
			"feel headed light",
			"feeling headed light",
			"headed lighted",
			"headedness light",
			"light head",
			"light headed",
			"light headedness",
			"light-headed",
			"light-headed feeling",
			"light-headedness",
			"lightheaded",
			"lightheadedness",
			"Dizziness",
			"dizziness"
		]
	},
	{
		"code": "dysphagia",
		"display_name": "dysphagia",
		"description": "patient has difficulty swallowing, or have a feeling of discomfort/blockage when swallowing",
		"keywords": [
			"Deglutition Disorders",
			"deglutition disorder",
			"difficult swallowing",
			"difficulty in swallowing",
			"difficulty in swallowing nos",
			"difficulty swallowing",
			"difficulty swallowing (finding)",
			"difficulty;swallowing",
			"disorder deglutition",
			"disorders, deglutition",
			"dysphagia",
			"dysphagias",
			"swallowing difficult",
			"swallowing disorder",
			"swallowing disorders",
			"Discomfort",
			"body discomfort",
			"discomfort",
			"discomfort (finding)",
			"discomfort nos",
			"discomfort, nos",
			"discomforts",
			"sensory discomfort",
			"Deglutition Disorders",
			"deglutition disorder",
			"difficult swallowing",
			"difficulty in swallowing",
			"difficulty in swallowing nos",
			"difficulty swallowing",
			"difficulty swallowing (finding)",
			"difficulty;swallowing",
			"disorder deglutition",
			"disorders, deglutition",
			"dysphagia",
			"dysphagias",
			"swallowing difficult",
			"swallowing disorder",
			"swallowing disorders"
		]
	},
	{
		"code": "eye redness",
		"display_name": "eye redness",
		"description": "patient has diffuse (widespread) redness in one or both eyes",
		"keywords": [
			"Redness of eye",
			"eye red",
			"eye redness",
			"eye; red",
			"red eye",
			"red eye (finding)",
			"red eyes",
			"red eyes (symptom)",
			"redness of eye",
			"redness of eyes",
			"redness;eyes",
			"Erythema",
			"cutaneous redness",
			"erythema",
			"erythema (morphologic abnormality)",
			"erythema - observation",
			"erythema nos",
			"erythematous condition (diagnosis)",
			"erythematous condition, nos",
			"erythematous condition, unspecified",
			"injection (erythema)",
			"red skin",
			"redness skin",
			"skin erythema",
			"skin red",
			"skin reddened",
			"unusual change in color of skin to red (erythema) (symptom)",
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball",
			"Redness of eye",
			"eye red",
			"eye redness",
			"eye; red",
			"red eye",
			"red eye (finding)",
			"red eyes",
			"red eyes (symptom)",
			"redness of eye",
			"redness of eyes",
			"redness;eyes"
		]
	},
	{
		"code": "trismus",
		"display_name": "trismus",
		"description": "patient suddenly has difficulty or an inability to open his/her mouth or have jaw pain when opening it",
		"keywords": [
			"Trismus",
			"jaw spasm",
			"jaw spasms",
			"lockjaw",
			"pain of muscles of mastication",
			"trismus",
			"trismus (finding)",
			"trismus (symptom)",
			"Jaw pain",
			"bone jaw pain",
			"jaw bone pain",
			"jaw pain",
			"jaw pain (finding)",
			"jaw; pain",
			"mandibular pain",
			"pain in jaw",
			"pain in the jaw (bone)",
			"pain jaw",
			"pain of jaw",
			"pain;jaw",
			"Oral region",
			"circumoral region of face",
			"mouth",
			"mouth region",
			"mouth region structure (body structure)",
			"mouth structure",
			"mouth structures",
			"oral part of face",
			"oral region",
			"oral region of face",
			"os",
			"perioral region of face",
			"regio oralis",
			"structure of mouth",
			"structure of oral region of face",
			"structure of oral region of face (body structure)",
			"Trismus",
			"jaw spasm",
			"jaw spasms",
			"lockjaw",
			"pain of muscles of mastication",
			"trismus",
			"trismus (finding)",
			"trismus (symptom)"
		]
	},
	{
		"code": "dysarthria",
		"display_name": "dysarthria",
		"description": "patient has issues articulating words/speaking",
		"keywords": []
	},
	{
		"code": "laryngitis",
		"display_name": "laryngitis",
		"description": "patient had felt like suffocating for a very short time associated with inability to breathe or speak",
		"keywords": [
			"Subglottic laryngitis",
			"croup",
			"laryngitis",
			"pseudocroup",
			"spasmodic croup",
			"subglottic laryngitis",
			"viral croup",
			"Laryngitis",
			"laryngeal inflammation",
			"laryngitides",
			"laryngitis",
			"laryngitis (disorder)",
			"laryngitis nos",
			"laryngitis, nos",
			"larynx inflamed",
			"Asphyxia",
			"asphyxia",
			"asphyxias",
			"asphyxiation",
			"suffocation",
			"suffocation (diagnosis)",
			"suffocation nos",
			"suffocation, nos",
			"suffocations",
			"Subglottic laryngitis",
			"croup",
			"laryngitis",
			"pseudocroup",
			"spasmodic croup",
			"subglottic laryngitis",
			"viral croup",
			"Laryngitis",
			"laryngeal inflammation",
			"laryngitides",
			"laryngitis",
			"laryngitis (disorder)",
			"laryngitis nos",
			"laryngitis, nos",
			"larynx inflamed"
		]
	},
	{
		"code": "sialorrhea",
		"display_name": "sialorrhea",
		"description": "patient have noticed that he/she produces more saliva than usual",
		"keywords": [
			"Sialorrhea",
			"excessive production of saliva",
			"excessive;salivation",
			"hypersalivation",
			"polysialia",
			"ptyalism",
			"saliva increased",
			"salivary gland; hypersecretion",
			"salivation excessive",
			"salivation increase",
			"sialism",
			"sialismus",
			"sialorrhea",
			"sialorrhoea",
			"sialosis",
			"Sialorrhea",
			"excessive production of saliva",
			"excessive;salivation",
			"hypersalivation",
			"polysialia",
			"ptyalism",
			"saliva increased",
			"salivary gland; hypersecretion",
			"salivation excessive",
			"salivation increase",
			"sialism",
			"sialismus",
			"sialorrhea",
			"sialorrhoea",
			"sialosis"
		]
	},
	{
		"code": "confusion",
		"display_name": "confusion",
		"description": "patient has felt confused or disorientated lately",
		"keywords": [
			"Disorientation",
			"disorientation",
			"disorientation, nos",
			"disturbance of orientation",
			"disturbance of orientation, nos",
			"orientation confused"
		]
	},
	{
		"code": "hoarse tone",
		"display_name": "hoarse tone",
		"description": "patient have noticed that the tone of his/her voice has become deeper, softer or hoarse",
		"keywords": [
			"Hoarseness",
			"croaky voice",
			"hoarse",
			"hoarse (finding)",
			"hoarse voice",
			"hoarseness",
			"hoarseness - throat symptom",
			"hoarseness;voice",
			"husky voice",
			"voice hoarseness",
			"Hoarseness",
			"croaky voice",
			"hoarse",
			"hoarse (finding)",
			"hoarse voice",
			"hoarseness",
			"hoarseness - throat symptom",
			"hoarseness;voice",
			"husky voice",
			"voice hoarseness",
			"Hoarseness",
			"croaky voice",
			"hoarse",
			"hoarse (finding)",
			"hoarse voice",
			"hoarseness",
			"hoarseness - throat symptom",
			"hoarseness;voice",
			"husky voice",
			"voice hoarseness"
		]
	},
	{
		"code": "mouth ulcer",
		"display_name": "mouth ulcer",
		"description": "patient has painful mouth ulcers or sores",
		"keywords": [
			"Oral Ulcer",
			"mouth ulcer",
			"mouth ulceration",
			"mouth ulcerations",
			"mouth--ulcers",
			"oral mucosal ulcerations",
			"oral ulcer",
			"oral ulceration",
			"oral ulcers",
			"ulcer mouth",
			"ulcer of mouth",
			"ulcer, oral",
			"ulceration mouth",
			"ulceration of mouth",
			"ulceration of oral mucosa",
			"Oral pain",
			"cavity oral pain",
			"mouth pain",
			"mouth painful",
			"mouth; pain",
			"oral cavity pain",
			"oral pain",
			"pain in oral cavity",
			"pain mouth",
			"pain oral",
			"painful mouth",
			"painful mouth (finding)",
			"Ulcer",
			"ulcer",
			"ulcer nos",
			"ulcer, nos",
			"ulcerate",
			"ulcerated",
			"ulcerative",
			"ulcerative lesion, nos",
			"ulcerative lesions",
			"ulcers",
			"ulcus",
			"Oral Ulcer",
			"mouth ulcer",
			"mouth ulceration",
			"mouth ulcerations",
			"mouth--ulcers",
			"oral mucosal ulcerations",
			"oral ulcer",
			"oral ulceration",
			"oral ulcers",
			"ulcer mouth",
			"ulcer of mouth",
			"ulcer, oral",
			"ulceration mouth",
			"ulceration of mouth",
			"ulceration of oral mucosa"
		]
	},
	{
		"code": "diplopia",
		"display_name": "diplopia",
		"description": "patient has the perception of seeing two images of a single object seen overlapping or adjacent to each other (double vision)",
		"keywords": []
	},
	{
		"code": "coughing fit",
		"display_name": "coughing fit",
		"description": "patient has intense coughing fits",
		"keywords": [
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Seizures",
			"seizure",
			"seizures",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Seizures",
			"seizure",
			"seizures"
		]
	},
	{
		"code": "jaw pain",
		"display_name": "jaw pain",
		"description": "patient has pain or weakness in his/her jaw",
		"keywords": [
			"Jaw pain",
			"bone jaw pain",
			"jaw bone pain",
			"jaw pain",
			"jaw pain (finding)",
			"jaw; pain",
			"mandibular pain",
			"pain in jaw",
			"pain in the jaw (bone)",
			"pain jaw",
			"pain of jaw",
			"pain;jaw",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Jaw",
			"jaw",
			"jaw bone",
			"jaw structure",
			"jaw, nos",
			"jaws",
			"Jaw pain",
			"bone jaw pain",
			"jaw bone pain",
			"jaw pain",
			"jaw pain (finding)",
			"jaw; pain",
			"mandibular pain",
			"pain in jaw",
			"pain in the jaw (bone)",
			"pain jaw",
			"pain of jaw",
			"pain;jaw"
		]
	},
	{
		"code": "ptosis",
		"display_name": "ptosis",
		"description": "patient has a hard time opening/raising one or both eyelids",
		"keywords": [
			"Ptosis",
			"caudal displacement",
			"displacement, caudal",
			"displacement, inferior",
			"downward displacement",
			"inferior displacement",
			"procidentia",
			"prolapse",
			"prolapse (morphologic abnormality)",
			"prolapses",
			"ptosis",
			"Blepharoptosis",
			"blepharoptoses",
			"blepharoptosis",
			"drooping eyelid",
			"drooping;eyelid",
			"eyelid ptosis",
			"ptosis",
			"ptosis of eyelid",
			"ptosis, eyelid",
			"Eyelid structure",
			"eyelid",
			"eyelid structure",
			"eyelid, nos",
			"eyelids",
			"palpebra",
			"Ptosis",
			"caudal displacement",
			"displacement, caudal",
			"displacement, inferior",
			"downward displacement",
			"inferior displacement",
			"procidentia",
			"prolapse",
			"prolapse (morphologic abnormality)",
			"prolapses",
			"ptosis",
			"Blepharoptosis",
			"blepharoptoses",
			"blepharoptosis",
			"drooping eyelid",
			"drooping;eyelid",
			"eyelid ptosis",
			"ptosis",
			"ptosis of eyelid",
			"ptosis, eyelid"
		]
	},
	{
		"code": "weak limbs",
		"display_name": "weak limbs",
		"description": "patient feels weakness in both arms and/or both legs",
		"keywords": [
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Alveolar rhabdomyosarcoma",
			"alveolar rhabdomyosarcoma",
			"alveolar rhabdomyosarcoma (diagnosis)",
			"alveolar rhabdomyosarcoma (morphologic abnormality)",
			"alveolar rhabdomyosarcomas",
			"alveolar; rhabdomyosarcoma",
			"malignant neoplasm myosarcoma rhabdomyosarcoma alveolar",
			"monomorphous round cell rhabdomyosarcoma",
			"rhabdomyosarcoma 2",
			"rhabdomyosarcoma, alveolar",
			"rhabdomyosarcoma; alveolar",
			"rhabdomyosarcomas, alveolar",
			"rms2",
			"rmsa",
			"Upper arm",
			"arm",
			"arm (anatomy)",
			"arm, nos",
			"arm, upper",
			"arms",
			"brachium",
			"regio brachialis",
			"structure of upper extremity between shoulder and elbow",
			"structure of upper extremity between shoulder and elbow (body structure)",
			"upper arm",
			"upper arms",
			"Leg",
			"crural region",
			"leg",
			"leg region",
			"legs",
			"lower hindlimb",
			"lower leg",
			"lower leg structure",
			"structure of lower leg",
			"structure of lower leg, unspecified",
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses"
		]
	},
	{
		"code": "symptoms stress",
		"display_name": "symptoms stress",
		"description": "patient's muscle weakness increases with fatigue and/or stress",
		"keywords": [
			"Symptoms of stress",
			"stress symptom",
			"stress symptoms",
			"symptoms of stress",
			"symptoms of stress (finding)",
			"symptoms stress",
			"Paresis",
			"muscle paresis",
			"muscle weakness",
			"muscular pareses",
			"muscular paresis",
			"paralysis partial",
			"pareses",
			"pareses, muscle",
			"pareses, muscular",
			"paresis",
			"paresis, muscle",
			"paresis, muscular",
			"Muscle Weakness",
			"decreased muscle strength",
			"muscle strength reduced",
			"muscle weakness",
			"muscle weakness (symptom)",
			"muscle; weakness",
			"muscular weakness",
			"weakness muscle",
			"weakness, muscle",
			"weakness;muscle(s)",
			"weaknesses, muscle",
			"weaknesses, muscular",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues",
			"Symptoms of stress",
			"stress symptom",
			"stress symptoms",
			"symptoms of stress",
			"symptoms of stress (finding)",
			"symptoms stress"
		]
	},
	{
		"code": "projectile vomitting",
		"display_name": "projectile vomitting",
		"description": "patient vomited several times or has made several efforts to vomit",
		"keywords": [
			"Vomiting",
			"vomiting",
			"vomiting, nos",
			"vomits",
			"Vomiting",
			"vomiting",
			"vomiting, nos",
			"vomits"
		]
	},
	{
		"code": "paroxysmal coughing",
		"display_name": "paroxysmal coughing",
		"description": "patient vomits after coughing",
		"keywords": [
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Vomiting",
			"vomiting",
			"vomiting, nos",
			"vomits",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough"
		]
	},
	{
		"code": "wheez inhale",
		"display_name": "wheez inhale",
		"description": "patient wheezes while inhaling or has a noisy breathing after coughing spells",
		"keywords": [
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Wheezing",
			"wheeze",
			"wheezes",
			"wheezing",
			"wheezing (finding)",
			"wheezing symptom (finding)",
			"wheezing symptom (symptom)",
			"wheezing, nos",
			"wheezy",
			"spell",
			"spells",
			"spells (symptom)"
		]
	},
	{
		"code": "unusual bleeding",
		"display_name": "unusual bleeding",
		"description": "patient has unusual bleeding or bruising",
		"keywords": [
			"Hemorrhage",
			"bleed",
			"bleeding",
			"blood loss",
			"extravasation; blood",
			"haemorrhage",
			"haemorrhage, nos",
			"hemorrhage",
			"hemorrhage (nos)",
			"Hemorrhage",
			"bleed",
			"bleeding",
			"blood loss",
			"extravasation; blood",
			"haemorrhage",
			"haemorrhage, nos",
			"hemorrhage",
			"hemorrhage (nos)",
			"Contusions",
			"bruise",
			"bruised",
			"bruises",
			"bruising",
			"contused",
			"contusion",
			"contusion (disorder)",
			"contusion, nos",
			"contusions",
			"Hemorrhage",
			"bleed",
			"bleeding",
			"blood loss",
			"extravasation; blood",
			"haemorrhage",
			"haemorrhage, nos",
			"hemorrhage",
			"hemorrhage (nos)"
		]
	},
	{
		"code": "hemoptysis",
		"display_name": "hemoptysis",
		"description": "patient has been coughing up blood",
		"keywords": [
			"Hemoptysis",
			"blood streaked sputum",
			"blood streaked sputum (finding)",
			"coughing blood",
			"coughing up blood",
			"coughing up blood (hemoptysis)",
			"coughing up blood (symptom)",
			"expectoration of hemorrhagic sputum",
			"haemoptysis",
			"hemoptyses",
			"hemoptysis",
			"spit up blood",
			"sputum bloody",
			"Hemoptysis",
			"blood streaked sputum",
			"blood streaked sputum (finding)",
			"coughing blood",
			"coughing up blood",
			"coughing up blood (hemoptysis)",
			"coughing up blood (symptom)",
			"expectoration of hemorrhagic sputum",
			"haemoptysis",
			"hemoptyses",
			"hemoptysis",
			"spit up blood",
			"sputum bloody",
			"Hemoptysis",
			"blood streaked sputum",
			"blood streaked sputum (finding)",
			"coughing blood",
			"coughing up blood",
			"coughing up blood (hemoptysis)",
			"coughing up blood (symptom)",
			"expectoration of hemorrhagic sputum",
			"haemoptysis",
			"hemoptyses",
			"hemoptysis",
			"spit up blood",
			"sputum bloody"
		]
	},
	{
		"code": "stridor",
		"display_name": "stridor",
		"description": "patient makes high-pitched sound when breathing in",
		"keywords": [
			"Stridor",
			"stridor",
			"stridor was observed",
			"stridors",
			"stridulous breathing",
			"Stridor",
			"stridor",
			"stridor was observed",
			"stridors",
			"stridulous breathing"
		]
	},
	{
		"code": "facial weakness",
		"display_name": "facial weakness",
		"description": "patient has weakness in his/her facial muscles and/or eyes",
		"keywords": [
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies",
			"Facial Muscles",
			"craniofacial muscle",
			"face muscle",
			"face muscles of",
			"face--muscles",
			"facial muscle",
			"facial muscle, nos",
			"facial muscles",
			"muscle group of face",
			"muscle of face",
			"muscle of facial expression",
			"set of facial muscles",
			"set of muscles of face",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies"
		]
	},
	{
		"code": "paresthesia",
		"display_name": "paresthesia",
		"description": "patient recently had numbness, loss of sensation or tingling, in both arms and legs and around his/her mouth",
		"keywords": [
			"Paresthesia",
			"abnormal sensation",
			"paraesthesia",
			"parasthesia",
			"paresthesia",
			"paresthesia (finding)",
			"paresthesias",
			"Numbness",
			"deadness - numbness",
			"loss of sensation",
			"loss; sensation",
			"numbness",
			"sensation loss",
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"Numbness",
			"deadness - numbness",
			"loss of sensation",
			"loss; sensation",
			"numbness",
			"sensation loss",
			"Paresthesia",
			"abnormal sensation",
			"paraesthesia",
			"parasthesia",
			"paresthesia",
			"paresthesia (finding)",
			"paresthesias",
			"Has tingling sensation",
			"has tingling sensation",
			"paraesthesia",
			"paresthesia",
			"sensations tingling",
			"sense; tingling",
			"tingling",
			"tingling (paresthesia)",
			"tingling sensation",
			"tingling; sensation",
			"Oral region",
			"circumoral region of face",
			"mouth",
			"mouth region",
			"mouth region structure (body structure)",
			"mouth structure",
			"mouth structures",
			"oral part of face",
			"oral region",
			"oral region of face",
			"os",
			"perioral region of face",
			"regio oralis",
			"structure of mouth",
			"structure of oral region of face",
			"structure of oral region of face (body structure)",
			"Paresthesia",
			"abnormal sensation",
			"paraesthesia",
			"parasthesia",
			"paresthesia",
			"paresthesia (finding)",
			"paresthesias"
		]
	},
	{
		"code": "paralysis limb or face",
		"display_name": "paralysis limb or face",
		"description": "patient has or previously had weakness/paralysis in one or more of the limbs or in the face",
		"keywords": [
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies",
			"Asthenia",
			"asthenia",
			"asthenia nos",
			"asthenic",
			"weakness",
			"Weakness",
			"asthenic",
			"debility",
			"feel weak",
			"feelings of weakness (symptom)",
			"general weakness",
			"generalized weakness",
			"loss of strength",
			"strength decreased",
			"weakness",
			"weakness - general",
			"weakness generalized",
			"weakness, generalized",
			"weaknesses",
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies",
			"Limb structure",
			"arms and legs",
			"extremities",
			"extremity",
			"extremity, nos",
			"limb",
			"limb structure",
			"limb structure (body structure)",
			"limb, nos",
			"limbs",
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies"
		]
	},
	{
		"code": "wheez exhale",
		"display_name": "wheez exhale",
		"description": "patient has noticed a wheezing sound when he/she exhales",
		"keywords": [
			"Wheezing",
			"wheeze",
			"wheezes",
			"wheezing",
			"wheezing (finding)",
			"wheezing symptom (finding)",
			"wheezing symptom (symptom)",
			"wheezing, nos",
			"wheezy"
		]
	},
	{
		"code": "constipation",
		"display_name": "constipation",
		"description": "patient has been able to pass stools or gas since his/her symptoms increased",
		"keywords": [
			"Constipation",
			"constipation",
			"gas",
			"gastrointestinal gas",
			"Constipation",
			"constipation"
		]
	},
	{
		"code": "whooping cough",
		"display_name": "whooping cough",
		"description": "patient has a whooping cough",
		"keywords": [
			"Whooping respiration",
			"whoop",
			"whooping",
			"whooping respiration",
			"whooping respiration (finding)",
			"whoops",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Whooping respiration",
			"whoop",
			"whooping",
			"whooping respiration",
			"whooping respiration (finding)",
			"whoops",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough",
			"Whooping respiration",
			"whoop",
			"whooping",
			"whooping respiration",
			"whooping respiration (finding)",
			"whoops",
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough"
		]
	},
	{
		"code": "itching eyes",
		"display_name": "itching eyes",
		"description": "patient has severe itching in one eye or both eyes",
		"keywords": [
			"Itching of eye",
			"eye itch",
			"eye itching",
			"eye pruritus",
			"eye; itchy",
			"eyes itch",
			"eyes itching",
			"eyes itchy",
			"itching eye",
			"itching eyes",
			"itching of eye",
			"itching of eye (finding)",
			"itching;eye",
			"itchy eye",
			"itchy eyes",
			"ocular pruritus",
			"pruritus of eye",
			"pruritus of eye (symptom)",
			"Pruritus",
			"pruritus",
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball",
			"Head>Eye",
			"eye",
			"head>eye",
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball",
			"Orbital region",
			"eye",
			"eye region structure",
			"eye region structure (body structure)",
			"ocular",
			"oculus",
			"orbital part of face",
			"orbital region",
			"orbital region structure",
			"regio orbitalis",
			"structure of orbital region",
			"structure of orbital region (body structure)",
			"Itching of eye",
			"eye itch",
			"eye itching",
			"eye pruritus",
			"eye; itchy",
			"eyes itch",
			"eyes itching",
			"eyes itchy",
			"itching eye",
			"itching eyes",
			"itching of eye",
			"itching of eye (finding)",
			"itching;eye",
			"itchy eye",
			"itchy eyes",
			"ocular pruritus",
			"pruritus of eye",
			"pruritus of eye (symptom)"
		]
	},
	{
		"code": "colored/excess sputum",
		"display_name": "colored/excess sputum",
		"description": "patient has a cough that produces colored or more abundant sputum than usual",
		"keywords": [
			"Coughing",
			"cough",
			"cough, nos",
			"coughing",
			"coughing - function",
			"coughs",
			"observation of cough"
		]
	},
	{
		"code": "symptom speedup",
		"display_name": "symptom speedup",
		"description": "patient noticed that his/her symptoms have worsened over the last 2 weeks and that progressively less effort is required to cause the symptoms",
		"keywords": [
			"Symptoms",
			"general manifestation of disorders",
			"symptom",
			"symptom, nos",
			"symptoms",
			"symptoms (symptom)",
			"Symptoms",
			"general manifestation of disorders",
			"symptom",
			"symptom, nos",
			"symptoms",
			"symptoms (symptom)",
			"Symptoms",
			"general manifestation of disorders",
			"symptom",
			"symptom, nos",
			"symptoms",
			"symptoms (symptom)"
		]
	},
	{
		"code": "chest pain rest",
		"display_name": "chest pain rest",
		"description": "patient has chest pain at rest",
		"keywords": [
			"Chest pain at rest",
			"chest pain at rest",
			"chest pain at rest (finding)",
			"chest pain rest",
			"chest pain starting when at rest",
			"chest pain starting when at rest (symptom)",
			"chest pain, at rest",
			"Chest pain at rest",
			"chest pain at rest",
			"chest pain at rest (finding)",
			"chest pain rest",
			"chest pain starting when at rest",
			"chest pain starting when at rest (symptom)",
			"chest pain, at rest",
			"Chest pain at rest",
			"chest pain at rest",
			"chest pain at rest (finding)",
			"chest pain rest",
			"chest pain starting when at rest",
			"chest pain starting when at rest (symptom)",
			"chest pain, at rest"
		]
	},
	{
		"code": "nasal itching",
		"display_name": "nasal itching",
		"description": "patient's nose or the back of his/her throat is itchy",
		"keywords": [
			"Nasal pruritus",
			"itching nasal",
			"itching nose",
			"itching of nose",
			"itching of nose (symptom)",
			"itching;nose",
			"itchy nose",
			"nasal itch",
			"nasal itching",
			"nasal pruritus",
			"nose itching",
			"nose pruritus",
			"pruritus of nose",
			"Pharyngeal structure",
			"pharyngeal",
			"pharyngeal structure",
			"pharynx",
			"pharynx, nos",
			"pharynxs",
			"structure of pharynx, unspecified",
			"throat",
			"thrt",
			"Throat",
			"throat",
			"Pruritus",
			"pruritus",
			"Nose Diseases",
			"disease of the nose, nos",
			"disease or syndrome of nose",
			"disease, nasal",
			"diseases nose",
			"diseases, nose",
			"disorder of nose",
			"disorder of the nose",
			"disorder, nasal",
			"disorders nasal",
			"disorders nose",
			"disorders, nasal",
			"nasal disease",
			"nasal diseases",
			"nasal disorder",
			"nasal disorder nos",
			"nasal disorders",
			"nose disease",
			"nose diseases",
			"nose disorder",
			"nose--diseases",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses",
			"Back structure, including back of neck",
			"back",
			"back (of neck and trunk)",
			"back of body proper",
			"back structure",
			"back structure, including back of neck",
			"dorsum",
			"posterior part of body proper",
			"regiones dorsalis",
			"structure of back of trunk and/or neck",
			"structure of back of trunk and/or neck (body structure)",
			"Back",
			"back",
			"back (body region)",
			"back anatomy",
			"back of trunk",
			"back regions",
			"back, nos",
			"backs",
			"dorsum",
			"dorsum of trunk",
			"regiones dorsales",
			"regions of back",
			"Nasal pruritus",
			"itching nasal",
			"itching nose",
			"itching of nose",
			"itching of nose (symptom)",
			"itching;nose",
			"itchy nose",
			"nasal itch",
			"nasal itching",
			"nasal pruritus",
			"nose itching",
			"nose pruritus",
			"pruritus of nose"
		]
	},
	{
		"code": "paralysis general",
		"display_name": "paralysis general",
		"description": "patient has/had numbness, loss of sensitivity or tingling anywhere on his/her body",
		"keywords": [
			"Hypersensitivity",
			"allergic disorder",
			"allergic disorders",
			"allergic reaction",
			"allergic reaction (nos)",
			"allergic reaction caused by substance (disorder)",
			"allergic reaction to substance",
			"allergic reactions",
			"allergic state, nos",
			"allergy",
			"hypersensitivities",
			"hypersensitivity",
			"hypersensitivity reaction",
			"hypersensitivity reaction, nos",
			"hypersensitivity reactions",
			"hypersensitivity symptoms",
			"reaction hypersensitivity (nos)",
			"Numbness",
			"deadness - numbness",
			"loss of sensation",
			"loss; sensation",
			"numbness",
			"sensation loss",
			"Paresthesia",
			"abnormal sensation",
			"paraesthesia",
			"parasthesia",
			"paresthesia",
			"paresthesia (finding)",
			"paresthesias",
			"Has tingling sensation",
			"has tingling sensation",
			"paraesthesia",
			"paresthesia",
			"sensations tingling",
			"sense; tingling",
			"tingling",
			"tingling (paresthesia)",
			"tingling sensation",
			"tingling; sensation"
		]
	},
	{
		"code": "general enquiry",
		"display_name": "general enquiry",
		"description": "patient has noticed a new fatigue, generalized and vague discomfort, diffuse (widespread) muscle aches or a change in his/her general well-being related to his/her consultation",
		"keywords": [
			"Myalgia",
			"ache muscle",
			"muscle ache",
			"muscle aches",
			"muscle discomfort",
			"muscle pain",
			"muscle pains",
			"muscle soreness",
			"muscle; pain",
			"myalgia",
			"myalgias",
			"myalgic",
			"pain; muscle",
			"Discomfort",
			"body discomfort",
			"discomfort",
			"discomfort (finding)",
			"discomfort nos",
			"discomfort, nos",
			"discomforts",
			"sensory discomfort",
			"Fatigue",
			"fatigue",
			"fatigue extreme",
			"fatigue nos",
			"fatigues"
		]
	},
	{
		"code": "anorexia",
		"display_name": "anorexia",
		"description": "patient has been unintentionally losing weight or has lost appetite",
		"keywords": [
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite",
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite",
			"Anorexia",
			"anorectic",
			"anorexia",
			"anorexia (loss of appetite)",
			"anorexic",
			"appetite loss",
			"appetite lost",
			"lack of appetite",
			"no appetite"
		]
	},
	{
		"code": "long menstruation",
		"display_name": "long menstruation",
		"description": "patient has very abundant or very long menstruation periods",
		"keywords": []
	},
	{
		"code": "flushing",
		"display_name": "flushing",
		"description": "patient's cheeks suddenly turned red",
		"keywords": [
			"Flushing",
			"face goes red (finding)",
			"facial flushing",
			"flush",
			"flushed",
			"flushed face",
			"flushes",
			"flushing",
			"skin flushing as symptom",
			"sudden redness of skin primarily involving face (symptom)",
			"Cheek structure",
			"bucca",
			"buccal part of mouth",
			"buccal region",
			"buccal region of face",
			"buccal region of mouth",
			"buccas",
			"cheek",
			"cheek proper",
			"cheek structure",
			"cheek, nos",
			"cheeks",
			"Flushing",
			"face goes red (finding)",
			"facial flushing",
			"flush",
			"flushed",
			"flushed face",
			"flushes",
			"flushing",
			"skin flushing as symptom",
			"sudden redness of skin primarily involving face (symptom)"
		]
	},
	{
		"code": "neck muscle spasm",
		"display_name": "neck muscle spasm",
		"description": "patient feel that muscle spasms or soreness in his/her neck are keeping him/her from turning his/her head to one side",
		"keywords": [
			"Skeletal muscle structure of neck",
			"muscle group of neck",
			"muscle neck",
			"muscle of neck",
			"muscle of neck, nos",
			"muscle, neck",
			"muscles neck",
			"muscles neck of",
			"muscles of neck",
			"muscles, neck",
			"muscular system of neck",
			"musculature of neck",
			"neck muscle",
			"neck muscles",
			"of neck muscle",
			"set of muscles of neck",
			"skeletal muscle structure of neck",
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular",
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular",
			"Hyperkinesia",
			"hyperactivity, motor",
			"hyperkinesia",
			"hyperkinesia, nos",
			"hyperkinesis",
			"hyperkinetic movement",
			"hyperkinetic movements",
			"motor hyperactivity",
			"movement, hyperkinetic",
			"movements, hyperkinetic",
			"muscle spasms",
			"Sore to touch",
			"sore",
			"sore pain",
			"sore to touch",
			"sore, painful",
			"soreness",
			"soreness (finding)",
			"tender pain",
			"tenderness",
			"tenderness (nos)",
			"Neck",
			"collum",
			"neck",
			"neck (anatomy)",
			"neck (volume)",
			"neck anatomy",
			"neck structure",
			"necks",
			"Head",
			"caput",
			"head",
			"head (anatomy)",
			"head (volume)",
			"head structure",
			"head, nos",
			"heads",
			"Skeletal muscle structure of neck",
			"muscle group of neck",
			"muscle neck",
			"muscle of neck",
			"muscle of neck, nos",
			"muscle, neck",
			"muscles neck",
			"muscles neck of",
			"muscles of neck",
			"muscles, neck",
			"muscular system of neck",
			"musculature of neck",
			"neck muscle",
			"neck muscles",
			"of neck muscle",
			"set of muscles of neck",
			"skeletal muscle structure of neck",
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular"
		]
	},
	{
		"code": "pale stool",
		"display_name": "pale stool",
		"description": "patient has pale stool and dark urine",
		"keywords": []
	},
	{
		"code": "arrhythmia",
		"display_name": "arrhythmia",
		"description": "patient feels his/her heart is beating very irregularly or in a disorganized pattern",
		"keywords": [
			"Cardiac Arrhythmia",
			"arrhythmia (cardiac) nos",
			"arrhythmia cardiac (nos)",
			"arrhythmia, cardiac",
			"cardiac arrhythmia",
			"cardiac arrhythmia (nos)",
			"cardiac arrhythmia nos",
			"cardiac arrhythmia, nos",
			"cardiac arrhythmias",
			"Chest>Heart",
			"chest>heart",
			"heart",
			"Heart",
			"cardiac",
			"cardio-",
			"cor",
			"heart",
			"heart structure",
			"heart structure (body structure)",
			"structure of heart, unspecified",
			"Cardiac Arrhythmia",
			"arrhythmia (cardiac) nos",
			"arrhythmia cardiac (nos)",
			"arrhythmia, cardiac",
			"cardiac arrhythmia",
			"cardiac arrhythmia (nos)",
			"cardiac arrhythmia nos",
			"cardiac arrhythmia, nos",
			"cardiac arrhythmias"
		]
	},
	{
		"code": "mucle spasm",
		"display_name": "mucle spasm",
		"description": "patient has annoying muscle spasms in his/her face, neck or any other part of the body",
		"keywords": [
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular",
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular",
			"Hyperkinesia",
			"hyperactivity, motor",
			"hyperkinesia",
			"hyperkinesia, nos",
			"hyperkinesis",
			"hyperkinetic movement",
			"hyperkinetic movements",
			"motor hyperactivity",
			"movement, hyperkinetic",
			"movements, hyperkinetic",
			"muscle spasms",
			"FANCONI ANEMIA, COMPLEMENTATION GROUP E",
			"face",
			"fance",
			"fanconi anemia complementation group e",
			"fanconi anemia complementation group e (diagnosis)",
			"fanconi anemia, complementation group e",
			"Head>Face",
			"face",
			"head>face",
			"Face",
			"face",
			"face structure",
			"face, nos",
			"faces",
			"facial",
			"facies",
			"Neck",
			"collum",
			"neck",
			"neck (anatomy)",
			"neck (volume)",
			"neck anatomy",
			"neck structure",
			"necks",
			"Spasm",
			"muscle cramps",
			"muscle spasm",
			"muscle spasms",
			"reported muscle spasms",
			"spasm",
			"spasm of muscle",
			"spasm, nos",
			"spasm;muscle(s)",
			"spasms",
			"spasms (diagnosis)",
			"spasms nos",
			"spasms, muscular"
		]
	},
	{
		"code": "tongue trouble",
		"display_name": "tongue trouble",
		"description": "patient has trouble keeping his/her tongue in the mouth",
		"keywords": [
			"Tongue",
			"tongue",
			"tongue structure",
			"tongue structure (body structure)",
			"tongues",
			"Tongue",
			"tongue",
			"tongue structure",
			"tongue structure (body structure)",
			"tongues",
			"Oral region",
			"circumoral region of face",
			"mouth",
			"mouth region",
			"mouth region structure (body structure)",
			"mouth structure",
			"mouth structures",
			"oral part of face",
			"oral region",
			"oral region of face",
			"os",
			"perioral region of face",
			"regio oralis",
			"structure of mouth",
			"structure of oral region of face",
			"structure of oral region of face (body structure)",
			"Tongue",
			"tongue",
			"tongue structure",
			"tongue structure (body structure)",
			"tongues"
		]
	},
	{
		"code": "averted gaze",
		"display_name": "averted gaze",
		"description": "patient can not control directions of the eyes",
		"keywords": [
			"?eye",
			"Eye",
			"eye",
			"eyeball",
			"eyeballs",
			"eyes",
			"globe",
			"oculus",
			"structure of eyeball"
		]
	},
	{
		"code": "sleep dyspnea",
		"display_name": "sleep dyspnea",
		"description": "patient has bouts of choking or shortness of breath that wakes him/her up at night",
		"keywords": [
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath",
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath",
			"Decompression Sickness",
			"bends",
			"decompression sickness",
			"sickness, decompression",
			"Choking",
			"choke",
			"choking",
			"choking (finding)",
			"choking (symptom)",
			"Dyspnea",
			"breath shortness",
			"breathing difficulties",
			"breathlessness",
			"difficult breathing",
			"difficulty;breathing",
			"dyspnea",
			"dyspnoea",
			"short of breath",
			"shortness (of);breath",
			"shortness of breath"
		]
	},
	{
		"code": "derealization",
		"display_name": "derealization",
		"description": "patient feels like he/she is detached from his/her own body or the surroundings",
		"keywords": []
	},
	{
		"code": "thanatophobia",
		"display_name": "thanatophobia",
		"description": "patient feels like he/she are dying or were afraid that he/she were about do die",
		"keywords": [
			"Structure of diencephalon",
			"between brain",
			"cerebral core",
			"cerebral core structure",
			"diencephalon",
			"interbrain",
			"interbrains",
			"structure of diencephalon",
			"structure of diencephalon (body structure)"
		]
	},
	{
		"code": "greenish/yellowish nasal discharge",
		"display_name": "greenish/yellowish nasal discharge",
		"description": "patient has greenish or yellowish nasal discharge",
		"keywords": [
			"Discharge, body substance",
			"body substance discharge",
			"discharge",
			"discharge, body substance",
			"drainage",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses",
			"Discharge, body substance",
			"body substance discharge",
			"discharge",
			"discharge, body substance",
			"drainage",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses",
			"Discharge, body substance",
			"body substance discharge",
			"discharge",
			"discharge, body substance",
			"drainage",
			"Nose",
			"nasal",
			"nose",
			"nose, nos",
			"noses"
		]
	},
	{
		"code": "smell loss",
		"display_name": "smell loss",
		"description": "patient has lost sense of smell",
		"keywords": []
	},
	{
		"code": "apnea",
		"display_name": "apnea",
		"description": "patient stops breathing temporarily during sleep",
		"keywords": [
			"Apnea",
			"apnea",
			"apneas",
			"apnoea",
			"Apnea",
			"apnea",
			"apneas",
			"apnoea",
			"Apnea",
			"apnea",
			"apneas",
			"apnoea"
		]
	},
	{
		"code": "swelling",
		"display_name": "swelling",
		"description": "patient has swelling in one or more areas of the body",
		"keywords": [
			"Edema",
			"dropsy",
			"edema",
			"edema (nos)",
			"edematous",
			"hydrops",
			"interstitial edema",
			"oedema",
			"oedematous",
			"swelling",
			"Edema",
			"dropsy",
			"edema",
			"edema (nos)",
			"edematous",
			"hydrops",
			"interstitial edema",
			"oedema",
			"oedematous",
			"swelling",
			"Edema",
			"dropsy",
			"edema",
			"edema (nos)",
			"edematous",
			"hydrops",
			"interstitial edema",
			"oedema",
			"oedematous",
			"swelling"
		]
	},
	{
		"code": "head ache",
		"display_name": "head ache",
		"description": "patient has a head ache",
		"keywords": [
			"Headache",
			"headache",
			"headaches",
			"Headache",
			"headache",
			"headaches",
			"Headache",
			"headache",
			"headaches"
		]
	},
	{
		"code": "sleep hydrosis",
		"display_name": "sleep hydrosis",
		"description": "patient has night sweats",
		"keywords": [
			"Night sweats",
			"night sweat",
			"night sweating",
			"night sweats",
			"night sweats (finding)",
			"nights sweats",
			"problem;sweating;night",
			"sweating heavily at night",
			"sweating heavily at night (symptom)"
		]
	},
	{
		"code": "general",
		"display_name": "general",
		"description": "",
		"keywords": []
	},
	{
		"code": "bowel movement",
		"display_name": "bowel movement",
		"description": "patient has felt changes/problems with his/her bowel movements",
		"keywords": []
	},
	{
		"code": "urination",
		"display_name": "urination / urinary problems",
		"description": "patient has felt changes/problems with his/her urine",
		"keywords": []
	},
	{
		"code": "taste loss",
		"display_name": "taste loss",
		"description": "patient has lost sense of taste",
		"keywords": [
			"Ageusia",
			"absence of sense of taste",
			"ageusia",
			"ageustia",
			"gustatory anaesthesia",
			"gustatory anesthesia",
			"loss of taste",
			"loss of taste (finding)",
			"taste absent",
			"taste loss",
			"unable to taste",
			"Ageusia",
			"absence of sense of taste",
			"ageusia",
			"ageustia",
			"gustatory anaesthesia",
			"gustatory anesthesia",
			"loss of taste",
			"loss of taste (finding)",
			"taste absent",
			"taste loss",
			"unable to taste"
		]
	},
	{
		"code": "speech volume",
		"display_name": "speech volume",
		"description": "patient has noticed that the tone of his/her voice has become deeper, softer or hoarse",
		"keywords": [
			"Hoarseness",
			"croaky voice",
			"hoarse",
			"hoarse (finding)",
			"hoarse voice",
			"hoarseness",
			"hoarseness - throat symptom",
			"hoarseness;voice",
			"husky voice",
			"voice hoarseness"
		]
	},
	{
		"code": "wheez",
		"display_name": "wheez",
		"description": "patient has noticed a wheezing sound when he/she breaths",
		"keywords": [
			"Wheezing",
			"wheeze",
			"wheezes",
			"wheezing",
			"wheezing (finding)",
			"wheezing symptom (finding)",
			"wheezing symptom (symptom)",
			"wheezing, nos",
			"wheezy"
		]
	},
	{
		"code": "chest pain",
		"display_name": "chest pain",
		"description": "patient has a chest pain",
		"keywords": [
			"Anterior thoracic region",
			"anterior thoracic region",
			"anterolateral part of thorax",
			"chest",
			"chest region",
			"front of thorax",
			"subdivision of chest",
			"Chest",
			"chest",
			"chest and upper back",
			"chest region",
			"chests",
			"thoraces",
			"thoracic area",
			"thoracic region",
			"thoracic structure (body structure)",
			"thorax",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Anterior thoracic region",
			"anterior thoracic region",
			"anterolateral part of thorax",
			"chest",
			"chest region",
			"front of thorax",
			"subdivision of chest",
			"Chest",
			"chest",
			"chest and upper back",
			"chest region",
			"chests",
			"thoraces",
			"thoracic area",
			"thoracic region",
			"thoracic structure (body structure)",
			"thorax",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful",
			"Anterior thoracic region",
			"anterior thoracic region",
			"anterolateral part of thorax",
			"chest",
			"chest region",
			"front of thorax",
			"subdivision of chest",
			"Chest",
			"chest",
			"chest and upper back",
			"chest region",
			"chests",
			"thoraces",
			"thoracic area",
			"thoracic region",
			"thoracic structure (body structure)",
			"thorax",
			"Pain",
			"ache",
			"pain",
			"pain nos",
			"pain symptoms",
			"pain, unspecified",
			"painful"
		]
	},
	{
		"code": "vision problem",
		"display_name": "vision",
		"description": "patient has a problem with his/her vision",
		"keywords": []
	},
	{
		"code": "hearing problem",
		"display_name": "hearing",
		"description": "patient has a problem with his/her hearing",
		"keywords": []
	},
	{
		"code": "smell problem",
		"display_name": "smelling",
		"description": "patient has a problem with his/her smelling",
		"keywords": []
	},
	{
		"code": "stool problem",
		"display_name": "stool",
		"description": "patient has a problem with his/her stool",
		"keywords": [
			"problem with stools",
			"problem;stools",
			"problems stool",
			"stool problem"
		]
	},
	{
		"code": "vomitting",
		"display_name": "vomitting",
		"description": "patient has been vomitting",
		"keywords": [
			"vomit",
			"vomitting"
		]
	},
	{
		"code": "ear problem",
		"display_name": "ear problem",
		"description": "patient has a problem with the ears",
		"keywords": [
			"ear problem",
			"ears problem"
		]
	},
	{
		"code": "all",
		"display_name": "all",
		"description": "the collective reference to all the symptoms that the patient is suffering from",
		"keywords": []
	}
];

var all_symptom_locations = [
	{
		"code": "above the tongue",
		"description": "",
		"display_name": "above the tongue"
	},
	{
		"code": "ankle(L)",
		"description": "",
		"display_name": "ankle(L)"
	},
	{
		"code": "ankle(R)",
		"description": "",
		"display_name": "ankle(R)"
	},
	{
		"code": "anus",
		"description": "",
		"display_name": "anus"
	},
	{
		"code": "axilla(L)",
		"description": "",
		"display_name": "axilla(L)"
	},
	{
		"code": "axilla(R)",
		"description": "",
		"display_name": "axilla(R)"
	},
	{
		"code": "back of head",
		"description": "",
		"display_name": "back of head"
	},
	{
		"code": "back of the neck",
		"description": "",
		"display_name": "back of the neck"
	},
	{
		"code": "belly",
		"description": "",
		"display_name": "belly"
	},
	{
		"code": "biceps(L)",
		"description": "",
		"display_name": "biceps(L)"
	},
	{
		"code": "biceps(R)",
		"description": "",
		"display_name": "biceps(R)"
	},
	{
		"code": "big toe(L)",
		"description": "",
		"display_name": "big toe(L)"
	},
	{
		"code": "big toe(R)",
		"description": "",
		"display_name": "big toe(R)"
	},
	{
		"code": "bottom lip(R)",
		"description": "",
		"display_name": "bottom lip(R)"
	},
	{
		"code": "breast(L)",
		"description": "",
		"display_name": "breast(L)"
	},
	{
		"code": "breast(R)",
		"description": "",
		"display_name": "breast(R)"
	},
	{
		"code": "buttock(L)",
		"description": "",
		"display_name": "buttock(L)"
	},
	{
		"code": "buttock(R)",
		"description": "",
		"display_name": "buttock(R)"
	},
	{
		"code": "calf(L)",
		"description": "",
		"display_name": "calf(L)"
	},
	{
		"code": "calf(R)",
		"description": "",
		"display_name": "calf(R)"
	},
	{
		"code": "cervical spine",
		"description": "",
		"display_name": "cervical spine"
	},
	{
		"code": "cheek(L)",
		"description": "",
		"display_name": "cheek(L)"
	},
	{
		"code": "cheek(R)",
		"description": "",
		"display_name": "cheek(R)"
	},
	{
		"code": "chin",
		"description": "",
		"display_name": "chin"
	},
	{
		"code": "clitoris",
		"description": "",
		"display_name": "clitoris"
	},
	{
		"code": "coccyx",
		"description": "",
		"display_name": "coccyx"
	},
	{
		"code": "commissure(L)",
		"description": "",
		"display_name": "commissure(L)"
	},
	{
		"code": "commissure(R)",
		"description": "",
		"display_name": "commissure(R)"
	},
	{
		"code": "dorsal aspect of the foot(L)",
		"description": "",
		"display_name": "dorsal aspect of the foot(L)"
	},
	{
		"code": "dorsal aspect of the foot(R)",
		"description": "",
		"display_name": "dorsal aspect of the foot(R)"
	},
	{
		"code": "dorsal aspect of the hand(L)",
		"description": "",
		"display_name": "dorsal aspect of the hand(L)"
	},
	{
		"code": "dorsal aspect of the hand(R)",
		"description": "",
		"display_name": "dorsal aspect of the hand(R)"
	},
	{
		"code": "dorsal aspect of the wrist(L)",
		"description": "",
		"display_name": "dorsal aspect of the wrist(L)"
	},
	{
		"code": "dorsal aspect of the wrist(R)",
		"description": "",
		"display_name": "dorsal aspect of the wrist(R)"
	},
	{
		"code": "ear(L)",
		"description": "",
		"display_name": "ear(L)"
	},
	{
		"code": "ear(R)",
		"description": "",
		"display_name": "ear(R)"
	},
	{
		"code": "elbow(L)",
		"description": "",
		"display_name": "elbow(L)"
	},
	{
		"code": "elbow(R)",
		"description": "",
		"display_name": "elbow(R)"
	},
	{
		"code": "epigastric",
		"description": "",
		"display_name": "epigastric"
	},
	{
		"code": "eye(L)",
		"description": "",
		"display_name": "eye(L)"
	},
	{
		"code": "eye(R)",
		"description": "",
		"display_name": "eye(R)"
	},
	{
		"code": "finger (index)(L)",
		"description": "",
		"display_name": "finger (index)(L)"
	},
	{
		"code": "finger (index)(R)",
		"description": "",
		"display_name": "finger (index)(R)"
	},
	{
		"code": "finger (little finger)(L)",
		"description": "",
		"display_name": "finger (little finger)(L)"
	},
	{
		"code": "finger (little finger)(R)",
		"description": "",
		"display_name": "finger (little finger)(R)"
	},
	{
		"code": "finger (middle)(L)",
		"description": "",
		"display_name": "finger (middle)(L)"
	},
	{
		"code": "finger (middle)(R)",
		"description": "",
		"display_name": "finger (middle)(R)"
	},
	{
		"code": "finger (ring finger)(L)",
		"description": "",
		"display_name": "finger (ring finger)(L)"
	},
	{
		"code": "finger (ring finger)(R)",
		"description": "",
		"display_name": "finger (ring finger)(R)"
	},
	{
		"code": "flank(L)",
		"description": "",
		"display_name": "flank(L)"
	},
	{
		"code": "flank(R)",
		"description": "",
		"display_name": "flank(R)"
	},
	{
		"code": "forearm(L)",
		"description": "",
		"display_name": "forearm(L)"
	},
	{
		"code": "forearm(R)",
		"description": "",
		"display_name": "forearm(R)"
	},
	{
		"code": "forehead",
		"description": "",
		"display_name": "forehead"
	},
	{
		"code": "glans",
		"description": "",
		"display_name": "glans"
	},
	{
		"code": "groin(L)",
		"description": "",
		"display_name": "groin(L)"
	},
	{
		"code": "groin(R)",
		"description": "",
		"display_name": "groin(R)"
	},
	{
		"code": "heel(L)",
		"description": "",
		"display_name": "heel(L)"
	},
	{
		"code": "heel(R)",
		"description": "",
		"display_name": "heel(R)"
	},
	{
		"code": "hip(L)",
		"description": "",
		"display_name": "hip(L)"
	},
	{
		"code": "hip(R)",
		"description": "",
		"display_name": "hip(R)"
	},
	{
		"code": "hymen",
		"description": "",
		"display_name": "hymen"
	},
	{
		"code": "hypochondrium(L)",
		"description": "",
		"display_name": "hypochondrium(L)"
	},
	{
		"code": "hypochondrium(R)",
		"description": "",
		"display_name": "hypochondrium(R)"
	},
	{
		"code": "iliac crest(L)",
		"description": "",
		"display_name": "iliac crest(L)"
	},
	{
		"code": "iliac crest(R)",
		"description": "",
		"display_name": "iliac crest(R)"
	},
	{
		"code": "iliac fossa(L)",
		"description": "",
		"display_name": "iliac fossa(L)"
	},
	{
		"code": "iliac fossa(R)",
		"description": "",
		"display_name": "iliac fossa(R)"
	},
	{
		"code": "iliac wing(L)",
		"description": "",
		"display_name": "iliac wing(L)"
	},
	{
		"code": "iliac wing(R)",
		"description": "",
		"display_name": "iliac wing(R)"
	},
	{
		"code": "internal cheek(L)",
		"description": "",
		"display_name": "internal cheek(L)"
	},
	{
		"code": "internal cheek(R)",
		"description": "",
		"display_name": "internal cheek(R)"
	},
	{
		"code": "ischio jambier(L)",
		"description": "",
		"display_name": "ischio jambier(L)"
	},
	{
		"code": "ischio jambier(R)",
		"description": "",
		"display_name": "ischio jambier(R)"
	},
	{
		"code": "jaw",
		"description": "",
		"display_name": "jaw"
	},
	{
		"code": "knee(L)",
		"description": "",
		"display_name": "knee(L)"
	},
	{
		"code": "knee(R)",
		"description": "",
		"display_name": "knee(R)"
	},
	{
		"code": "labia majora(L)",
		"description": "",
		"display_name": "labia majora(L)"
	},
	{
		"code": "labia majora(R)",
		"description": "",
		"display_name": "labia majora(R)"
	},
	{
		"code": "labia minora(L)",
		"description": "",
		"display_name": "labia minora(L)"
	},
	{
		"code": "labia minora(R)",
		"description": "",
		"display_name": "labia minora(R)"
	},
	{
		"code": "lateral side of the foot(L)",
		"description": "",
		"display_name": "lateral side of the foot(L)"
	},
	{
		"code": "lateral side of the foot(R)",
		"description": "",
		"display_name": "lateral side of the foot(R)"
	},
	{
		"code": "little toe (4)(L)",
		"description": "",
		"display_name": "little toe (4)(L)"
	},
	{
		"code": "little toe (4)(R)",
		"description": "",
		"display_name": "little toe (4)(R)"
	},
	{
		"code": "lower chest",
		"description": "",
		"display_name": "lower chest"
	},
	{
		"code": "lower gum",
		"description": "",
		"display_name": "lower gum"
	},
	{
		"code": "lower teeth(L)",
		"description": "",
		"display_name": "lower teeth(L)"
	},
	{
		"code": "lower teeth(R)",
		"description": "",
		"display_name": "lower teeth(R)"
	},
	{
		"code": "lumbar spine",
		"description": "",
		"display_name": "lumbar spine"
	},
	{
		"code": "mouth",
		"description": "",
		"display_name": "mouth"
	},
	{
		"code": "nose",
		"description": "",
		"display_name": "nose"
	},
	{
		"code": "nowhere",
		"description": "",
		"display_name": "nowhere"
	},
	{
		"code": "occiput",
		"description": "",
		"display_name": "occiput"
	},
	{
		"code": "palace",
		"description": "",
		"display_name": "palace"
	},
	{
		"code": "palm(L)",
		"description": "",
		"display_name": "palm(L)"
	},
	{
		"code": "palm(R)",
		"description": "",
		"display_name": "palm(R)"
	},
	{
		"code": "palmar face of the wrist(L)",
		"description": "",
		"display_name": "palmar face of the wrist(L)"
	},
	{
		"code": "palmar face of the wrist(R)",
		"description": "",
		"display_name": "palmar face of the wrist(R)"
	},
	{
		"code": "palmar side of the forearm(L)",
		"description": "",
		"display_name": "palmar side of the forearm(L)"
	},
	{
		"code": "palmar side of the forearm(R)",
		"description": "",
		"display_name": "palmar side of the forearm(R)"
	},
	{
		"code": "penis",
		"description": "",
		"display_name": "penis"
	},
	{
		"code": "pharynx",
		"description": "",
		"display_name": "pharynx"
	},
	{
		"code": "popliteal fossa(L)",
		"description": "",
		"display_name": "popliteal fossa(L)"
	},
	{
		"code": "popliteal fossa(R)",
		"description": "",
		"display_name": "popliteal fossa(R)"
	},
	{
		"code": "posterior aspect of the ankle(L)",
		"description": "",
		"display_name": "posterior aspect of the ankle(L)"
	},
	{
		"code": "posterior aspect of the ankle(R)",
		"description": "",
		"display_name": "posterior aspect of the ankle(R)"
	},
	{
		"code": "posterior chest wall(L)",
		"description": "",
		"display_name": "posterior chest wall(L)"
	},
	{
		"code": "posterior chest wall(R)",
		"description": "",
		"display_name": "posterior chest wall(R)"
	},
	{
		"code": "pubis",
		"description": "",
		"display_name": "pubis"
	},
	{
		"code": "renal fossa(L)",
		"description": "",
		"display_name": "renal fossa(L)"
	},
	{
		"code": "renal fossa(R)",
		"description": "",
		"display_name": "renal fossa(R)"
	},
	{
		"code": "scapula(L)",
		"description": "",
		"display_name": "scapula(L)"
	},
	{
		"code": "scapula(R)",
		"description": "",
		"display_name": "scapula(R)"
	},
	{
		"code": "scrotum",
		"description": "",
		"display_name": "scrotum"
	},
	{
		"code": "shoulder(L)",
		"description": "",
		"display_name": "shoulder(L)"
	},
	{
		"code": "shoulder(R)",
		"description": "",
		"display_name": "shoulder(R)"
	},
	{
		"code": "side of the chest(L)",
		"description": "",
		"display_name": "side of the chest(L)"
	},
	{
		"code": "side of the chest(R)",
		"description": "",
		"display_name": "side of the chest(R)"
	},
	{
		"code": "side of the neck(L)",
		"description": "",
		"display_name": "side of the neck(L)"
	},
	{
		"code": "side of the neck(R)",
		"description": "",
		"display_name": "side of the neck(R)"
	},
	{
		"code": "sole(L)",
		"description": "",
		"display_name": "sole(L)"
	},
	{
		"code": "sole(R)",
		"description": "",
		"display_name": "sole(R)"
	},
	{
		"code": "temple(L)",
		"description": "",
		"display_name": "temple(L)"
	},
	{
		"code": "temple(R)",
		"description": "",
		"display_name": "temple(R)"
	},
	{
		"code": "testicle(L)",
		"description": "",
		"display_name": "testicle(L)"
	},
	{
		"code": "testicle(R)",
		"description": "",
		"display_name": "testicle(R)"
	},
	{
		"code": "thigh(L)",
		"description": "",
		"display_name": "thigh(L)"
	},
	{
		"code": "thigh(R)",
		"description": "",
		"display_name": "thigh(R)"
	},
	{
		"code": "thoracic spine",
		"description": "",
		"display_name": "thoracic spine"
	},
	{
		"code": "thumb(L)",
		"description": "",
		"display_name": "thumb(L)"
	},
	{
		"code": "thumb(R)",
		"description": "",
		"display_name": "thumb(R)"
	},
	{
		"code": "thyroid cartilage",
		"description": "",
		"display_name": "thyroid cartilage"
	},
	{
		"code": "tibia(L)",
		"description": "",
		"display_name": "tibia(L)"
	},
	{
		"code": "tibia(R)",
		"description": "",
		"display_name": "tibia(R)"
	},
	{
		"code": "toe (1)(L)",
		"description": "",
		"display_name": "toe (1)(L)"
	},
	{
		"code": "toe (1)(R)",
		"description": "",
		"display_name": "toe (1)(R)"
	},
	{
		"code": "toe (2)(L)",
		"description": "",
		"display_name": "toe (2)(L)"
	},
	{
		"code": "toe (2)(R)",
		"description": "",
		"display_name": "toe (2)(R)"
	},
	{
		"code": "toe (3)(L)",
		"description": "",
		"display_name": "toe (3)(L)"
	},
	{
		"code": "toe (3)(R)",
		"description": "",
		"display_name": "toe (3)(R)"
	},
	{
		"code": "tonsil(L)",
		"description": "",
		"display_name": "tonsil(L)"
	},
	{
		"code": "tonsil(R)",
		"description": "",
		"display_name": "tonsil(R)"
	},
	{
		"code": "top of the head",
		"description": "",
		"display_name": "top of the head"
	},
	{
		"code": "trachea",
		"description": "",
		"display_name": "trachea"
	},
	{
		"code": "trapezius(L)",
		"description": "",
		"display_name": "trapezius(L)"
	},
	{
		"code": "trapezius(R)",
		"description": "",
		"display_name": "trapezius(R)"
	},
	{
		"code": "triceps(L)",
		"description": "",
		"display_name": "triceps(L)"
	},
	{
		"code": "triceps(R)",
		"description": "",
		"display_name": "triceps(R)"
	},
	{
		"code": "under the jaw",
		"description": "",
		"display_name": "under the jaw"
	},
	{
		"code": "under the tongue",
		"description": "",
		"display_name": "under the tongue"
	},
	{
		"code": "upper chest",
		"description": "",
		"display_name": "upper chest"
	},
	{
		"code": "upper gum",
		"description": "",
		"display_name": "upper gum"
	},
	{
		"code": "upper lip(R)",
		"description": "",
		"display_name": "upper lip(R)"
	},
	{
		"code": "upper teeth(L)",
		"description": "",
		"display_name": "upper teeth(L)"
	},
	{
		"code": "upper teeth(R)",
		"description": "",
		"display_name": "upper teeth(R)"
	},
	{
		"code": "urethra",
		"description": "",
		"display_name": "urethra"
	},
	{
		"code": "uvula",
		"description": "",
		"display_name": "uvula"
	},
	{
		"code": "vagina",
		"description": "",
		"display_name": "vagina"
	},
	{
		"code": "vaginal wall",
		"description": "",
		"display_name": "vaginal wall"
	},
	{
		"code": "vaginal wall(L)",
		"description": "",
		"display_name": "vaginal wall(L)"
	},
	{
		"code": "vaginal wall(R)",
		"description": "",
		"display_name": "vaginal wall(R)"
	},
	{
		"code": "vermilion(L)",
		"description": "",
		"display_name": "vermilion(L)"
	},
	{
		"code": "vermilion(R)",
		"description": "",
		"display_name": "vermilion(R)"
	},
	{
		"code": "vulval vestibule",
		"description": "",
		"display_name": "vulval vestibule"
	},
	{
		"code": "ankle",
		"description": "",
		"display_name": "ankle"
	},
	{
		"code": "axilla",
		"description": "",
		"display_name": "axilla"
	},
	{
		"code": "biceps",
		"description": "",
		"display_name": "biceps"
	},
	{
		"code": "big toe",
		"description": "",
		"display_name": "big toe"
	},
	{
		"code": "bottom lip",
		"description": "",
		"display_name": "bottom lip"
	},
	{
		"code": "breast",
		"description": "",
		"display_name": "breast"
	},
	{
		"code": "buttock",
		"description": "",
		"display_name": "buttock"
	},
	{
		"code": "calf",
		"description": "",
		"display_name": "calf"
	},
	{
		"code": "cheeks",
		"description": "",
		"display_name": "cheeks"
	},
	{
		"code": "commissure",
		"description": "",
		"display_name": "commissure"
	},
	{
		"code": "dorsal aspect of the foot",
		"description": "",
		"display_name": "dorsal aspect of the foot"
	},
	{
		"code": "dorsal aspect of the hand",
		"description": "",
		"display_name": "dorsal aspect of the hand"
	},
	{
		"code": "dorsal aspect of the wrist",
		"description": "",
		"display_name": "dorsal aspect of the wrist"
	},
	{
		"code": "ears",
		"description": "",
		"display_name": "ears"
	},
	{
		"code": "elbows",
		"description": "",
		"display_name": "elbows"
	},
	{
		"code": "eyes",
		"description": "",
		"display_name": "eyes"
	},
	{
		"code": "fingers",
		"description": "",
		"display_name": "fingers"
	},
	{
		"code": "finger (index)",
		"description": "",
		"display_name": "finger (index)"
	},
	{
		"code": "finger (little finger)",
		"description": "",
		"display_name": "finger (little finger)"
	},
	{
		"code": "finger (middle)",
		"description": "",
		"display_name": "finger (middle)"
	},
	{
		"code": "finger (ring finger)",
		"description": "",
		"display_name": "finger (ring finger)"
	},
	{
		"code": "flank",
		"description": "",
		"display_name": "flank"
	},
	{
		"code": "forearm",
		"description": "",
		"display_name": "forearm"
	},
	{
		"code": "groin",
		"description": "",
		"display_name": "groin"
	},
	{
		"code": "heels",
		"description": "",
		"display_name": "heels"
	},
	{
		"code": "hips",
		"description": "",
		"display_name": "hips"
	},
	{
		"code": "hypochondrium",
		"description": "",
		"display_name": "hypochondrium"
	},
	{
		"code": "iliac crest",
		"description": "",
		"display_name": "iliac crest"
	},
	{
		"code": "iliac fossa",
		"description": "",
		"display_name": "iliac fossa"
	},
	{
		"code": "iliac wing",
		"description": "",
		"display_name": "iliac wing"
	},
	{
		"code": "internal cheek",
		"description": "",
		"display_name": "internal cheek"
	},
	{
		"code": "ischio jambier",
		"description": "",
		"display_name": "ischio jambier"
	},
	{
		"code": "knee",
		"description": "",
		"display_name": "knee"
	},
	{
		"code": "labia majora",
		"description": "",
		"display_name": "labia majora"
	},
	{
		"code": "labia minora",
		"description": "",
		"display_name": "labia minora"
	},
	{
		"code": "lateral side of the foot",
		"description": "",
		"display_name": "lateral side of the foot"
	},
	{
		"code": "little toe (4)",
		"description": "",
		"display_name": "little toe (4)"
	},
	{
		"code": "toes",
		"description": "",
		"display_name": "toes"
	},
	{
		"code": "lower teeth",
		"description": "",
		"display_name": "lower teeth"
	},
	{
		"code": "palm",
		"description": "",
		"display_name": "palm"
	},
	{
		"code": "palmar face of the wrist",
		"description": "",
		"display_name": "palmar face of the wrist"
	},
	{
		"code": "palmar side of the forearm",
		"description": "",
		"display_name": "palmar side of the forearm"
	},
	{
		"code": "popliteal fossa",
		"description": "",
		"display_name": "popliteal fossa"
	},
	{
		"code": "posterior aspect of the ankle",
		"description": "",
		"display_name": "posterior aspect of the ankle"
	},
	{
		"code": "posterior chest wall",
		"description": "",
		"display_name": "posterior chest wall"
	},
	{
		"code": "renal fossa",
		"description": "",
		"display_name": "renal fossa"
	},
	{
		"code": "scapula",
		"description": "",
		"display_name": "scapula"
	},
	{
		"code": "shoulders",
		"description": "",
		"display_name": "shoulders"
	},
	{
		"code": "side of the chest",
		"description": "",
		"display_name": "side of the chest"
	},
	{
		"code": "side of the neck",
		"description": "",
		"display_name": "side of the neck"
	},
	{
		"code": "soles",
		"description": "",
		"display_name": "soles"
	},
	{
		"code": "temples",
		"description": "",
		"display_name": "temples"
	},
	{
		"code": "testicles",
		"description": "",
		"display_name": "testicles"
	},
	{
		"code": "thighs",
		"description": "",
		"display_name": "thighs"
	},
	{
		"code": "thumbs",
		"description": "",
		"display_name": "thumbs"
	},
	{
		"code": "tibia",
		"description": "",
		"display_name": "tibia"
	},
	{
		"code": "toe (1)",
		"description": "",
		"display_name": "toe (1)"
	},
	{
		"code": "toe (2)",
		"description": "",
		"display_name": "toe (2)"
	},
	{
		"code": "toe (3)",
		"description": "",
		"display_name": "toe (3)"
	},
	{
		"code": "tonsils",
		"description": "",
		"display_name": "tonsils"
	},
	{
		"code": "trapezius",
		"description": "",
		"display_name": "trapezius"
	},
	{
		"code": "triceps",
		"description": "",
		"display_name": "triceps"
	},
	{
		"code": "upper lip",
		"description": "",
		"display_name": "upper lip"
	},
	{
		"code": "upper teeth",
		"description": "",
		"display_name": "upper teeth"
	},
	{
		"code": "vaginal wall",
		"description": "",
		"display_name": "vaginal wall"
	},
	{
		"code": "vermilion",
		"description": "",
		"display_name": "vermilion"
	},
	{
		"code": "neck",
		"description": "",
		"display_name": "neck"
	},
	{
		"code": "chest",
		"description": "",
		"display_name": "chest"
	},
	{
		"code": "limbs",
		"description": "",
		"display_name": "limbs"
	},
	{
		"code": "leg(L)",
		"description": "",
		"display_name": "leg(L)"
	},
	{
		"code": "leg(R)",
		"description": "",
		"display_name": "leg(R)"
	},
	{
		"code": "legs",
		"description": "",
		"display_name": "legs"
	},
	{
		"code": "arm(L)",
		"description": "",
		"display_name": "arm(L)"
	},
	{
		"code": "arm(R)",
		"description": "",
		"display_name": "arm(R)"
	},
	{
		"code": "arms",
		"description": "",
		"display_name": "arms"
	},
];

var symptom_config = [
	{
		"name": "value",
		"type": "datalist",
		"values": all_symptom_values,
		"label": "Enter symptom",
	},
	{
		"name": "status",
		"type": "select",
		"values": ["Yes", "No", "Not sure"],
		"label": "Is patient currently suffering from the selected symptom(s)?",
		"default": { "patient": "Yes", "doctor": "disabled" },
	},
	{
		"name": "location",
		"type": "datalist",
		"values": all_symptom_locations,
		"label": "Where is the symptom(s) located?",
		"add_checkbox": ["inquire"]
	},
	{
		"name": "when",
		"type": "text",
		"label": "When did this symptom(s) appear?",
		"add_checkbox": ["inquire"],
	},
	{
		"name": "how",
		"type": "datalist",
		"values": [
			{
				"code": "abruptly",
				"description": "Symptom appeared all of a sudden",
				"display_name": "abruptly"
			},
			{
				"code": "gradually",
				"description": "Symptom appeared gradually (in steps)",
				"display_name": "gradually"
			},
		],
		"label": "How did this symptom(s) appear (abruptly, gradually, etc.)?",
		"add_checkbox": ["inquire"],
	},
	{
		"name": "duration",
		"type": "datalist",
		"values": [
			{
				"code": "few minutes",
				"description": "",
				"display_name": "for few minutes"
			},
			{
				"code": "few hours",
				"description": "",
				"display_name": "for few hours"
			},
			{
				"code": "few days",
				"description": "",
				"display_name": "for few days"
			},
		],
		"label": "How long does this symptom(s) last (few minutes, few days, etc.)?",
		"add_checkbox": ["inquire"],
	},
	{
		"name": "severity",
		"type": "select",
		"values": ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
		"label": "What is the severity of this symptom(s) on scale of 10 (or an indirection like can patient perform his/her day to day activity.)?",
		"chkbox_on": ["inquire", "qa", "recommendation", "diagnosis", "confirmation", "salutations"],
		"add_text": ["inform"],
		"aux_value": {
			"tag": "criterion",
			"placeholder": "criterion"
		}
	},
	{
		"name": "characteristics",
		"type": "datalist",
		"values": [
			{
				"code": "a cramp",
				"description": "",
				"display_name": "a cramp"
			},
			{
				"code": "a knife stroke",
				"description": "",
				"display_name": "a knife stroke"
			},
			{
				"code": "a pulse",
				"description": "",
				"display_name": "a pulse"
			},
			{
				"code": "burning",
				"description": "",
				"display_name": "burning"
			},
			{
				"code": "exhausting",
				"description": "",
				"display_name": "exhausting"
			},
			{
				"code": "haunting",
				"description": "",
				"display_name": "haunting"
			},
			{
				"code": "heartbreaking",
				"description": "",
				"display_name": "heartbreaking"
			},
			{
				"code": "heavy",
				"description": "",
				"display_name": "heavy"
			},
			{
				"code": "scary",
				"description": "",
				"display_name": "scary"
			},
			{
				"code": "sensitive",
				"description": "",
				"display_name": "sensitive"
			},
			{
				"code": "sharp",
				"description": "",
				"display_name": "sharp"
			},
			{
				"code": "sickening",
				"description": "",
				"display_name": "sickening"
			},
			{
				"code": "tedious",
				"description": "",
				"display_name": "tedious"
			},
			{
				"code": "tugging",
				"description": "",
				"display_name": "tugging"
			},
			{
				"code": "violent",
				"description": "",
				"display_name": "violent"
			}
		],
		"label": "What are the characteristics of the symptom(s) (burning pain and dry cough etc.)?",
		"add_checkbox": ["inquire"],
		"add_select": ["inform"],
		"aux_values": [
			{
				"code": "yes",
				"description": "1. yes, patient confirms this characteristic of the symptom"
			}, {
				"code": "no",
				"description": "2. no, patient does not confirm this characteristic of the symptom"
			}, {
				"code": "may be",
				"description": "3. not sure, patient is unsure about this characteristic of the symptom"
			}
		]
	},
	{
		"name": "ana factors",
		"type": "datalist",
		"values": [
			{
				"orig_code": "ww_respi",
				"code": "deep breathing",
				"description": "Pain increases with deep breating",
				"display_name": "Deep Breathing"
			},
			{
				"orig_code": "ww_effort",
				"code": "physical exertion",
				"description": "Symptoms worsen with physical exertion but alleviate with rest",
				"display_name": "Physical Exertion"
			},
			{
				"orig_code": "ww_bouger",
				"code": "movement",
				"description": "Pain increases with movement.",
				"display_name": "Movement"
			},
			{
				"orig_code": "ww_dd",
				"code": "lying down",
				"description": "Symptoms worsen when lying down and alleviate while sitting up.",
				"display_name": "Lying Down"
			},
			{
				"orig_code": "pain_leaning_forward",
				"code": "lean forward",
				"description": "Pain increases on leaning forward.",
				"display_name": "Lean Forward"
			},
			{
				"orig_code": "ww_bouffe",
				"code": "eating",
				"description": "Symptoms worsen after eating.",
				"display_name": "Eating"
			},
			{
				"orig_code": "ww_valsalva",
				"code": "cough weight lift bowel movement",
				"description": "Symptoms or pain increase with coughing or with an effort like lifting a weight or from forcing a bowel movement",
				"display_name": "Coughing/Lifting/Bowel Movement"
			},
			{
				"orig_code": "ww_nuit",
				"code": "night",
				"description": "Symptoms are prominent at night.",
				"display_name": "Night"
			},
		],
		"label": "What factors cause symptom(s) to improve or get worse (alleviating/aggravating factors like symptoms get worse with exercise)?",
		"add_checkbox": ["inquire"],
		"add_select": ["inform"],
		"aux_values": [
			{
				"code": "yes alleviating",
				// "description": "1. yes, patient confirms this alleviating/aggravating factor for the symptom."
				"description": "alleviating factor for the symptom."
			}, {
				"code": "no alleviating",
				// "description": "1. yes, patient confirms this alleviating/aggravating factor for the symptom."
				"description": "not an alleviating factor for the symptom."
			}, {
				"code": "yes aggravating",
				// "description": "2. no, patient does not confirm this alleviating/aggravating factor for the symptom."
				"description": "aggravating factor for the symptom."
			}, {
				"code": "no aggravating",
				// "description": "2. no, patient does not confirm this alleviating/aggravating factor for the symptom."
				"description": "not an aggravating factor for the symptom."
			}, {
				"code": "may be",
				"description": "not sure, patient is unsure about this alleviating/aggravating factor for the symptom."
			}, {
				"code": "neither allevating nor aggrevating",
				"description": "neither allevating nor aggrevating."
			}
		]
	},
	{
		"name": "progression",
		"type": "select",
		"values": [
			"unchanged with time",
			"gradually getting worse over time",
			"gradually getting better over time",
			"rapidly getting worse over time",
			"rapidly getting better over time",
			"fluctuating"
		],
		"label": "How is the symptom(s)'s progression over time (eg. cough has increased over time)?",
		"add_checkbox": ["inquire"],
	},
	{
		"name": "volume",
		"type": "text",
		"add_checkbox": ["inquire"],
		"label": "Volume if applicable to the symptom (eg. amount of sputum)"
	},
	{
		"name": "color",
		"type": "text",
		"add_checkbox": ["inquire"],
		"label": "Color if applicable to the symptom (eg. color of sputum)"
	},
	{
		"name": "frequency",
		"type": "text",
		"add_checkbox": ["inquire"],
		"label": "Frequency if applicable to the symptom (eg. patient coughs 3-4 times a day)"
	},
	{
		"name": "other",
		"type": "text",
		"label": "Any additional information missing from the above fields"
	}
]