#!/bin/bash
source /opt/rh/devtoolset-10/enable

model_name=$1
behaviors_path=$2
test_cases_path=$3
save_path=$4
max_new_tokens=$5
incremental_update=$6

echo "model_name=$model_name"
echo "behaviors_path=$behaviors_path"
echo "test_cases_path=$test_cases_path"
echo "max_new_tokens=$max_new_tokens"
echo "save_path=$save_path"
echo "incremental_update=$incremental_update"

# Construct the base command
cmd="python3 -u generate_completions.py \
    --model_name $model_name \
    --behaviors_path $behaviors_path \
    --test_cases_path $test_cases_path \
    --save_path $save_path \
    --max_new_tokens $max_new_tokens \
    --generate_with_vllm"

# Check if incremental_update is provided and equals "True"
if [[ ! -z "$incremental_update" && "$incremental_update" == "True" ]]; then
    cmd="$cmd --incremental_update"
fi

# Execute the command
eval $cmd
