theory question_87_8
imports Main

begin

typedecl entity
typedecl event

consts
  Limestone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  FoundIn :: "entity ⇒ entity ⇒ bool"
  HistoryOfLivingOrganisms :: "entity ⇒ bool"
  Past :: "entity ⇒ bool"
  CanBeUsedFor :: "entity ⇒ entity ⇒ bool"
  StudyingHistory :: "entity ⇒ bool"
  StudyingHistoryOfLivingOrganisms :: "entity ⇒ bool"
  GoodFor :: "entity ⇒ bool"
  Useful :: "entity ⇒ bool"

(* Explanation 1: Limestone is a type of sedimentary rock. *)
axiomatization where
  explanation_1: "∀x. Limestone x ⟶ SedimentaryRock x"

(* Explanation 2: Fossils are commonly found in limestone. *)
axiomatization where
  explanation_2: "∀x y. Limestone x ∧ Fossils y ⟶ FoundIn x y"

(* Explanation 3: The history of living organisms occurred in the past. *)
axiomatization where
  explanation_3: "∀x. HistoryOfLivingOrganisms x ⟶ Past x"

(* Explanation 4: Something from the past can be used for studying history. *)
axiomatization where
  explanation_4: "∀x. Past x ⟶ (∃y. CanBeUsedFor y (StudyingHistory x))"

(* Explanation 5: Useful, in this context, means good for studying the history of living organisms. *)
axiomatization where
  explanation_5: "Useful ≝ GoodFor (StudyingHistoryOfLivingOrganisms)"

theorem hypothesis:
  assumes asm: "Limestone x"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "Useful x"
proof -
  from asm have "SedimentaryRock x" using explanation_1 by blast
  then have "Past x" using explanation_3 by blast
  then have "CanBeUsedFor y (StudyingHistory x)" for y some using explanation_4 by blast
  then have "GoodFor (StudyingHistoryOfLivingOrganisms) x" using explanation_5 by blast
  then show "Useful x" using explanation_5 by simp
qed

end
