theory question_65_10
imports Main

begin

typedecl entity
typedecl event

consts
  ClosedSwitch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Allows :: "entity ⇒ event ⇒ bool"
  Flow :: "event ⇒ entity ⇒ entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  CanReach :: "entity ⇒ entity ⇒ event ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  LightOn :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A closed switch in a simple series circuit allows electricity to flow through the circuit. *)
axiomatization where
  explanation_1: "∀x y e. ClosedSwitch x ∧ SimpleSeriesCircuit y ∧ Allows x e ∧ Flow e x y"

(* Explanation 2: When electricity flows through the circuit, it can reach the light bulb. *)
axiomatization where
  explanation_2: "∀x y e. Electricity x ∧ Flow e x y ⟶ CanReach x y e"

theorem hypothesis:
  (* Premise: A closed switch in a simple series circuit allows electricity to flow through the circuit. *)
  assumes asm: "ClosedSwitch s ∧ SimpleSeriesCircuit c ∧ Allows s e ∧ Flow e s c ∧ Electricity  some entity. True "
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "LightBulb l ∧ LightOn l e"
proof -
  from asm have "Electricity s" by simp
  then have "Flow e s c" using asm by simp
  then have "CanReach s c e" using explanation_2 by blast
  then have "LightBulb l ∧ LightOn l e" using asm explanation_1 by blast
qed

end
