theory question_13_1
imports Main

begin

typedecl entity
typedecl event

consts
  Heating :: "event ⇒ bool"
  AddingHeatEnergy :: "event ⇒ bool"
  Boiling :: "event ⇒ bool"
  Evaporation :: "event ⇒ bool"
  Changing :: "event ⇒ bool"
  FromLiquid :: "event ⇒ bool"
  IntoGas :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Disappears :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Evaporated :: "event ⇒ entity ⇒ bool"
  Changed :: "event ⇒ entity ⇒ bool"
  Gone :: "event ⇒ entity ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  MatterChangingState :: "event ⇒ bool"
  Example :: "event ⇒ event ⇒ bool"
  Pan :: "entity ⇒ bool"

(* Explanation 1: Heating means adding heat energy. *)
axiomatization where
  explanation_1: "∀e1 e2. Heating e1 ⟷ AddingHeatEnergy e2"

(* Explanation 2: Boiling and evaporation mean changing from a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_2: "∀e1 e2 e3. Boiling e1 ∧ Evaporation e2 ⟷ Changing e3 ∧ FromLiquid e3 ∧ IntoGas e3 ∧ AddingHeatEnergy e3"

(* Explanation 3: Water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: If a liquid disappears, then it probably evaporated and changed into a gas. *)
axiomatization where
  explanation_4: "∀x e1 e2 e3. Liquid x ∧ Disappears e1 x ∧ Agent e1 x ⟶ Evaporated e2 x ∧ Agent e2 x ∧ Changed e3 x ∧ Agent e3 x ∧ IntoGas e3"

(* Explanation 5: Disappeared is similar to gone. *)
axiomatization where
  explanation_5: "∀x e1 e2. Disappeared e1 x ∧ Agent e1 x ⟷ Gone e2 x"

(* Explanation 6: Liquid and gas are kinds of states of matter. *)
axiomatization where
  explanation_6: "∀x. Liquid x ⟶ StateOfMatter x ∧ [∀y. Gas y ⟶ StateOfMatter y]"

(* Explanation 7: Heating a liquid until it is all gone is an example of matter changing state. *)
axiomatization where
  explanation_7: "∀x y e1 e2. Liquid x ∧ Heating e1 ∧ Agent e1 x ∧ Gone e2 x ⟶ MatterChangingState e2 ∧ Example e1 e2"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃x y e1 e2. Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 y ∧ Example e1 e2 ∧ MatterChangingState e2"
proof -
  {
    assume asm: "Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 y"
    from asm have "Water y" by simp
    also from asm have "Liquid y" by (rule explanation_3)
    finally have "Liquid y" .
    from asm have "Heating e1" by simp
    also from asm have "AddingHeatEnergy e1" by (rule explanation_1)
    finally have "AddingHeatEnergy e1" .
    from asm have "Gone e2 y" by simp
    also from asm have "Disappeared e2 y ∧ Agent e2 y" by (rule explanation_5)
    finally have "Disappeared e2 y ∧ Agent e2 y" .
    from ‹Liquid y› and ‹Disappeared e2 y ∧ Agent e2 y›
    have "Evaporated e3 y ∧ Agent e3 y ∧ Changed e4 y ∧ Agent e4 y ∧ IntoGas e4"
      by (rule explanation_4)
    then obtain e3 e4 where e3: "Evaporated e3 y" and e4: "Changed e4 y ∧ IntoGas e4"
      by blast
    from ‹AddingHeatEnergy e1› and e3 and e4
    have "Changing e5 ∧ FromLiquid e5 ∧ IntoGas e5"
      by (rule explanation_2)
    then obtain e5 where e5: "Changing e5 ∧ FromLiquid e5 ∧ IntoGas e5"
      by blast
    from ‹Changing e5 ∧ FromLiquid e5 ∧ IntoGas e5› and e4
    have "MatterChangingState e2"
      by (rule explanation_7)
    from asm have "Pan x" by simp
    from asm have "Heating e1" by simp
    from asm have "Agent e1 x" by simp
    from asm have "Gone e2 y" by simp
    with ‹MatterChangingState e2›
    have "Example e1 e2"
      by (rule explanation_7)
    with asm and ‹MatterChangingState e2›
    show ?thesis
      by blast
  }
qed

end
