theory question_85_3
imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"
  PacinianCorpuscles :: "entity ⇒ bool"
  LocationProperty :: "(entity ⇒ bool) ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 2: Pacinian corpuscles are a specific type of pressure receptors and share the same location properties as pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x ∧ (∀P. LocationProperty P ⟶ (P x ⟷ P (PressureReceptors)))"

(* Explanation 3: All location properties of pressure receptors apply to Pacinian corpuscles. *)
axiomatization where
  explanation_3: "∀x y. PressureReceptors x ∧ LocationProperty y ⟶ y x ⟹ y PacinianCorpuscles"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  have "PacinianCorpuscles x" by fact
  then have "PressureReceptors x" using explanation_2 by blast
  then have "MainlyFoundIn x Skin" using explanation_1 by blast
  then show ?thesis by blast
qed

end
