theory question_42_0

imports Main

begin

typedecl entity
typedecl event

consts
  Birds :: "entity ⇒ bool"
  Theropods :: "entity ⇒ bool"
  Evolved :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Dromaeosaurs :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Birds evolved from a group of bipedal dinosaurs called theropods. *)
axiomatization where
  explanation_1: "∀x y e. Birds x ∧ Theropods y ∧ Evolved e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Dromaeosaurs are part of the theropod group of dinosaurs. *)
axiomatization where
  explanation_2: "∀x y. Dromaeosaurs x ∧ Theropods y ∧ PartOf x y"

theorem hypothesis:
  assumes asm: "BipedalDinosaurs x ∧ Theropods y ∧ Dromaeosaurs z ∧ Evolved e ∧ Agent e x ∧ Patient e y ∧ Patient e z"
  (* Hypothesis: The group of bipedal dinosaurs that included Dromaeosaurs eventually evolved into birds. *)
  shows "∃x y e. Birds x ∧ Theropods y ∧ Evolved e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BipedalDinosaurs x ∧ Theropods y ∧ Dromaeosaurs z" by simp
  then obtain e1 where e1: "Evolved e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "PartOf z y" using explanation_2 by blast
  have conclusion: "Evolved e1 ∧ Agent e1 x ∧ Patient e1 y ∧ PartOf z y" using e1 by simp
  show ?thesis using asm conclusion `Birds x` by blast
qed

end
