theory question_63_3

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  Deposition :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Rocks are formed by deposition specifically into sandstone. *)
axiomatization where
  explanation_1: "∀x y e. Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y ⟶ Sandstone x"

(* Explanation 2: Sandstone is a common type of rock that is formed by deposition. *)
axiomatization where
  explanation_2: "∀x y e. Sandstone x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y ⟶ Rocks x"  

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y" by simp
  then have "Sandstone x" using explanation_1 by blast
  then show ?thesis using asm `Sandstone x` by blast
qed

end
