theory question_23_0
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricanes :: "entity ⇒ bool"
  HighWinds :: "entity ⇒ bool"
  Speeds :: "entity ⇒ bool"
  Has :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"

(* Explanation 1: A hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x y e. Hurricanes x ∧ HighWinds y ∧ Speeds e ∧ Has e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: A tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀x y e. Tornadoes x ∧ HighWinds y ∧ Speeds e ∧ Has e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "Hurricanes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e1 y. HighWinds y ∧ Has e1 ∧ Agent e1 x ∧ Patient e1 y ∧  ∀z. Tornadoes z ∧ HighWinds y ∧ Has e1 ∧ Agent e1 z ∧ Patient e1 y "
proof -
  from asm have "Hurricanes x" by simp
  then obtain e1 y where e1y: "HighWinds y ∧ Has e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Tornadoes z ∧ HighWinds y ∧ Has e1 ∧ Agent e1 z ∧ Patient e1 y" for z using explanation_2 by blast
  show ?thesis using e1y by blast
qed

end
