theory question_38_0
imports Main

begin
typedecl entity
typedecl event

consts
  Couple :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Sunset :: "entity ⇒ bool"
  Sundown :: "entity ⇒ bool"
  Romantic :: "event ⇒ bool"
  Being :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Enjoying :: "entity ⇒ bool"

(* Explanation 1: A couple consists of people. *)
axiomatization where
  explanation_1: "∀x. Couple x ⟶ People x"

(* Explanation 2: Sunset is sundown. *)
axiomatization where
  explanation_2: "∀x. Sunset x ⟶ Sundown x"

theorem hypothesis:
  (* Premise: A couple being romantic under the sunset. *)
  assumes asm: "Couple x ∧ Sunset y ∧ Romantic e ∧ Being e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: People are enjoying sundown. *)
  shows "∃x e. People x ∧ Sundown e ∧ Enjoying e ∧ Agent e x"
proof -
  from asm have "Couple x" by blast
  from this have "People x" using explanation_1 by blast
  from asm have "Sunset y" by blast
  then have "Sundown y" using explanation_2 by blast
  show ?thesis using `People x` `Sundown y` by blast
qed

end
