/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Fmt;
import fig.basic.NumUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ValueProcessor {
    private List<Processor> processors = new ArrayList<Processor>();

    private int getInt(String s, int defaultValue) {
        int i = s.indexOf(58);
        if (i == -1) {
            return defaultValue;
        }
        return Integer.parseInt(s.substring(i + 1));
    }

    public ValueProcessor(String description) {
        if (description == null) {
            return;
        }
        String[] stringArray = StrUtils.split(description, "\t");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String subStr = stringArray[n2];
            if (subStr.startsWith("DOUBLE")) {
                this.processors.add(new DoubleFormatProcessor(this.getInt(subStr, 3)));
            } else if (subStr.startsWith("TRUNCATE:")) {
                this.processors.add(new TruncateStringFormatProcessor(this.getInt(subStr, 10)));
            } else if (subStr.equals("DATE")) {
                this.processors.add(new DateFormatProcessor());
            } else if (subStr.equals("BYTES")) {
                this.processors.add(new BytesFormatProcessor());
            } else {
                subStr = subStr.replaceAll("\\\\/", "__SLASH__");
                String[] tokens = StrUtils.split(subStr, "/");
                int i = 0;
                while (i < tokens.length) {
                    tokens[i] = tokens[i].replaceAll("__SLASH__", "/");
                    ++i;
                }
                if (tokens.length != 0 && tokens[0].equals("s")) {
                    if (tokens.length == 2) {
                        tokens = new String[]{tokens[0], tokens[1], "", ""};
                    }
                    if (tokens.length == 3) {
                        tokens = new String[]{tokens[0], tokens[1], tokens[2], ""};
                    }
                    if (tokens.length == 4) {
                        this.processors.add(new ReplaceProcessor(tokens[1], tokens[2], tokens[3].equals("g")));
                    }
                }
            }
            ++n2;
        }
    }

    public String process(String s) {
        if (s == null) {
            return null;
        }
        for (Processor processor : this.processors) {
            s = processor.process(s);
        }
        return s;
    }

    public boolean isIdentity() {
        return this.processors.size() == 0;
    }

    public String toString() {
        return StrUtils.join(this.processors, "\t");
    }

    static class BytesFormatProcessor
    implements Processor {
        BytesFormatProcessor() {
        }

        @Override
        public String process(String s) {
            try {
                return Fmt.bytesToString(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                return s;
            }
        }
    }

    static class DateFormatProcessor
    implements Processor {
        private static final DateFormat standardDateFormat = new SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy");

        DateFormatProcessor() {
        }

        @Override
        public String process(String s) {
            try {
                Date d = standardDateFormat.parse(s);
                return Fmt.formatEasyDateTime(d.getTime());
            }
            catch (ParseException e) {
                return s;
            }
        }

        public String toString() {
            return "DATE";
        }
    }

    static class DoubleFormatProcessor
    implements Processor {
        private int max;

        public DoubleFormatProcessor(int max) {
            this.max = max;
        }

        @Override
        public String process(String s) {
            String[] tokens = s.split(";");
            ArrayList<String> newTokens = new ArrayList<String>();
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                double x = Utils.parseDoubleEasy(token);
                if (Double.isNaN(x)) {
                    newTokens.add(token);
                } else if (this.max == 0) {
                    newTokens.add(String.valueOf(Math.round(x)));
                } else {
                    newTokens.add(String.valueOf(NumUtils.round(x, this.max)));
                }
                ++n2;
            }
            return StrUtils.join(newTokens, ";");
        }

        public String toString() {
            return "DOUBLE:" + this.max;
        }
    }

    static interface Processor {
        public String process(String var1);
    }

    static class ReplaceProcessor
    implements Processor {
        private final String a;
        private final String b;
        private final boolean global;

        public ReplaceProcessor(String a, String b, boolean global) {
            this.a = a;
            this.b = b;
            this.global = global;
        }

        @Override
        public String process(String s) {
            if (s == null) {
                return null;
            }
            if (this.global) {
                return s.replaceAll(this.a, this.b);
            }
            return s.replaceFirst(this.a, this.b);
        }

        public String toString() {
            return String.format("s/%s/%s/%s", this.a, this.b, this.global ? "g" : "");
        }
    }

    static class TruncateStringFormatProcessor
    implements Processor {
        private int max;

        public TruncateStringFormatProcessor(int max) {
            this.max = max;
        }

        @Override
        public String process(String s) {
            if (s.length() <= this.max) {
                return s;
            }
            return "<a title=\"" + s + "\">" + s.substring(0, this.max) + "...</a>";
        }

        public String toString() {
            return "TRUNCATE:" + this.max;
        }
    }
}

