/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.filters;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import java.util.regex.Pattern;

public class RomanizationFilter
implements EquivalenceClassFilter {
    protected static final Pattern ROMAN_CHARS_PATTERN = Pattern.compile("[a-zA-Z]");

    @Override
    public boolean acceptEquivalenceClass(EquivalenceClass eqClass) {
        boolean accept = false;
        if (eqClass != null) {
            boolean match = false;
            for (String word : eqClass.getAllWords()) {
                match = ROMAN_CHARS_PATTERN.matcher(word).find();
                if (match) break;
            }
            accept = !match;
        }
        return accept;
    }
}

