package org.maltparser.parser.algorithm.ucovington;


import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
/**
 * @author Johan Hall
 *
 */
public abstract class UcovingtonFactory implements AbstractParserFactory {
	protected Algorithm algorithm;
	protected DependencyParserConfig manager;
	
	public UcovingtonFactory(Algorithm algorithm) {
		setAlgorithm(algorithm);
		setManager(algorithm.getManager());
	}
	
	public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
		boolean allowRoot = (Boolean)manager.getOptionValue("covington", "allow_root");
		boolean allowShift = (Boolean)manager.getOptionValue("covington", "allow_shift");
		String recon = (String)manager.getOptionValue("covington", "creconstruction");
		String heuristic = (String)manager.getOptionValue("covington", "cheuristic");
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Parser configuration : Undirected Covington with allow_root="+allowRoot+" and allow_shift="+allowShift+". Reconstruction technique = "+recon+". Heuristic = "+heuristic+"\n");
		}
		UcovingtonConfig config = new UcovingtonConfig(manager.getSymbolTables(), allowRoot, allowShift,recon,heuristic);
		return config;
	}
	
	public Function makeFunction(String subFunctionName) throws MaltChainedException {
		return new UcovingtonAddressFunction(subFunctionName, algorithm);
	}
	
	public Algorithm getAlgorithm() {
		return algorithm;
	}

	public void setAlgorithm(Algorithm algorithm) {
		this.algorithm = algorithm;
	}
	
	public DependencyParserConfig getManager() {
		return manager;
	}

	public void setManager(DependencyParserConfig manager) {
		this.manager = manager;
	}
}

