#!/usr/bin/env perl

# Tidy JUMAN.katuyou and *.dic

use strict;
use utf8;

binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

my %data_;
&main();

sub main {
    
    my $level = 0;
    my $str = "";
    while ( <STDIN> ) {
	chomp;
	( $str, $level ) = &parse( $str, &remove_space( &remove_comment( $_ ) ), $level );
    }
    for ( keys %data_ ) {
	print "$_\n";
    }
}


sub remove_comment {

    my ( $line ) = @_;
    $line =~ s/^;.*//;
    $line =~ s/\s;.*//;
    $line =~ s/;\s.*//;
    return $line;
}


sub remove_space {

    my ( $str ) = @_;
    $str =~ s/^[ \t]+//;
    $str =~ s/[ \t]+$//;
    $str =~ s/[ \t][ \t]+/ /g;
    $str =~ s/[ \t]+\(/\(/g;
    $str =~ s/[ \t]+\)/\)/g;
    $str =~ s/\)[ \t]+/\)/g;
    $str =~ s/\([ \t]+/\(/g;
    return $str;
}


sub parse {

    my ( $str, $line, $level ) = @_;

    for my$c ( split( //, $line ) ) {
	$level++ if ( $c eq "(" );
	$level-- if ( $c eq ")" );
	$str .= $c;
	if ( $level == 0 && 0 < length( $str ) ) {
	    if ( $str =~ /^\(連語\((.+)\)[\d\.]*\)$/ ) {
		&parse( "", $1, 0 );
	    }else {
		$data_{$str} = 1;
	    }
	    $str = "";
	}
    }
    return ( $str, $level );
}
