/*
 * Decompiled with CFR 0.152.
 */
package tsg.parseEval;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import tsg.Constituency;
import tsg.ConstituencyWords;
import tsg.TSNodeLabel;
import util.FileUtil;
import util.Utility;

public class EvalC {
    private static boolean LABELED = true;
    public static boolean REMOVE_SEMANTIC_TAGS = true;
    public static boolean DELETE_BACK_SLASH = true;
    public static int CUTOFF_LENGTH = 40;
    public static int CONSTITUENTS_UNIT = 0;
    public static String ENCODING = "UTF-8";
    public static int SENTENCE_LENGTH_LIMIT = Integer.MAX_VALUE;
    public static String[] EXCLUDE_CAT = new String[]{"TOP", "S1"};
    public static String[] EXCLUDE_POS = new String[0];
    public static String[] DELETE_LABELS = new String[]{"!", "''", ",", "-NONE-", ".", ":", "?", "``"};
    public static String[] DELETE_LABEL_FOR_LENGTH = new String[]{"-NONE-"};
    public static String[][] EQUAL_LABELS = new String[][]{{"PRT", "ADVP"}};
    public static NumberFormat formatter = new DecimalFormat("0.00");
    PrintWriter out;
    PrintWriter log;
    File goldFile;
    File testFile;
    File outputFile;
    File logFile;
    ArrayList<TSNodeLabel> goldCorpus;
    ArrayList<TSNodeLabel> testCorpus;
    int sentences;
    int totalMatchBrackets;
    int totalGoldBrackets;
    int totalTestBrackets;
    int totalCrossBracket;
    int totalWords;
    int totalCorrectTags;
    int totalExactMatch;
    int noCrossing;
    int twoOrLessCrossing;
    float totalRecallPercentage;
    float totalPrecisionPercentage;
    float taggingAccuracyPercentage;
    boolean areCompatible;
    int[] sentencesLength;
    Hashtable<String, Integer> crossingBracketsCatTable;
    Hashtable<String, int[]> categoryStatistics;
    Hashtable<String, Integer> wrongCatStatistics;
    int totalCategoryGold;
    int sentencesMSL;
    int totalMatchBracketsMSL;
    int totalGoldBracketsMSL;
    int totalTestBracketsMSL;
    int totalCrossBracketMSL;
    int totalWordsMSL;
    int totalCorrectTagsMSL;
    int totalExactMatchMSL;
    int noCrossingMSL;
    int twoOrLessCrossingMSL;
    float totalRecallPercentageMSL;
    float totalPrecisionPercentageMSL;
    float taggingAccuracyPercentageMSL;
    HashSet<Integer> skipSentences;

    public static void setLabeled(boolean l) {
        LABELED = l;
    }

    public static boolean getLabeled() {
        return LABELED;
    }

    public EvalC(File goldFile, File testFile, File outputFile, File logFile, boolean preprocess) {
        this.goldFile = goldFile;
        this.testFile = testFile;
        this.outputFile = outputFile;
        this.logFile = logFile;
        this.getTreebanks();
        this.getSentencesLength();
        if (preprocess) {
            this.preprocessCorporaAndCheckCompatibility();
        }
    }

    public EvalC(File goldFile, File testFile, File outputFile, File logFile) {
        this(goldFile, testFile, outputFile, logFile, true);
    }

    public EvalC(ArrayList<TSNodeLabel> goldCorpus, ArrayList<TSNodeLabel> testCorpus, File outputFile, File logFile) {
        this.goldCorpus = goldCorpus;
        this.testCorpus = testCorpus;
        this.outputFile = outputFile;
        this.logFile = logFile;
        this.getSentencesLength();
        this.preprocessCorporaAndCheckCompatibility();
    }

    public EvalC(File goldFile, File testFile, File outputFile) {
        this(goldFile, testFile, outputFile, null);
    }

    public void setGoldFile(File goldFile) {
        this.goldFile = goldFile;
        try {
            this.goldCorpus = TSNodeLabel.getTreebank(goldFile, ENCODING, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTestFile(File testFile) {
        this.testFile = testFile;
        try {
            this.testCorpus = TSNodeLabel.getTreebank(testFile, ENCODING, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public int size() {
        return this.goldCorpus.size();
    }

    public ArrayList<TSNodeLabel> getGoldCorpus() {
        return this.goldCorpus;
    }

    public ArrayList<TSNodeLabel> getTestCorpus() {
        return this.testCorpus;
    }

    public boolean areComparable() {
        return this.areCompatible;
    }

    public static float[] staticEvalC(File goldFile, File testFile, File outputFile, File logFile, boolean preprocess) {
        EvalC EC = new EvalC(goldFile, testFile, outputFile, logFile, preprocess);
        if (!EC.areCompatible) {
            return null;
        }
        return EC.makeEval();
    }

    public static float[] staticEvalC(File goldFile, File testFile, File outputFile, File logFile) {
        EvalC EC = new EvalC(goldFile, testFile, outputFile, logFile);
        if (!EC.areCompatible) {
            return null;
        }
        return EC.makeEval();
    }

    public static float[] staticEvalC(File goldFile, File testFile, File outputFile) {
        return EvalC.staticEvalC(goldFile, testFile, outputFile, null);
    }

    public static void readParametersFromFile(File inputFile) {
        Scanner scan = FileUtil.getScanner(inputFile, ENCODING);
        ArrayList<String> exclude_cat_array = new ArrayList<String>();
        ArrayList<String> exclude_pos_array = new ArrayList<String>();
        ArrayList<String> delete_pos_array = new ArrayList<String>();
        ArrayList<String[]> equal_labels_array = new ArrayList<String[]>();
        while (scan.hasNextLine()) {
            String line = scan.nextLine().trim();
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            int spaceIndex = line.indexOf(32);
            String key = line.substring(0, spaceIndex);
            String value = line.substring(spaceIndex + 1);
            if (key.equals("LABELED")) {
                LABELED = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("CONSTITUENTS_UNIT")) {
                CONSTITUENTS_UNIT = Integer.parseInt(value);
                continue;
            }
            if (key.equals("REMOVE_SEMANTIC_TAGS")) {
                REMOVE_SEMANTIC_TAGS = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("CUTOFF_LENGTH")) {
                CUTOFF_LENGTH = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ENCODING")) {
                ENCODING = value;
                continue;
            }
            if (key.equals("EXCLUDE_CAT")) {
                exclude_cat_array.add(value);
                continue;
            }
            if (key.equals("EXCLUDE_POS")) {
                exclude_pos_array.add(value);
                continue;
            }
            if (key.equals("DELETE_POS")) {
                delete_pos_array.add(value);
                continue;
            }
            if (!key.equals("EQUAL_LABELS")) continue;
            equal_labels_array.add(value.split("\\s"));
        }
        EXCLUDE_CAT = exclude_cat_array.toArray(new String[0]);
        EXCLUDE_POS = exclude_pos_array.toArray(new String[0]);
        DELETE_LABELS = delete_pos_array.toArray(new String[0]);
        EQUAL_LABELS = (String[][])equal_labels_array.toArray((T[])new String[0][]);
    }

    private static String formatNumber(double d) {
        if (Double.isNaN(d)) {
            return Double.toString(Double.NaN);
        }
        return formatter.format(d);
    }

    public static void printParameters(PrintStream ps) {
        ps.println("LABELED\t" + LABELED);
        ps.println("CONSTITUENTS_UNIT\t" + CONSTITUENTS_UNIT);
        ps.println("REMOVE_SEMANTIC_TAGS\t" + REMOVE_SEMANTIC_TAGS);
        ps.println("CUTOFF_LENGTH\t" + CUTOFF_LENGTH);
        ps.println("ENCODING\t" + ENCODING);
        ps.println("EXCLUDE_CAT\t" + Arrays.toString(EXCLUDE_CAT));
        ps.println("EXCLUDE_POS\t" + Arrays.toString(EXCLUDE_POS));
        ps.println("DELETE_POS\t" + Arrays.toString(DELETE_LABELS));
        String[][] stringArray = EQUAL_LABELS;
        int n = EQUAL_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] eqPair = stringArray[n2];
            ps.println("EQUAL_LABELS\t" + Arrays.toString(eqPair));
            ++n2;
        }
    }

    public void getTreebanks() {
        try {
            if (this.goldFile != null) {
                this.goldCorpus = TSNodeLabel.getTreebank(this.goldFile, ENCODING, SENTENCE_LENGTH_LIMIT);
            }
            if (this.testFile != null) {
                this.testCorpus = TSNodeLabel.getTreebank(this.testFile, ENCODING, SENTENCE_LENGTH_LIMIT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSentencesLength() {
        this.sentencesLength = new int[this.testCorpus.size()];
        int i = 0;
        for (TSNodeLabel goldTree : this.goldCorpus) {
            this.sentencesLength[i] = goldTree.countLexicalNodesExcludingPosLabels(DELETE_LABEL_FOR_LENGTH);
            ++i;
        }
    }

    public boolean preprocessCorporaAndCheckCompatibility() {
        this.skipSentences = new HashSet();
        Arrays.sort(EXCLUDE_CAT);
        Arrays.sort(EXCLUDE_POS);
        Arrays.sort(DELETE_LABELS);
        if (this.testCorpus.size() != this.goldCorpus.size()) {
            String report = "Sentences in goldFile and testFile don't match in number (" + this.goldCorpus.size() + "|" + this.testCorpus.size() + ")";
            System.err.println(String.valueOf(this.goldFile.getName()) + " " + this.testFile.getName());
            System.err.println(report);
            this.writeLog(report);
            this.areCompatible = false;
            return false;
        }
        Iterator<TSNodeLabel> testIter = this.testCorpus.iterator();
        Iterator<TSNodeLabel> goldIter = this.goldCorpus.iterator();
        int i = 0;
        while (i < this.testCorpus.size()) {
            TSNodeLabel testTree = testIter.next();
            TSNodeLabel goldTree = goldIter.next();
            EvalC.preprocessStructures(testTree, goldTree);
            ArrayList<TSNodeLabel> testLexicon = testTree.collectLexicalItems();
            ArrayList<TSNodeLabel> goldLexicon = goldTree.collectLexicalItems();
            if (testLexicon.size() != goldLexicon.size()) {
                String report = i + 1 + " : " + "Length gold|test unmatch (" + goldLexicon.size() + "|" + testLexicon.size() + ")";
                System.err.println(report);
                this.writeLog(report);
                this.skipSentences.add(new Integer(i));
            } else {
                int j = 0;
                while (j < testLexicon.size()) {
                    String goldWord;
                    String testWord = ((TSNodeLabel)testLexicon.get(j)).label();
                    if (!testWord.equals(goldWord = ((TSNodeLabel)goldLexicon.get(j)).label())) {
                        String report = i + 1 + " : " + "Words gold|test unmatch (" + goldWord + "|" + testWord + ")";
                        System.err.println(report);
                        this.writeLog(report);
                        this.skipSentences.add(new Integer(i));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.areCompatible = true;
        return true;
    }

    private static void preprocessStructures(TSNodeLabel testTree, TSNodeLabel goldTree) {
        if (REMOVE_SEMANTIC_TAGS) {
            testTree.removeSemanticTags();
            goldTree.removeSemanticTags();
        }
        if (DELETE_BACK_SLASH) {
            testTree.removeBackSlashInLexicon();
            goldTree.removeBackSlashInLexicon();
        }
        if (EQUAL_LABELS != null && EQUAL_LABELS.length > 0) {
            String[][] stringArray = EQUAL_LABELS;
            int n = EQUAL_LABELS.length;
            int n2 = 0;
            while (n2 < n) {
                String[] equalPairs = stringArray[n2];
                testTree.replaceLabels(equalPairs[0], equalPairs[1]);
                goldTree.replaceLabels(equalPairs[0], equalPairs[1]);
                ++n2;
            }
        }
        if (DELETE_LABELS != null && DELETE_LABELS.length > 0) {
            testTree.pruneSubTrees(DELETE_LABELS);
            goldTree.pruneSubTrees(DELETE_LABELS);
        }
    }

    public float[] makeEval() {
        this.out = FileUtil.getPrintWriter(this.outputFile, ENCODING);
        PrintWriter printWriter = this.log = this.logFile == null ? null : FileUtil.getPrintWriter(this.logFile, ENCODING);
        if (LABELED) {
            this.categoryStatistics = new Hashtable();
            this.wrongCatStatistics = new Hashtable();
            if (CONSTITUENTS_UNIT != 2) {
                this.crossingBracketsCatTable = new Hashtable();
            }
        }
        this.printHeader();
        int i = 0;
        while (i < this.goldCorpus.size()) {
            TSNodeLabel TNgold = this.goldCorpus.get(i);
            TSNodeLabel TNtest = this.testCorpus.get(i);
            this.updateStatistics(i + 1, TNgold, TNtest);
            ++i;
        }
        this.printFinalStatistics();
        if (LABELED) {
            this.printCategoryStatistics();
            this.printWrongCatStatistics();
        }
        float[] results = this.printSummaryStatistics();
        this.out.close();
        if (this.log != null) {
            this.log.close();
        }
        return results;
    }

    public void writeLog(String logString) {
        if (this.log != null) {
            this.log.println(logString);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateStatistics(int index, TSNodeLabel TNgold, TSNodeLabel TNtest) {
        boolean compatible;
        boolean bl = compatible = !this.skipSentences.contains(new Integer(index - 1));
        if (!compatible) {
            this.out.println(String.valueOf(Utility.fsb(4, Integer.toString(index))) + ' ' + Utility.fca(73, " SKIPPED SENTENCE ", '-'));
            return;
        }
        int length = this.sentencesLength[index - 1];
        ArrayList<? extends Constituency> goldConst = Constituency.collectConsituencies(TNgold, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, false);
        ArrayList<Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        ArrayList<? extends Constituency> testConst = Constituency.collectConsituencies(TNtest, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, false);
        ArrayList<Constituency> testConstCopy = new ArrayList<Constituency>(testConst);
        int goldBrackets = goldConst.size();
        int testBrackets = testConst.size();
        ArrayList<Constituency> matchedConst = new ArrayList<Constituency>();
        for (Constituency constituency : testConst) {
            if (!goldConstCopy.remove(constituency)) continue;
            matchedConst.add(constituency);
            testConstCopy.remove(constituency);
        }
        if (this.log != null) {
            void var13_18;
            ArrayList<Constituency> arrayList = goldConstCopy;
            ArrayList<Constituency> unmatchedTest = testConstCopy;
            if (CONSTITUENTS_UNIT != 2) {
                ArrayList<Constituency> arrayList2 = ConstituencyWords.toYieldConstituency(arrayList, TNgold, LABELED);
                unmatchedTest = ConstituencyWords.toYieldConstituency(unmatchedTest, TNtest, LABELED);
            }
            this.log.println("Sentence: " + index + "\n" + "\tGold: " + TNgold + "\n" + "\tTest: " + TNtest + "\n" + "\tUnmatched Gold: " + var13_18 + "\n" + "\tUnmatched Test: " + unmatchedTest + "\n\n");
        }
        if (LABELED) {
            this.updateCategoryStatistics(testConst, goldConst, matchedConst);
            this.updateWrongCatStatistics(testConstCopy, goldConstCopy);
        }
        int n = TNtest.countLexicalNodesExcludingPosLabels(EXCLUDE_POS);
        int matchBrackets = matchedConst.size();
        float recallPercentage = (float)matchBrackets * 100.0f / (float)goldBrackets;
        float precisionPercentage = (float)matchBrackets * 100.0f / (float)testBrackets;
        int correctTags = -1;
        float tagAccuracyPercentage = -1.0f;
        if (compatible) {
            correctTags = TNtest.countCorrectPOS(TNgold, EXCLUDE_POS);
            tagAccuracyPercentage = (float)correctTags * 100.0f / (float)n;
        }
        boolean exactMatch = matchBrackets == testBrackets && matchBrackets == goldBrackets;
        int crossBracket = -1;
        if (CONSTITUENTS_UNIT != 2) {
            crossBracket = ConstituencyWords.updateCrossingBrackets(testConst, goldConst, this.crossingBracketsCatTable);
        }
        this.out.println(String.valueOf(Utility.fsb(4, Integer.toString(index))) + (compatible ? (char)' ' : '*') + Utility.fsb(6, Integer.toString(length)) + ' ' + Utility.fsb(7, EvalC.formatNumber(recallPercentage)) + ' ' + Utility.fsb(7, EvalC.formatNumber(precisionPercentage)) + ' ' + Utility.fsb(7, Integer.toString(matchBrackets)) + ' ' + Utility.fsb(6, Integer.toString(goldBrackets)) + ' ' + Utility.fsb(6, Integer.toString(testBrackets)) + ' ' + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, Integer.toString(crossBracket))) + ' ' + Utility.fsb(6, Integer.toString(n)) + ' ' + (compatible ? Utility.fsb(5, Integer.toString(correctTags)) : Utility.fsb(5, "-")) + ' ' + (compatible ? Utility.fsb(7, EvalC.formatNumber(tagAccuracyPercentage)) : Utility.fsb(7, "-")));
        ++this.sentences;
        this.totalMatchBrackets += matchBrackets;
        this.totalGoldBrackets += goldBrackets;
        this.totalTestBrackets += testBrackets;
        this.totalWords += n;
        this.totalCorrectTags += correctTags;
        if (exactMatch) {
            ++this.totalExactMatch;
        }
        if (CONSTITUENTS_UNIT != 2) {
            this.totalCrossBracket += crossBracket;
            if (crossBracket == 0) {
                ++this.noCrossing;
            }
            if (crossBracket <= 2) {
                ++this.twoOrLessCrossing;
            }
        }
        if (length <= CUTOFF_LENGTH) {
            ++this.sentencesMSL;
            this.totalMatchBracketsMSL += matchBrackets;
            this.totalGoldBracketsMSL += goldBrackets;
            this.totalTestBracketsMSL += testBrackets;
            this.totalWordsMSL += n;
            this.totalCorrectTagsMSL += correctTags;
            if (exactMatch) {
                ++this.totalExactMatchMSL;
            }
            if (CONSTITUENTS_UNIT != 2) {
                this.totalCrossBracketMSL += crossBracket;
                if (crossBracket == 0) {
                    ++this.noCrossingMSL;
                }
                if (crossBracket <= 2) {
                    ++this.twoOrLessCrossingMSL;
                }
            }
        }
    }

    public static float getScore(TSNodeLabel TNgold, TSNodeLabel TNtest, boolean preprocessStructures) {
        int[] scores = EvalC.getScores(TNgold, TNtest, preprocessStructures);
        return EvalC.fscore(scores);
    }

    public static int[] getScores(TSNodeLabel TNgold, TSNodeLabel TNtest, boolean preprocessStructures) {
        if (preprocessStructures) {
            EvalC.preprocessStructures(TNgold, TNtest);
        }
        ArrayList<? extends Constituency> goldConst = Constituency.collectConsituencies(TNgold, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, false);
        ArrayList<? extends Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        ArrayList<? extends Constituency> testConst = Constituency.collectConsituencies(TNtest, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, false);
        int goldBrackets = goldConst.size();
        int testBrackets = testConst.size();
        ArrayList<Constituency> matchedConst = new ArrayList<Constituency>();
        for (Constituency constituency : testConst) {
            if (!goldConstCopy.remove(constituency)) continue;
            matchedConst.add(constituency);
        }
        int n = matchedConst.size();
        return new int[]{n, goldBrackets, testBrackets};
    }

    public static float fscore(int[] scores) {
        return EvalC.fscore(scores[0], scores[1], scores[2]);
    }

    public static float fscore(int matchBrackets, int goldBrackets, int parsedBrackets) {
        float recall = (float)matchBrackets / (float)goldBrackets;
        float precision = (float)matchBrackets / (float)parsedBrackets;
        return recall == 0.0f && precision == 0.0f ? 0.0f : 2.0f * recall * precision / (recall + precision);
    }

    public static ArrayList<TSNodeLabel>[] getDiff(TSNodeLabel TNgold, TSNodeLabel TNtest) {
        ArrayList<? extends Constituency> goldConst = Constituency.collectConsituencies(TNgold, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, true);
        ArrayList<? extends Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        ArrayList<? extends Constituency> testConst = Constituency.collectConsituencies(TNtest, LABELED, EXCLUDE_CAT, CONSTITUENTS_UNIT, true);
        ArrayList<? extends Constituency> testConstCopy = new ArrayList<Constituency>(testConst);
        for (Constituency constituency : testConst) {
            goldConstCopy.remove(constituency);
        }
        for (Constituency constituency : goldConst) {
            testConstCopy.remove(constituency);
        }
        ArrayList<TSNodeLabel> arrayList = new ArrayList<TSNodeLabel>();
        ArrayList<TSNodeLabel> testConstDiffArray = new ArrayList<TSNodeLabel>();
        for (Constituency constituency : goldConstCopy) {
            arrayList.add(constituency.getNode());
        }
        for (Constituency constituency : testConstCopy) {
            testConstDiffArray.add(constituency.getNode());
        }
        ArrayList[] arrayListArray = new ArrayList[]{arrayList, testConstDiffArray};
        return arrayListArray;
    }

    public void updateCategoryStatistics(List<? extends Constituency> goldConst, List<? extends Constituency> testConst, List<Constituency> matchedConst) {
        this.totalCategoryGold += goldConst.size();
        for (Constituency constituency : goldConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, constituency.label(), 0, 1);
        }
        for (Constituency constituency : testConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, constituency.label(), 1, 1);
        }
        for (Constituency constituency : matchedConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, constituency.label(), 2, 1);
        }
    }

    public void updateWrongCatStatistics(ArrayList<Constituency> wrongTestConst, ArrayList<Constituency> wrongGoldConst) {
        int indexGold = -1;
        for (Constituency C : wrongGoldConst) {
            ++indexGold;
            Constituency C_unlab = C.unlabeledCopy();
            int indexTestUnlabeled = wrongTestConst.indexOf(C_unlab);
            if (indexTestUnlabeled == -1) continue;
            Constituency labelTest = wrongTestConst.get(indexTestUnlabeled);
            Constituency labelGold = wrongGoldConst.get(indexGold);
            String key = String.valueOf(labelTest.label()) + "/" + labelGold.label();
            Utility.increaseStringInteger(this.wrongCatStatistics, key, 1);
        }
    }

    public void printHeader() {
        this.out.println(String.valueOf(Utility.fsb(11, "Sentence")) + ' ' + Utility.fsb(15, "") + ' ' + Utility.fsb(7, "Matched") + ' ' + Utility.fca(13, "Brackets", ' ') + ' ' + Utility.fsb(7, "Cross") + ' ' + Utility.fsb(6, "") + ' ' + Utility.fsb(5, "Corr") + ' ' + Utility.fsb(7, "Tag"));
        this.out.println(String.valueOf(Utility.fsb(4, "ID")) + ' ' + Utility.fsb(6, "Length") + ' ' + Utility.fsb(7, "Recall") + ' ' + Utility.fsb(7, "Precis") + ' ' + Utility.fsb(7, "Bracket") + ' ' + Utility.fsb(6, "gold") + ' ' + Utility.fsb(6, "test") + ' ' + Utility.fsb(7, "Bracket") + ' ' + Utility.fsb(6, "Words") + ' ' + Utility.fsb(5, "Tags") + ' ' + Utility.fsb(7, "Accracy"));
        this.out.println(Utility.fillChar(78, '_'));
    }

    private void calculateFinalResults() {
        this.totalRecallPercentage = (float)this.totalMatchBrackets * 100.0f / (float)this.totalGoldBrackets;
        this.totalPrecisionPercentage = (float)this.totalMatchBrackets * 100.0f / (float)this.totalTestBrackets;
        this.taggingAccuracyPercentage = (float)this.totalCorrectTags * 100.0f / (float)this.totalWords;
        this.totalRecallPercentageMSL = (float)this.totalMatchBracketsMSL * 100.0f / (float)this.totalGoldBracketsMSL;
        this.totalPrecisionPercentageMSL = (float)this.totalMatchBracketsMSL * 100.0f / (float)this.totalTestBracketsMSL;
        this.taggingAccuracyPercentageMSL = (float)this.totalCorrectTagsMSL * 100.0f / (float)this.totalWordsMSL;
    }

    public void printFinalStatistics() {
        this.calculateFinalResults();
        this.out.println(Utility.fillChar(78, '_'));
        this.out.println(String.valueOf(Utility.fsb(4, "")) + ' ' + Utility.fsb(6, "") + ' ' + Utility.fsb(7, EvalC.formatNumber(this.totalRecallPercentage)) + ' ' + Utility.fsb(7, EvalC.formatNumber(this.totalPrecisionPercentage)) + ' ' + Utility.fsb(7, Integer.toString(this.totalMatchBrackets)) + ' ' + Utility.fsb(6, Integer.toString(this.totalGoldBrackets)) + ' ' + Utility.fsb(6, Integer.toString(this.totalTestBrackets)) + ' ' + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, Integer.toString(this.totalCrossBracket))) + ' ' + Utility.fsb(6, Integer.toString(this.totalWords)) + ' ' + Utility.fsb(5, Integer.toString(this.totalCorrectTags)) + ' ' + Utility.fsb(7, EvalC.formatNumber(this.taggingAccuracyPercentage)));
    }

    public void printCategoryStatistics() {
        this.out.println();
        this.out.println(Utility.fca(58, " Category Statistics ", '_'));
        this.out.println();
        this.out.println(String.valueOf(Utility.fsb(10, "label")) + Utility.fsb(12, "% gold") + Utility.fsb(12, "catRecall") + Utility.fsb(12, "catPrecis") + Utility.fsb(12, "catFScore"));
        this.out.println(Utility.fillChar(58, '_'));
        IdentityHashMap<Float, String> orderedCategory = new IdentityHashMap<Float, String>();
        for (String label : this.categoryStatistics.keySet()) {
            int[] values = this.categoryStatistics.get(label);
            float percentageGold = (float)values[1] * 100.0f / (float)this.totalCategoryGold;
            float catRecall = (float)values[2] * 100.0f / (float)values[0];
            float catPrecision = (float)values[2] * 100.0f / (float)values[1];
            float catFScore = 2.0f * catRecall * catPrecision / (catRecall + catPrecision);
            String line = String.valueOf(Utility.fsb(10, label)) + Utility.fsb(12, EvalC.formatNumber(percentageGold)) + Utility.fsb(12, EvalC.formatNumber(catRecall)) + Utility.fsb(12, EvalC.formatNumber(catPrecision)) + Utility.fsb(12, EvalC.formatNumber(catFScore));
            orderedCategory.put(Float.valueOf(percentageGold), line);
        }
        Object[] percentageSorted = orderedCategory.keySet().toArray(new Float[0]);
        Arrays.sort(percentageSorted);
        int i = percentageSorted.length - 1;
        while (i >= 0) {
            String line = (String)orderedCategory.get(percentageSorted[i]);
            this.out.println(line);
            --i;
        }
        this.out.println();
        if (CONSTITUENTS_UNIT != 2) {
            this.out.println(Utility.fsb(20, "Crossing brackets"));
            this.out.println(String.valueOf(Utility.fsb(12, "test/gold")) + Utility.fsb(8, "count"));
            this.out.println(Utility.fillChar(20, '_'));
            IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(this.crossingBracketsCatTable);
            Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
            Arrays.sort(countSorted);
            int i2 = countSorted.length - 1;
            while (i2 >= 0) {
                Object count = countSorted[i2];
                String pair = reversedTable.get(count);
                this.out.println(String.valueOf(Utility.fsb(12, pair)) + Utility.fsb(8, ((Integer)count).toString()));
                --i2;
            }
            this.out.println();
        }
    }

    public void printWrongCatStatistics() {
        this.out.println(Utility.fsb(20, "Wrong Category Statistics"));
        this.out.println(String.valueOf(Utility.fsb(12, "test/gold")) + Utility.fsb(8, "count"));
        this.out.println(Utility.fillChar(20, '_'));
        IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(this.wrongCatStatistics);
        Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
        Arrays.sort(countSorted);
        int i = countSorted.length - 1;
        while (i >= 0) {
            Object count = countSorted[i];
            String pair = reversedTable.get(count);
            this.out.println(String.valueOf(Utility.fsb(12, pair)) + Utility.fsb(8, ((Integer)count).toString()));
            --i;
        }
        this.out.println();
    }

    public float[] printSummaryStatistics() {
        float totalFMeasurePercentage = 2.0f * this.totalRecallPercentage * this.totalPrecisionPercentage / (this.totalRecallPercentage + this.totalPrecisionPercentage);
        float averageCrossing = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.totalCrossBracket / (float)this.sentences;
        float completeMatchPercentage = (float)this.totalExactMatch * 100.0f / (float)this.sentences;
        float noCrossingPercentage = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.noCrossing * 100.0f / (float)this.sentences;
        float twoOrLessCrossingPercentage = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.twoOrLessCrossing * 100.0f / (float)this.sentences;
        float totalFMeasurePercentageMSL = 2.0f * this.totalRecallPercentageMSL * this.totalPrecisionPercentageMSL / (this.totalRecallPercentageMSL + this.totalPrecisionPercentageMSL);
        float averageCrossingMSL = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.totalCrossBracketMSL / (float)this.sentencesMSL;
        float completeMatchPercentageMSL = (float)this.totalExactMatchMSL * 100.0f / (float)this.sentencesMSL;
        float noCrossingPercentageMSL = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.noCrossingMSL * 100.0f / (float)this.sentencesMSL;
        float twoOrLessCrossingPercentageMSL = CONSTITUENTS_UNIT == 2 ? 0.0f : (float)this.twoOrLessCrossingMSL * 100.0f / (float)this.sentencesMSL;
        this.out.println();
        this.out.println(Utility.fca(34, " Summary ", '_'));
        this.out.println();
        this.out.println(Utility.fca(34, " All ", '_'));
        this.out.println("Number of sentences       =" + Utility.fsb(7, Integer.toString(this.sentences)) + "\n" + "Bracketing Recall         =" + Utility.fsb(7, EvalC.formatNumber(this.totalRecallPercentage)) + "\n" + "Bracketing Precision      =" + Utility.fsb(7, EvalC.formatNumber(this.totalPrecisionPercentage)) + "\n" + "Bracketing FMeasure       =" + Utility.fsb(7, EvalC.formatNumber(totalFMeasurePercentage)) + "\n" + "Complete match            =" + Utility.fsb(7, EvalC.formatNumber(completeMatchPercentage)) + "\n" + "Average crossing          =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(averageCrossing))) + "\n" + "No crossing               =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(noCrossingPercentage))) + "\n" + "2 or less crossing        =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(twoOrLessCrossingPercentage))) + "\n" + "Tagging accuracy          =" + Utility.fsb(7, EvalC.formatNumber(this.taggingAccuracyPercentage)));
        this.out.println();
        this.out.println(Utility.fca(34, " len<=" + CUTOFF_LENGTH + " ", '_'));
        this.out.println("Number of sentences       =" + Utility.fsb(7, Integer.toString(this.sentencesMSL)) + "\n" + "Bracketing Recall         =" + Utility.fsb(7, EvalC.formatNumber(this.totalRecallPercentageMSL)) + "\n" + "Bracketing Precision      =" + Utility.fsb(7, EvalC.formatNumber(this.totalPrecisionPercentageMSL)) + "\n" + "Bracketing FMeasure       =" + Utility.fsb(7, EvalC.formatNumber(totalFMeasurePercentageMSL)) + "\n" + "Complete match            =" + Utility.fsb(7, EvalC.formatNumber(completeMatchPercentageMSL)) + "\n" + "Average crossing          =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(averageCrossingMSL))) + "\n" + "No crossing               =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(noCrossingPercentageMSL))) + "\n" + "2 or less crossing        =" + (CONSTITUENTS_UNIT == 2 ? Utility.fsb(7, "-") : Utility.fsb(7, EvalC.formatNumber(twoOrLessCrossingPercentageMSL))) + "\n" + "Tagging accuracy          =" + Utility.fsb(7, EvalC.formatNumber(this.taggingAccuracyPercentageMSL)));
        return new float[]{this.totalRecallPercentageMSL, this.totalPrecisionPercentageMSL, totalFMeasurePercentageMSL};
    }

    public static void main1() {
        String basePath = "/scratch/fsangati/RESULTS/TSG/DOP_SD_Reranker/";
        File gold = new File(String.valueOf(basePath) + "wsj-22_gold.mrg");
        File test = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.mrg");
        File evalF = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.evalF");
        float[] rerankedFScore = EvalC.staticEvalC(gold, test, evalF);
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
    }

    public static void main2(String[] args) {
        if (args.length != 3) {
            System.err.println("Error. Correct usage: EvalF goldFile testFile ouputFile");
            return;
        }
        File gold = new File(args[0]);
        File test = new File(args[1]);
        File evalF = new File(args[2]);
        float[] rerankedFScore = EvalC.staticEvalC(gold, test, evalF);
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
    }

    public static void main(String[] args) {
        float[] rerankedFScore;
        String usage = "USAGE: java -jar evalC.jar [-p paramFile] [-log logFile] goldFile testFile outputFile";
        if (args.length == 0 || args.length > 7) {
            System.err.println("Incorrect number of arguments");
            System.err.println(usage);
            System.exit(-1);
        }
        int i = 0;
        File paramFile = null;
        File goldFile = null;
        File testFile = null;
        File outputFile = null;
        File logFile = null;
        do {
            String currentArg;
            if ((currentArg = args[i]).equals("-p")) {
                if (++i == args.length) {
                    System.err.println("Incorrect arguments");
                    System.err.println(usage);
                    System.exit(-1);
                }
                paramFile = new File(args[i++]);
                continue;
            }
            if (currentArg.equals("-log")) {
                if (++i == args.length) {
                    System.err.println("Incorrect arguments");
                    System.err.println(usage);
                    System.exit(-1);
                }
                logFile = new File(args[i++]);
                continue;
            }
            if (goldFile == null) {
                goldFile = new File(args[i++]);
                continue;
            }
            if (testFile == null) {
                testFile = new File(args[i++]);
                continue;
            }
            outputFile = new File(args[i++]);
        } while (i < args.length);
        if (goldFile == null || !goldFile.exists() || !goldFile.canRead()) {
            System.err.println("Gold file missing or cannot read it.");
            System.err.println(usage);
            System.exit(-1);
        }
        if (testFile == null || !testFile.exists() || !testFile.canRead()) {
            System.err.println("Test file missing or cannot read");
            System.err.println(usage);
            System.exit(-1);
        }
        if (outputFile == null) {
            System.err.println("Output file missing.");
            System.err.println(usage);
            System.exit(-1);
        }
        if (paramFile != null) {
            EvalC.readParametersFromFile(paramFile);
        }
        if ((rerankedFScore = EvalC.staticEvalC(goldFile, testFile, outputFile, logFile)) == null) {
            System.out.println("Gold and Test files not compatible (different number of structures)");
        }
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
    }
}

