/*
 * Decompiled with CFR 0.152.
 */
package tsg.evalHeads;

import java.io.File;
import java.util.Arrays;
import settings.Parameters;
import tsg.CFSG;
import tsg.LTSG.LTSG_Entropy;
import tsg.LTSG.LTSG_Greedy;
import tsg.LTSG.LTSG_Naive;
import tsg.corpora.ConstCorpus;
import tsg.corpora.Negra;
import tsg.evalHeads.EvalDependency;
import util.FileUtil;

public class negraEval {
    static void entropyTest() {
        Parameters.corpusName = "Negra";
        Parameters.semanticTags = true;
        Parameters.posTagConversion = true;
        Parameters.spineConversion = true;
        Parameters.removeTreesLimit = -1;
        Parameters.startingHeads = "Random";
        Parameters.maxNumberOfChanges = -1;
        Parameters.orderOfChange = 2;
        Parameters.maxEntropyCycles = -1;
        Parameters.entropy_delta_threshold = 0.01;
        Parameters.outputPath = String.valueOf(Parameters.outputPath) + "Entropy/";
        int lengthLimit = 40;
        String inputFile = String.valueOf(Negra.NegraTrainingBinaryPath) + "_upto" + lengthLimit;
        File trainingCorpusFile = new File(inputFile);
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        LTSG_Entropy Grammar2 = new LTSG_Entropy();
        Grammar2.hillClimbing();
        int[] recall = EvalDependency.evalHeads(Parameters.trainingCorpus, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        System.out.println("Total/Recall " + Arrays.toString(recall) + " " + ratio);
    }

    static void cfgTest() {
        Parameters.corpusName = "Negra";
        Parameters.semanticTags = true;
        Parameters.outputPath = String.valueOf(Parameters.outputPath) + "CFG/";
        int lengthLimit = 40;
        String inputFile = String.valueOf(Negra.NegraTrainingBinaryPath) + "_upto" + lengthLimit;
        File trainingCorpusFile = new File(inputFile);
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        CFSG Grammar2 = new CFSG();
        boolean allowPunctuation = false;
        boolean onlyExternalChoices = false;
        Grammar2.assignHeadAnnotations(allowPunctuation, onlyExternalChoices);
        ConstCorpus negraSample = Parameters.trainingCorpus.returnFirst(200);
        File ouputFile = new File(String.valueOf(Parameters.outputPath) + "CFGHeads");
        negraSample.toFile_Complete(ouputFile, true);
        int[] recall = EvalDependency.evalHeads(Parameters.trainingCorpus, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        String report = "Total/Recall " + Arrays.toString(recall) + " " + ratio;
        FileUtil.appendReturn(report, Parameters.logFile);
        System.out.println(report);
    }

    static void greedyTest() {
        Parameters.corpusName = "Negra";
        Parameters.semanticTags = true;
        Parameters.spineConversion = true;
        Parameters.removeRedundencyInSpine = true;
        Parameters.posTagConversion = true;
        Parameters.jollyConversion = false;
        Parameters.jollyInclusion = false;
        Parameters.jollyLabels = new String[]{"NP"};
        Arrays.sort(Parameters.jollyLabels);
        Parameters.removeTreesLimit = -1;
        Parameters.LTSGtype = "GreedyTop";
        Parameters.greedy_punctuation = false;
        Parameters.greedy_ambiguityChoice = 2;
        Parameters.outputPath = String.valueOf(Parameters.outputPath) + Parameters.LTSGtype + "/";
        int lengthLimit = 40;
        String inputFile = String.valueOf(Negra.NegraTrainingBinaryPath) + "_upto" + lengthLimit;
        File trainingCorpusFile = new File(inputFile);
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.lexiconTable = Parameters.trainingCorpus.buildLexFreq();
        LTSG_Greedy Grammar2 = new LTSG_Greedy();
        Grammar2.assignGreedyAnnotations();
        ConstCorpus negraSample = Parameters.trainingCorpus.returnFirst(200);
        File ouputFile = new File(String.valueOf(Parameters.outputPath) + "greedyHeads");
        negraSample.toFile_Complete(ouputFile, true);
        int[] recall = EvalDependency.evalHeads(Parameters.trainingCorpus, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        String report = "Total/Recall " + Arrays.toString(recall) + " " + ratio;
        FileUtil.appendReturn(report, Parameters.logFile);
        System.out.println(report);
    }

    static void naiveTest() {
        Parameters.corpusName = "Negra";
        Parameters.semanticTags = true;
        Parameters.removeTreesLimit = -1;
        Parameters.LTSGtype = "FirstRight";
        Parameters.outputPath = "/home/fsangati/PROJECTS/TSG/RESULTS/LTSG/" + Parameters.LTSGtype + "/";
        int lengthLimit = 40;
        String inputFile = String.valueOf(Negra.NegraTrainingBinaryPath) + "_upto" + lengthLimit;
        File trainingCorpusFile = new File(inputFile);
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        LTSG_Naive Grammar2 = new LTSG_Naive();
        Grammar2.assignNaiveAnnotations();
        int[] recall = EvalDependency.evalHeads(Parameters.trainingCorpus, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        System.out.println("Total/Recall " + Arrays.toString(recall) + " " + ratio);
    }

    public static void reportGoldStatistics(int lengthLimit) {
        File statisticFile = new File("/home/fsangati/CORPUS/Negra/negra_" + lengthLimit + "Heads_Statistic.txt");
        File goldFile = new File(String.valueOf(Negra.NegraTrainingBinaryPath) + "_upto" + lengthLimit);
        ConstCorpus goldCorpus = ConstCorpus.fromBinaryFile(goldFile);
        File corpusOutput = new File("/home/fsangati/CORPUS/Negra/Heads/Negra_heads_upTo" + lengthLimit);
        goldCorpus.toFile_Complete(corpusOutput, true);
        goldCorpus.checkHeadAnnotationStatistics(statisticFile);
    }

    public static void main(String[] args) {
        Parameters.outputPath = "/home/fsangati/PROJECTS/EvalHeads/Negra/";
        negraEval.greedyTest();
    }
}

