/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import settings.Parameters;
import tsg.LTSG.LTSG;
import tsg.LTSG.LTSG_All;
import tsg.TSNode;
import tsg.corpora.ConstCorpus;

public class lexicalTreeParser {
    ConstCorpus testSet;
    LTSG grammar;
    Hashtable<String, Hashtable<String, HashSet<String>>> treeStructure;

    public lexicalTreeParser(ConstCorpus testSet, LTSG grammar) {
        this.testSet = testSet;
        this.grammar = grammar;
        this.buildTreeStructure();
        this.parseTestSet();
    }

    public void buildTreeStructure() {
        this.treeStructure = new Hashtable();
        Enumeration<String> e = this.grammar.template_freq.keys();
        while (e.hasMoreElements()) {
            HashSet<String> treeSet;
            String template = e.nextElement();
            String lex = TSNode.get_unique_lexicon(template);
            String root = TSNode.get_unique_root(template);
            Hashtable<String, HashSet<String>> rootStructure = this.treeStructure.get(lex);
            if (rootStructure == null) {
                rootStructure = new Hashtable();
                this.treeStructure.put(lex, rootStructure);
            }
            if ((treeSet = rootStructure.get(root)) == null) {
                treeSet = new HashSet();
                rootStructure.put(root, treeSet);
            }
            treeSet.add(template);
        }
    }

    public void parseTestSet() {
        ListIterator<TSNode> i = this.testSet.treeBank.listIterator();
        while (i.hasNext()) {
            TSNode element = i.next();
            List<TSNode> terminals = element.collectTerminals();
            this.parseSentence(terminals);
        }
    }

    public HashSet<TSNode> parseSentence(List<TSNode> terminals) {
        HashSet<TSNode> parseTrees = new HashSet<TSNode>();
        ListIterator<TSNode> j = terminals.listIterator();
        while (j.hasNext()) {
            HashSet<String> rootTrees;
            TSNode tree = j.next();
            Hashtable<String, HashSet<String>> rootStructure = this.treeStructure.get(tree.label);
            if (rootStructure != null && (rootTrees = rootStructure.get("TOP")) != null) continue;
        }
        return parseTrees;
    }

    public static void ltsg_all() {
        String corpusName = "Wsj";
        Parameters.outputPath = "/home/fsangati/PROJECTS/TSG/RESULTS/LTSG/AllLexTrees/";
        Parameters.ukLimit = 4;
        Parameters.semanticTags = true;
        Parameters.cutTopRecursion = false;
        Parameters.delexicalize = false;
        Parameters.spineConversion = false;
        Parameters.removeTreesLimit = -1;
        Parameters.smoothing = false;
        Parameters.smoothingFactor = 100;
        int[] LL = new int[]{20};
        int i = 0;
        while (i < LL.length) {
            Parameters.lengthLimitTraining = LL[i];
            LTSG_All Grammar2 = new LTSG_All();
            Grammar2.extractAllLexTrees();
            ++i;
        }
    }

    public static void main(String[] args) {
        lexicalTreeParser.ltsg_all();
    }
}

