/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import tsg.ConstituencyWords;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.metrics.MCP;
import tsg.metrics.ParseMetricOptimizer;
import util.Duet;
import util.Utility;

public class MCP_l0
extends ParseMetricOptimizer {
    static Label noConstLabel = Label.getLabel("");
    static String unaryProductionSeparator = "==";
    static String dotBinarizationMarker = "<dot>";
    Hashtable<Label, double[]>[][] constsProbTable;
    ViterbiCell[][] cells;

    public MCP_l0() {
        this.identifier = "MCP_l=" + MCP.lambdaFormat.format(0L);
    }

    @Override
    protected void initSentence() {
        this.constsProbTable = new Hashtable[this.sentenceLength][this.sentenceLength];
        this.cells = new ViterbiCell[this.sentenceLength][this.sentenceLength];
        int i = 0;
        while (i < this.sentenceLength) {
            int j = i;
            while (j < this.sentenceLength) {
                this.constsProbTable[i][j] = new Hashtable();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addNewDerivationChecked(TSNodeLabel tree, double prob) {
        tree.compressUnaryProductions(unaryProductionSeparator, false);
        tree.binarizeEarly(dotBinarizationMarker);
        ArrayList<ConstituencyWords> consts = ConstituencyWords.collectConsituencies(tree, true, new String[0], true);
        for (ConstituencyWords c : consts) {
            Label label = c.getNode().label;
            double ruleProb = label.toString().contains(dotBinarizationMarker) ? 0.0 : prob;
            int startIndex = c.getInitialIndex();
            int endIndex = c.getFinalIndex();
            Hashtable<Label, double[]> cellTable = this.constsProbTable[startIndex][endIndex];
            Utility.increaseInTableDoubleArray(cellTable, label, ruleProb);
        }
    }

    @Override
    public TSNodeLabel getBestTree() {
        int span = 0;
        while (span < this.sentenceLength) {
            int s = 0;
            while (s < this.sentenceLength - span) {
                int e = s + span;
                Hashtable<Label, double[]> cellTable = this.constsProbTable[s][e];
                Duet<Label, Double> maxLabelScore = MCP_l0.getMaxLabelScore(cellTable);
                double maxCombScore = 0.0;
                ViterbiCell leftSplit = null;
                ViterbiCell rightSplit = null;
                if (span > 0) {
                    maxCombScore = -1.7976931348623157E308;
                    int split = s;
                    while (split < e) {
                        ViterbiCell cellL = this.cells[s][split];
                        if (cellL.label != noConstLabel) {
                            double sumScore;
                            ViterbiCell cellR = this.cells[split + 1][e];
                            if (cellR.label != noConstLabel && (sumScore = cellL.score + cellR.score) > maxCombScore) {
                                maxCombScore = sumScore;
                                leftSplit = cellL;
                                rightSplit = cellR;
                            }
                        }
                        ++split;
                    }
                }
                Label gLabel = maxLabelScore.getFirst();
                this.cells[s][e] = new ViterbiCell(gLabel, s, e, maxCombScore += maxLabelScore.getSecond().doubleValue(), leftSplit, rightSplit);
                ++s;
            }
            ++span;
        }
        ViterbiCell topCell = this.cells[0][this.sentenceLength - 1];
        TSNodeLabel result = this.getTree(topCell);
        result.unbinarizeEarly(dotBinarizationMarker);
        result.uncompressUnaryProductions(unaryProductionSeparator);
        ArrayList<TSNodeLabel> terms = result.collectTerminalItems();
        int i = 0;
        for (TSNodeLabel t : terms) {
            TSNodeLabel lexNode = new TSNodeLabel(this.lexicalItems[i], true);
            t.daughters = new TSNodeLabel[]{lexNode};
            lexNode.parent = t;
            ++i;
        }
        return result;
    }

    public void printBestCellLabels() {
        int i = 0;
        while (i < this.sentenceLength) {
            int j = 0;
            while (j < this.sentenceLength) {
                if (j < i) {
                    System.out.print("\t");
                } else {
                    System.out.print("\"" + (this.cells[i][j] == null ? "null" : this.cells[i][j].label) + "\"" + "\t");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private void addDaughters(ViterbiCell cell, ArrayList<ViterbiCell> daughters) {
        ViterbiCell[] viterbiCellArray = cell.cellsSplit;
        int n = cell.cellsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            ViterbiCell split = viterbiCellArray[n2];
            if (split.label == noConstLabel) {
                this.addDaughters(split, daughters);
            } else {
                daughters.add(split);
            }
            ++n2;
        }
    }

    private TSNodeLabel getTree(ViterbiCell topCell) {
        TSNodeLabel result = new TSNodeLabel(topCell.label, false);
        if (topCell.cellsSplit[0] == null) {
            return result;
        }
        ArrayList<ViterbiCell> daughters = new ArrayList<ViterbiCell>();
        this.addDaughters(topCell, daughters);
        TSNodeLabel[] daughtersArray = new TSNodeLabel[daughters.size()];
        result.daughters = daughtersArray;
        int i = 0;
        for (ViterbiCell c : daughters) {
            TSNodeLabel d = this.getTree(c);
            d.parent = result;
            daughtersArray[i] = d;
            ++i;
        }
        return result;
    }

    private static Duet<Label, Double> getMaxLabelScore(Hashtable<Label, double[]> table) {
        if (table.isEmpty()) {
            return new Duet<Label, Double>(noConstLabel, 0.0);
        }
        double maxScore = -1.7976931348623157E308;
        Label maxKey = null;
        for (Map.Entry<Label, double[]> e : table.entrySet()) {
            double stat = e.getValue()[0];
            if (!(stat > maxScore)) continue;
            maxScore = stat;
            maxKey = e.getKey();
        }
        return new Duet<Object, Double>(maxKey, maxScore);
    }

    public static void main(String[] args) throws Exception {
        MCP_l0 mcp = new MCP_l0();
        File testFile = new File("tmp/wsj-24_214_215.mrg");
        File nBestFile = new File("tmp/Parsing_Thu_Oct_21_01_29_54/BitParWorkingDir/outputBitPar_1000best_1.txt_cleaned");
        Scanner scan = new Scanner(testFile);
        String firstTreeString = scan.nextLine();
        TSNodeLabel tree = new TSNodeLabel(firstTreeString);
        String[] words = tree.collectTerminalStrings().toArray(new String[0]);
        mcp.prepareNextSentence(words);
        scan = new Scanner(nBestFile);
        double lastProb = 0.0;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.length() == 0) continue;
            if (line.startsWith("vitprob=")) {
                lastProb = Double.parseDouble(line.substring(8));
                continue;
            }
            tree = new TSNodeLabel(line);
            mcp.addNewDerivation(tree, lastProb);
        }
        TSNodeLabel bestTree = mcp.getBestTree();
        System.out.println(bestTree);
        int lexItemsNumber = bestTree.countLexicalNodes();
        System.out.println(words.length);
        System.out.println(lexItemsNumber);
        System.out.println(lexItemsNumber == words.length);
    }

    protected class ViterbiCell {
        protected double score;
        protected Label label;
        protected ViterbiCell[] cellsSplit;

        public ViterbiCell(Label l, int s, int e, double score, ViterbiCell leftSplit, ViterbiCell rightSplit) {
            this.label = l;
            this.score = score;
            this.cellsSplit = new ViterbiCell[]{leftSplit, rightSplit};
        }

        public String toString() {
            return "(" + this.label + "," + this.score + ")";
        }
    }
}

