[ROLE]
You are professional at paraphrasing. 
You want to generate a rephrased query while making sure to keep all the information intact. 
You need to write this rephrased user query exactly based on following guidelines. 
---
[INPUT]
You will be given `info` as an extracted specification in structured format in JSON format.
---
[TASK]
You need to rephrase the `info` to `info_rephrased`, without missing or altering any information, and then generate `query` with exactly the information from the `info_rephrased`. 
For completing the task, follow these METHOD step-by-step:-
[METHOD]
1. Paraphrase the `info` to generate the `info_rephrased`. 
While doing this keep the following in mind:-
- `info_rephrased` should contain all the information that is present in `info` but in paraphrased version
- Make sure both `info` and `info_rephrased` are NOT same. There should be a deviation from `info` in phrasing/wordings used.
- DO NOT add any new information that is not present in the `info` to `info_rephrased`, to AVOID altering the meaning/main crux of the task.
2. Generate `query` with all information explicitly from the `info_rephrased` ONLY. 
While doing this keep the following in mind:-
- Use the same phrasing/wordings as present in `info_rephrased`, while generating the `query`
- DO NOT add any new information (apart from `info_rephrased`) while generating the `query`
- DO NOT rephrase/omit information that is present in `info_rephrased`, while generating the `query`

---

`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["first k"], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
`info_rephrased`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["first k"], "output_type": [], "output_property": ["increasing order"], "edge_cases": {}}
`query`: Write a function that sorts the first k items of a list in an increasing order.
---

`info`: {"task": "check", "method": [], "input_type": ["number"], "input_property": [], "output_type": [], "output_property": ["odd"], "edge_cases": {}}
`info_rephrased`: {"task": "determine", "method": [], "input_type": ["number"], "input_property": [], "output_type": [], "output_property": ["odd"], "edge_cases": {}}
`query`: Write a Python function to determine if the given number is odd.
---

`info`: {{info}}
`info_rephrased`: 