theory question_72_0
imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Touching :: "entity ⇒ entity ⇒ bool"
  Acts :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Counter :: "event ⇒ bool"
  Motion :: "entity ⇒ entity ⇒ event"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Riding :: "event ⇒ entity ⇒ entity ⇒ bool"
  Human :: "entity ⇒ bool"
  YoungHuman :: "entity ⇒ bool"
  Child :: "entity ⇒ bool"
  Move :: "event ⇒ entity ⇒ entity ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  Causes :: "event ⇒ entity ⇒ entity ⇒ bool"
  Speed :: "event ⇒ entity ⇒ nat"
  Decrease :: "nat ⇒ bool"
  Stop :: "event ⇒ bool"
  Moving :: "event ⇒ bool"
  MovedAgainst :: "event ⇒ entity ⇒ bool"
  MovedOver :: "event ⇒ entity ⇒ bool"
  MovedDown :: "event ⇒ entity ⇒ bool"
  Eventual :: "event ⇒ bool"
  Come :: "event ⇒ bool"

(* Explanation 1: friction acts to counter the motion of two objects when their surfaces are touching. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Friction x ∧ Object y ∧ Object z ∧ Surface y ∧ Surface z ∧ Touching y z ∧ Acts e1 ∧ Agent e1 x ∧ Counter e2 ∧ Agent e2 x ∧ Patient e2 (Motion y z)"

(* Explanation 2: a surface is a part of an object. *)
axiomatization where
  explanation_2: "∀x y. Surface x ⟶ PartOf x y"

(* Explanation 3: a wagon is a kind of vehicle. *)
axiomatization where
  explanation_3: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 4: counter means reduce; stop; resist. *)
axiomatization where
  explanation_4: "∀x. Counter x ⟷ (Reduce x ∨ Stop x ∨ Resist x)"

(* Explanation 5: riding something is to move that thing over a surface. *)
axiomatization where
  explanation_5: "∀x y z e1 e2. Agent x ∧ Object y ∧ Surface z ∧ Riding e1 x y ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Move e2 x y ∧ Agent e2 x ∧ Patient e2 y ∧ Over e2 z)"

(* Explanation 6: riding is a kind of motion. *)
axiomatization where
  explanation_6: "∀x y z. Riding x y z ⟶ Motion x y z"

(* Explanation 7: humans ride vehicles. *)
axiomatization where
  explanation_7: "∀x y. Human x ∧ Vehicle y ⟶ (∃e. Ride e x y)"

(* Explanation 8: a child is a kind of young human. *)
axiomatization where
  explanation_8: "∀x. Child x ⟶ YoungHuman x"

(* Explanation 9: if one surface is moved against; moved over; moved down another surface then those surfaces are touching. *)
axiomatization where
  explanation_9: "∀x y z e1. Surface x ∧ Surface y ∧ (MovedAgainst e1 x y ∨ MovedOver e1 x y ∨ MovedDown e1 x y) ∧ Agent e1 x ∧ Patient e1 y ⟶ Touching x y"

(* Explanation 10: motion; movement means moving; to move. *)
axiomatization where
  explanation_10: "∀x y z. Motion x y z ⟷ Moving x y z"

(* Explanation 11: a vehicle is a kind of object. *)
axiomatization where
  explanation_11: "∀x. Vehicle x ⟶ Object x"

(* Explanation 12: friction causes the speed of an object to decrease. *)
axiomatization where
  explanation_12: "∀x y e1 e2. Friction x ∧ Object y ∧ Causes e1 x y ∧ Agent e1 x ∧ Patient e1 e2 ∧ Speed e2 y ⟶ Decrease (Speed e2 y)"

(* Explanation 13: stop; stopped means zero; 0; no speed. *)
axiomatization where
  explanation_13: "∀x. Stop x ⟷ Speed x = 0"

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Ride e1 x y ∧ Agent e1 x ∧ Patient e1 y ∧ Down e1 z"
  (* Premise: eventually, the wagon comes to a stop. *)
  assumes asm2: "∃x e1. Wagon x ∧ Eventual e1 ∧ Come e1 ∧ Agent e1 x ∧ Stop e1"
  (* Hypothesis: friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧  Causing e2 x y ∧ Agent e2 x ∧ Patient e2 e1 ∧ Stop e1 "
proof -
  {
    assume asm: "Child x ∧ Wagon y ∧ Hill z ∧ Ride e1 x y ∧ Agent e1 x ∧ Patient e1 y ∧ Down e1 z"
    assume asm2: "∃x e1. Wagon x ∧ Eventual e1 ∧ Come e1 ∧ Agent e1 x ∧ Stop e1"
    from asm have "Wagon y" by simp
    from asm have "Ride e1 x y" by simp
    from explanation_5[OF this] have "∃e2. Move e2 x y ∧ Agent e2 x ∧ Patient e2 y ∧ Over e2 z" by blast
    from explanation_11 have "Vehicle y" by (simp add: explanation_3)
    from explanation_11 have "Object y" by (simp add: explanation_3)
    from explanation_2 have "Surface z" by (simp add: explanation_11)
    from explanation_9[OF this, explanation_10[OF _ "Move e2 x y"], explanation_10[OF _ "Down e1 z"]]
      have "Touching y z" by blast
    from explanation_1[OF this, explanation_4, explanation_12, explanation_13]
      have "∃x e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e2 x y ∧ Agent e2 x ∧ Patient e2 e1 ∧ Stop e1"
      by blast
  }
  then show ?thesis using asm asm2 by blast
qed

end
