theory question_93_10

imports Main

begin

typedecl entity
typedecl event

consts
  FootPedal :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Circle :: "entity ⇒ bool"
  Moves :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If a foot pedal is part of a bicycle, it can move in a circle. *)
axiomatization where
  explanation_1: "∀x y z e. FootPedal x ∧ Bicycle y ∧ PartOf x y ∧ Circle z ⟶ (Moves e ∧ Agent e x ∧ In e z)"

theorem hypothesis:
  assumes asm: "FootPedal x ∧ Bicycle y ∧ PartOf x y ∧ Circle z"
  (* Hypothesis: The foot pedal of a bicycle moves in a circle. *)
  shows "∃x y z e. FootPedal x ∧ Bicycle y ∧ PartOf x y ∧ Circle z ∧ Moves e ∧ Agent e x ∧ In e z"
proof -
  from asm have "FootPedal x ∧ Bicycle y ∧ PartOf x y ∧ Circle z" by simp
  then obtain e where e: "Moves e ∧ Agent e x ∧ In e z" using explanation_1 by blast
  show ?thesis using asm e by blast
qed

end
