theory question_63_0

imports Main

begin

typedecl entity
typedecl event

consts
  Fossils :: "entity ⇒ bool"
  WaterAnimalOrPlant :: "entity ⇒ bool"
  Place :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  WasCoveredByWater :: "entity ⇒ bool"
  Trilobite :: "entity ⇒ bool"
  WaterAnimal :: "entity ⇒ bool"
  Ohio :: "entity ⇒ bool"
  USA :: "entity ⇒ bool"
  Located :: "event ⇒ bool"
  State :: "entity ⇒ bool"

(* Explanation 1: if fossils of a water animal or plant are found in a place then that place used to be covered by water in the past. *)
axiomatization where
  explanation_1: "∀x y z e1. Fossils x ∧ WaterAnimalOrPlant x ∧ Place y ∧ Found e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ WasCoveredByWater y"

(* Explanation 2: a trilobite is a kind of water animal. *)
axiomatization where
  explanation_2: "∀x. Trilobite x ⟶ WaterAnimal x"  

(* Explanation 3: Ohio is a state located in the United States of America. *)
axiomatization where
  explanation_3: "∃x y e. Ohio x ∧ USA y ∧ Located e ∧ Agent e x ∧ Patient e y"

(* Explanation 4: a state is a kind of place. *)
axiomatization where
  explanation_4: "∀x. State x ⟶ Place x"  

theorem hypothesis:
  (* Premise: the fossils of extinct sea animals called trilobites are found in ohio. *)
  assumes asm: "Fossils x ∧ Trilobite x ∧ Ohio y ∧ Found e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Ohio was once covered by water. *)
  shows "∃x. Ohio x ∧ WasCoveredByWater x"
proof -
  from asm have "Trilobite x" by simp
  then have "WaterAnimal x" using explanation_2 by simp
  then have "WaterAnimalOrPlant x" by simp
  from asm have "Ohio y" by simp
  then have "State y" using explanation_3 by simp
  then have "Place y" using explanation_4 by simp
  from asm have "Found e ∧ Agent e x ∧ Patient e y" by simp
  then have "WasCoveredByWater y" using `WaterAnimalOrPlant x` `Place y` explanation_1 by blast
  then show ?thesis using `Ohio y` by blast
qed

end
