from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.feature_extraction.text import CountVectorizer

import nltk
from nltk.corpus import stopwords

import numpy as np
import os
import re

import pandas as pd

min_freq = 3

path = "categories_onetext_nonproc"

textfiles = os.listdir(path)
textfiles = [os.path.join(path, fname) for fname in textfiles]

domains = [re.search('/(.+?)_en_all.txt', text).group(1) for text in textfiles]
# print(domains)

# stopwords = stopwords.words('english')

#vectorizer = TfidfVectorizer(input='filename', strip_accents='ascii', min_df=2, stop_words=mask_tokens)
vectorizer = CountVectorizer(input='filename', strip_accents='ascii', min_df=min_freq)
count_vectors = vectorizer.fit_transform(textfiles)
feature_arr = vectorizer.get_feature_names()

# tfidf_pairs = zip(feature_arr, np.asarray(count_vectors.sum(axis=0)).ravel())

# get vectors
doc_count = count_vectors.shape[0]

commonwords_path = "lex_stats/common_words"
try:
    os.mkdir(commonwords_path)
except OSError:
    print("Common words directory already created.")

for i in range(doc_count):

    domain_name = domains[i]
    tfidf_vec = count_vectors[i]

    csv_file_name = os.path.join(commonwords_path, domain_name + '_nostops.csv')

    df = pd.DataFrame(tfidf_vec.T.todense(), index=feature_arr, columns=["count"])
    df = df.sort_values(by=["count"], ascending=False)
    df.to_csv(csv_file_name)

    print(f'{csv_file_name} created.')

# count = 0
# for term, freq in tfidf_pairs:
#     print(f'{term} : {freq}')
#     count += 1

# print(f'count = {count}')
