import argparse
import numpy as np
import networkx as nx
import node2vec
from gensim.models import Word2Vec
import nodevectors
import csrgraph as cg
from time import time

def main(args):
    print("Loading graph...")
    G = cg.read_edgelist(args.input, directed=False, sep=' ')  # all graphs are undirected
    # G = cg.read_edgelist("colex_from_AllBabelNet_Concepts/cross_colex_sum.edgelist", directed=False, sep=' ')
    print("Done.")
    node_model = nodevectors.ProNE(n_components=300)
    start_time = time()
    print("Starting node embedding...")
    node_model.fit(G)
    print("Done.")
    total_minutes = (time() - start_time)/60
    print(str(total_minutes) + " total minutes for node embedding process.")
    node_model.save(args.output)
    print("Saved model to " + args.output)

def parse_args():
    '''
    Parses the ProNE arguments.
    '''
    parser = argparse.ArgumentParser(description="Run node2vec.")

    parser.add_argument('--input', nargs='?', default='dummy.edgelist', help='Input graph path')

    parser.add_argument('--output', nargs='?', default='dummy', help='ProNE .zip path')

    parser.add_argument('--dimensions', type=int, default=300,
                        help='Number of dimensions. Default is 300 to match fastText.')

    return parser.parse_args()


if __name__ == "__main__":
    args = parse_args()
    main(args)

    # node_model = nodevectors.Node2Vec(n_components=300,
    #                                   walklen=80,
    #                                   epochs=10,
    #                                   threads=14,
    #                                   verbose=True,
    #                                   w2vparams={"window": 10, "negative": 5, "iter": 1, "sg": 1, "min_count": 1})
    # Word2Vec(walks, size=args.dimensions, window=cont_size, min_count=0, sg=1, workers=args.workers,
    #                          iter=args.iter)
    # embeddings = ggvec_model.fit_transform(G)
    # embeddings = prone_model.fit_transform(G)
