#nvidia-smi topo -m
export NGPU=2
#export NCCL_DEBUG=INFO
export NCCL_SHM_DISABLE=1
python -m torch.distributed.launch --nproc_per_node=$NGPU --master_port 60002 train.py \
--exp_name diverse_nmt \
--exp_id nist_ft_sc_dq
--dump_path /dumped \
--data_path /data/diversity-nmt/ \
--lgs 'en-zh' \
--mt_steps 'zh-en' \
--encoder_only false \
--emb_dim 512 \
--n_layers 6 \
--n_heads 8 \
--dropout 0.1 \
--attention_dropout 0.1 \
--gelu_activation true \
--tokens_per_batch 4096 \
--batch_size 32 \
--bptt 256 \
--optimizer adam_inverse_sqrt,beta1=0.9,beta2=0.98,lr=0.0001 \
--epoch_size 500 \
--eval_bleu true \
--stopping_criterion 'valid_zh-en_mt_bleu,10' \
--validation_metrics 'valid_zh-en_mt_bleu' \
--beam_size 5 \
--save_periodic 1 \
--accumulate_gradients 2 \
--mrt True \
--reload_model /dumped/j92tekio1z/periodic.pth,/dumped/j92tekio1z/periodic.pth