from bs4 import BeautifulSoup

detailed_instructions = BeautifulSoup("""
    <crowd-instructions style="alignment: center" link-text="View instructions" link-type="button">
        <short-summary>
            <p>Complete the prompts with the first thing that comes to your mind.</p>
        </short-summary>

        <detailed-instructions>
            <h3>What Makes Everyday Tasks Possible</h3>
            <p>
                In each example, you are given a prompt, such as:
                <p class="example">A net is used for catching fish, only if</p>
                or
                <p class="example">A net is used for catching fish unless</p>
                you should complete the prompt with <span style="color: darkred">first reasonable thing that comes to your
                mind</span>:
                <p class="example">A net is used for catching fish, only if <u>we are in the water</u></p>
                <p class="example">A net is used for catching fish, unless <u>the net has a large tearing</u></p>
            </p>
            <br>
            <p>
                Our goal is to capture the most common perceptions that come to your mind and is specific to each
                prompt. Please make sure your answers are specific, concise and usual. A simple way to write the answers
                is to focus on the mental image you have after reading the prompt, and then describe what makes the task
                possible or impossible to occur. Below, we have compiled a short list of common bad responses and how to
                fix them:

            <ol>
                <li>
                    <strong style="color: darkred">Avoid Pronouns</strong> when referring to <strong>objects</strong>. In the examples below, the
                    "net", "fish", "boat", and "sea" are all objects, and thus, <strong>use the objects' name explicitly</strong> when
                    refering to them. <br>
                    <div class="emph-box">
                        A net is used for catching fish, unless
                        <ul>
                            <li><span style="color: darkred">it</span> has large tearings.
                                <i class="fa fa-window-close" style="color:darkred"></i>
                            </li>
                            <li><span style="color: green">the net</span> has large tearings.<i
                                    class="fa fa-check-circle" style="color:green"></i>
                            </li>
                        </ul>
                    </div>
                    <br>
                    <div class="emph-box">
                        A net is used for catching fish only if
                        <ul>
                            <li>there are some <span style="color: green">fish</span> in the water.
                                <i class="fa fa-check-circle" style="color:green"></i>
                            </li>
                            <li>we are in the water.
                                <i class="fa fa-check-circle" style="color:green"></i>
                            </li>
                        </ul>
                    </div>
                </li>
                <li>
                    <strong style="color: green">Use pronouns</strong> when referring to the <strong>person(s)</strong> performing the task when they
                    are <strong>not mentioned</strong> in the prompt.
                    <div class="emph-box">
                        A net is used for catching fish, unless
                        <ul>
                            <li><span style="color: green">we</span> are in a desert.
                                <i class="fa fa-check-circle" style="color:green"></i>
                            </li>
                        </ul>
                    </div>
                </li>
                <li>
                    <strong style="color: darkred">Do Not Overthink</strong>: Avoid using unusual responses.
                    We are looking for things that are obvious to you but not mentioned in the prompt.
                    <div class="emph-box">
                        <ul>
                            A net is used for catching fish, unless
                            <li>the sun is exploding.<i class="fa fa-window-close" style="color:darkred"></i></li>
                            <li>there is an earthquake.<i class="fa fa-window-close" style="color:darkred"></i></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <strong style="color: green">Be Specific</strong>: Avoid using general responses that are not specific to the prompt.
                    Additionally, please do not use responses that can be used for another similar prompt.
                    <div class="emph-box">
                        <ul>
                            A net is used for catching fish, unless
                            <li>the boat is broken.<i class="fa fa-window-close" style="color:darkred"></i></li>
                            <li>the net is broken.<i class="fa fa-window-close" style="color:darkred"></i></li>
                            <li>the net is not working.<i class="fa fa-window-close" style="color:darkred"></i></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <strong style="color: darkred">Avoid Negatives</strong>: Avoid using negatives (e.g. not) in your responses.
                    <div class="emph-box">
                        <ul>
                            A net is used for catching fish, only if
                            <li>the net does <span style="color: darkred">not have</span> a large tearing.<i
                                    class="fa fa-window-close" style="color:darkred"></i></li>
                        </ul>
                    </div>
                </li>
            </ol>
            </p>
        </detailed-instructions>
        <negative-example>
            <div class="emph-box">
                A net is used for catching fish unless<br>
                -> it has a large hole.<i class="fa fa-window-close" style="color:darkred"></i> <br>
                (Avoid using pronouns when referring to objects.)
            </div>
        </negative-example>

        <positive-example>
            <div class="emph-box">
                A net is used for catching fish unless<br>
                -> the net has a large tearing.<i class="fa fa-check-circle" style="color:green"></i>
            </div>
        </positive-example>

        <positive-example>
            <div class="emph-box">
                A net is used for catching fish only if<br>
                -> we are in the water.<i class="fa fa-check-circle" style="color:green"></i><br>
                (Pronouns are permitted when referring to the person(s) performing the task.
                Do not use pronouns when referring to objects.)
            </div>
        </positive-example>

        <positive-example>
            <div class="emph-box">
                A net is used for catching fish only if<br>
                -> the net is the right size.<i class="fa fa-check-circle" style="color:green"></i>
            </div>
        </positive-example>

        <negative-example>
            <div class="emph-box">
                A net is used for catching fish unless<br>
                -> the boat is sinking.<i class="fa fa-window-close" style="color:darkred"></i> (Do not overthink)
            </div>
        </negative-example>

        <negative-example>
            <div class="emph-box">
                A net is used for catching fish unless<br>
                -> the net is broken.<i class="fa fa-window-close" style="color:darkred"></i> (Be more specific)
            </div>
        </negative-example>

        <positive-example>
            <div class="emph-box">
                A net is used for catching fish unless<br>
                -> there is no fish in the water.<i class="fa fa-check-circle" style="color:green"></i>
            </div>
        </positive-example>
        <positive-example>
            <div class="emph-box">
                A net is used for catching fish only if<br>
                -> if we are near water.<i class="fa fa-check-circle" style="color:green"></i>
            </div>
        </positive-example>

        <negative-example>
            <div class="emph-box">
                A net is used for catching fish unless <br>
                -> it is illegal to fish in the area.<i class="fa fa-window-close" style="color:darkred"></i> <br>
                (Do not Overthink)
            </div>
        </negative-example>

    </crowd-instructions>
    <crowd-modal
            link-text="Why we do this study?"
            link-type="button">
        <p>
            We are conducting an academic study on the implicit expectations people have about everyday phenomenons
            (Common Sense). We need to understand your mental image about the common tasks and usages of everyday
            objects, by asking about the conditions that enable or disable the task or the usage of that specific
            object. for more info please refer to <a href="https://www.darpa.mil/program/machine-common-sense">this
            link</a>.
        </p>
    </crowd-modal>
""", "html.parser")
submit_button = BeautifulSoup("""
<div class="empty-box">
    <crowd-button form-action="submit" variant="primary">
        <span style="font-size: 28px;margin-top: 1px; min-width: 10cm;">Submit</span>
    </crowd-button>
</div>
""", "html.parser")
