## Description
### Inception V3 Feature Vector
This is an Image Feature Vector model from [TensorFlow Hub](https://tfhub.dev/google/imagenet/inception_v3/feature_vector/4). It takes an 
image as input and returns an feature vector (embedding) of the image. 

The model available for deployment is pretrained on ImageNet (ILSVRC-2012-CLS) 
which comprises images of 1000 different classes.

## Use the Deployed Model for Inference
The deployed model can be used for running inference on any input image. 
Example python code for how to run inference on the deployed model is 
given in a notebook you can open by clicking 'Open Notebook' 
on the model endpoint page that is created when deploying the model.

The model outputs a 1-D feature vector (embedding) of the input image. 

Below are two example images and their respective model predictions. 
For each of the two example images, we show the first 5 elements of the feature vector, 
and the total dimension of the feature vector.

| | |
| --------------------------------------------- | --------------------------------------------- |
| ![cat.jpg](https://jumpstart-cache-prod-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/cat.jpg)  | First-5 elements of model predictions vectors: {0.153946742, 0.248072103, 0.226678163, 0.207509384, 0.130591422}, with total feature vector (embedding) size 2048. |
| ![dog.jpg](https://jumpstart-cache-prod-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/dog.jpg)  | First-5 elements of model predictions vectors: {0.192799926, 1.9650085, 0.206394464, 0.0370086096, 0.586791}, with total feature vector (embedding) size 2048. |

For each of example images above, the most similar image is found from a image repository based on their feature vectors (embedding).
The image repository contains another 5 different images, as shown below.

| | | |
| --------------------------------------------- | --------------------------------------------- | --------------------------------------------- |
| ![cat.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_cow.jpg) | ![dog.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_deer.jpg) | ![dog.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_turtle.jpg) |
| ![repo_cat.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_cat.jpg) | ![dog.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_dog.jpg) |

Specifically, the most similar image in the repository is defined as the one with the smallest cosine dis-similarity distance in the feature vector (embedding) space.
The similarity search results are presented as below.

| | |
| --------------------------------------------- | --------------------------------------------- |
| ![cat.jpg](https://jumpstart-cache-prod-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/cat.jpg)  |  ![cat.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_cat.jpg)
| ![dog.jpg](https://jumpstart-cache-prod-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/dog.jpg)  |  ![cat.jpg](https://jumpstart-cache-alpha-us-west-2.s3-us-west-2.amazonaws.com/tensorflow-metadata/assets/img_repo_dog.jpg)


source: [TensorFlow Hub](https://tfhub.dev/google/imagenet/inception_v3/feature_vector/4). License:[Apache 2.0 License](https://jumpstart-cache-prod-us-west-2.s3-us-west-2.amazonaws.com/licenses/Apache-License/LICENSE-2.0.txt).
