from structures import Function
from sparqlEngine import SparqlEngine


def reverse_dir(direction):
    return 'backward' if direction == 'forward' else 'forward'

def get_concept_name(data, concept_id):
    if concept_id:
        concept_name = data.concepts[concept_id]['name']
    else:
        concept_name = 'entity'
    return concept_name



def convert_program_list(program):
    for i, f in enumerate(program):
        f.id = i
        f.dependencies = [g if isinstance(g, int) else g.id for g in f.dependencies]
    return program


def replace_duplicate_variables(sparql1, sparql2, same_sub=True):
    if same_sub:
        variables1 = SparqlEngine.get_all_variables(sparql1)
        for v in variables1:
            if v != '?e':
                while v in variables1:
                    sparql2, new_v = SparqlEngine.replace_variable(sparql2, v)
                    if new_v == v:
                        break
                    else:
                        v = new_v
        return sparql1, sparql2
    else: 
    # use ?e_1 for subject of sparql1, ?e_2 for subject of sparql2
        sparql1, var1 = SparqlEngine.replace_variable(sparql1, '?e')
        sparql2, var2 = SparqlEngine.replace_variable(sparql2, '?e')
        sparql2, var2 = SparqlEngine.replace_variable(sparql2, var2)
        assert var1 == '?e_1' and var2 == '?e_2'
        # first replace ?e_2 in sparql1
        sparql1, _ = SparqlEngine.replace_variable(sparql1, var2)
        # then replace ramaining variables of sparql1 in sparql2
        variables1 = SparqlEngine.get_all_variables(sparql1)
        for v in variables1:
            while v in variables1:
                sparql2, new_v = SparqlEngine.replace_variable(sparql2, v)
                if new_v == v:
                    break
                else:
                    v = new_v
        return sparql1, sparql2

def and_two_descriptions(condition1, condition2):
    text1, program1, sparql1 = condition1.description()
    text2, program2, sparql2 = condition2.description()

    assert condition1.concept == condition2.concept, 'To merge two descriptions, they must have the same concept'
    concept_name = get_concept_name(condition1.data, condition1.concept)
    text = '{} and {}'.format(text1, ' '.join(text2.split()[1+len(concept_name.split()):]))
    program = program1 + program2 + \
            [ Function('And', [program1[-1], program2[-1]], []) ]
    
    # remove duplicate clauses about the concept
    clauses2 = SparqlEngine.get_all_clauses(sparql2)
    clauses2 = [c for c in clauses2 if '?c' not in c]
    sparql2 = SparqlEngine.ensemble_clauses(clauses2)
    sparql1, sparql2 = replace_duplicate_variables(sparql1, sparql2)
    sparql = sparql1 + sparql2

    return text, program, sparql


def or_two_descriptions(condition1, condition2):
    text1, program1, sparql1 = condition1.description()
    text2, program2, sparql2 = condition2.description()

    assert condition1.concept == condition2.concept, 'To merge two descriptions, they must have the same concept'
    concept_name = get_concept_name(condition1.data, condition1.concept)
    text = '{} or {}'.format(text1, ' '.join(text2.split()[1+len(concept_name.split()):]))
    program = program1 + program2 + \
            [ Function('Or', [program1[-1], program2[-1]], []) ]
    
    clauses1 = SparqlEngine.get_all_clauses(sparql1)
    sparql0 = SparqlEngine.ensemble_clauses([c for c in clauses1 if '?c' in c]) # clauses about the common concept, should be shared
    sparql1 = SparqlEngine.ensemble_clauses([c for c in clauses1 if '?c' not in c])
    clauses2 = SparqlEngine.get_all_clauses(sparql2)
    sparql2 = SparqlEngine.ensemble_clauses([c for c in clauses2 if '?c' not in c])
    sparql = '{} {{ {} }} UNION {{ {} }}'.format(sparql0, sparql1, sparql2) 
    # Warning: after using UNION, we cannot split and ensemble clauses anymore.
    return text, program, sparql


def hop_two_descriptions(condition1, condition2):
    """
    condition1 applies relate to the resultant entity of condition2
    """
    text1, program1, sparql1 = condition1.description()
    text2, program2, sparql2 = condition2.description()
    sparql1, sparql2 = replace_duplicate_variables(sparql1, sparql2)

    sparql2, obj_variable = SparqlEngine.replace_variable(sparql2, '?e')

    text, program, sparql = condition1.description(obj_desc=(text2, program2, sparql2, obj_variable))
    return text, program, sparql
