TMEPLATE = {
    'restaurants': {
        'user': {
            'welcome': ['good morning', 'hello', 'hi', 'how do you do', 'how are you'],
            'inform_all': ['i \'d like to book a table',
                           'may i have a table',
                           'can you make a restaurant reservation', 'i want a place to eat',
                           'can you find me a restaurant', 'i am looking for a restaurant',
                           'help me find a good restaurant',
                           'please reserve a table'],
            'inform_food': ['with %s cuisine', 'with %s food', 'i love %s food',
                            'i usually like eating the %s food', 'do you have %s food type',
                            '%s is lovely', 'i enjoy %s food', 'how about the %s type'],
            'inform_location': ['in %s', '%s please',
                                'i would like for it to be in %s', 'i will be eating in %s',
                                'i want to be in %s', '%s certainly', 'i \'d like it in %s'],
            'inform_people': ['for %s please', 'we will be %s', 'we have %s people',
                              'there are totally %s people', 'give me a table for %s',
                              '%s people please', 'we are %s'],
            'inform_price': ['in a %s price range please', 'i am looking for a %s restaurant',
                             'i would like a %s price', '%s price', 'i want %s place',
                             'i can afford %s price', 'any %s restaurant', '%s place is ok'],
            'deny': ['no', 'no that \'s ok', 'no need'],
            'affirm': ['that \'s correct', 'yes', 'yeah',
                       'you are right', 'good', 'ok', 'that \'s good',
                       'yes it seems good for me', 'sounds good'],
            'change': ['actually i would prefer %s', 'instead could it be %s',
                       'can you change it %s',
                       'in fact i want it %s please', 'sorry i would like it be %s',
                       'can i change it %s', 'it would be better %s'],
            'refuse': ['no i do n\'t like that', 'no this does not work for me',
                       'do you have another restaurant matching my needs',
                       'find me another restaurant', 'do you have other options',
                       'suggest me another restaurant please', 'are there any other restaurants nearby'
                       ],
            'agree': ['i love that', 'it \'s perfect', 'let \'s do it', 'that looks great',
                      'alright that seems good', 'i would like to make a booking at this restaurant',
                      'that suits me well', 'sounds good', 'that sounds ok',
                      'yes i would like to make a reservation'],
            'request': ['do you have its %s', 'may i have the %s of the restaurant',
                        'what is the %s of the restaurant', 'can you provide the %s',
                        'can you give me the %s of this restaurant', 'ok what is the %s'],
            'thanks': ['thanks for the information', 'you rock', 'i appreciate it', 'thanks a lot',
                       'thank you very much', 'great', 'excellent'],
            'byebye': ['no thanks', 'no thank you', 'that would be all', 'that\'s all i need for now']

        },
        'sys': {
            'welcome': ['hello what can i help you with today'],
            'request_food': ['any preference on a type of cuisine'],
            'request_location': ['where should it be'],
            'request_people': ['how many people would be in your party'],
            'request_price': ['which price range are looking for'],
            'req_change': ['sure is there anything else to update'],
            'recommend': ['what do you think of this option : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['sure let me find another one what about this option : entityOrder=%d'],
            'reserve': ['great let me do the reservation'],
            'inform': ['here it is entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['is there anything i can help you with'],
            'byebye': ['you \'re welcome']

        }
    },
    'hotels': {
        'user': {
            'welcome': ['what \'s up', 'hello', 'hi', 'hey', 'how you doing', 'how are you'],
            'inform_all': ['i \'d like to reserve a hotel', 'may i book a hotel',
                           'could you please make a hotel reservation', 'i want to make a hotel booking',
                           'can you find me a place to stay', 'i am looking for a hotel',
                           'find a great hotel', 'help me reserve a hotel', 'i want to find a room in a hotel there'],
            'inform_checkin': ['i want to start at %s', 'the check in date is %s', 'i \'d like to check in %s',
                               'do you have room on %s', '%s would be ok', 'starting from %s', 'i need to check in %s'],
            'inform_checkout': ['i will leave on %s', 'the check out date is %s', 'maybe %s',
                                'i would like to check out on %s', 'maybe %s', 'i \'d like to check out %s'],
            'inform_location': ['find a room in %s please', 'in %s', 'find me hotels in %s',
                                'i would like it to be in %s', 'i will be staying in %s',
                                'i \'d like to go to %s'],
            'inform_room': ['%s rooms please', 'we need %s', 'we need %s rooms',
                            'there are %s rooms', 'give me %s rooms', '%s'],
            'inform_room_single': ['%s room please', 'we only need %s', 'we need %s room',
                                   'just %s room', 'give me %s room', 'just %s'],
            'inform_price': ['in a %s price range please', 'i am looking for a %s room',
                             'i would like a %s price range', 'find me a %s room', '%s hotel please',
                             'can you find %s hotels'],
            'deny': ['no', 'no it \'s ok', 'no thanks'],
            'affirm': ['correct', 'okay', 'yeah', 'alright',
                       'good', 'ok', 'that \'s good',
                       'seems okay for me', 'sounds fine', 'sure'],
            'change': ['actually i would prefer %s', 'instead could it be %s',
                       'please change it into a reservation %s',
                       'i want it %s', 'sorry i would like it be %s',
                       'can you update it %s', 'it would be much better %s',
                       'it might as well %s'],
            'refuse': ['no i do n\'t want this', 'no this does not work for me',
                       'do you have another hotel matching my needs',
                       'find me another hotel please', 'do you have other rooms',
                       'suggest me another hotel please', 'are there any other hotels nearby'
                       ],
            'agree': ['i love that', 'yes that \'s perfect with me', 'let \'s do it', 'that looks great',
                      'alright that seems good', 'i would like to make a booking at this restaurant',
                      'that suits me well', 'sounds good', 'that sounds ok',
                      'i \'d like to make a reservation please',
                      'i could not agree more'],
            'request': ['do you know its %s', 'may i have the %s of the hotel',
                        'what is the %s of the room', 'could you provide me the %s',
                        'can you give me the %s of this hotel', 'alright what is the %s'],
            'thanks': ['thanks for the information', 'fantastic', 'i really appreciate it', 'thanks a lot',
                       'thank you very much', 'great', 'excellent'],
            'byebye': ['no thanks', 'no thank a bunch', 'no that would be all', 'that\'s all i need for now thank you']

        },
        'sys': {
            'welcome': ['how can i help you'],
            'request_checkin': ['when will you check in'],
            'request_checkout': ['what date will you check out'],
            'request_location': ['where should it be'],
            'request_room': ['how many rooms would be in your reservation'],
            'request_price': ['which price range in your mind'],
            'req_change': ['sure anything else you want to change'],
            'recommend': ['what about this hotel : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['ok how about this one : entityOrder=%d'],
            'reserve': ['great i will do the reservation'],
            'inform': ['sure here it is entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['do you need more help'],
            'byebye': ['no worries']

        }
    },
    'travels': {
        'user': {
            'welcome': ['what \'s going on', 'how \'s it going', 'how you doing', 'how are you'],
            'inform': ['can you give me a tourist recommendation',
                       'can you find me some tourist attractions',
                       'i am looking for some', 'do you know any good place to travel',
                       'help me find some good attractions',
                       'can you get me some attractions'],
            'inform_all': ['can you give me a tourist recommendation about %s in %s',
                           'can you find me some tourist attractions like %s in %s',
                           'i am looking for some %s in %s', 'do you know any great %s in %s',
                           'help me find some good attractions like %s in %s',
                           'i \'m looking for some %s in %s',
                           'can you show me some attractions such as %s in %s'],
            'inform_country': ['anything of a place in %s to travel', 'i would like to travel to %s',
                               'i usually like travelling in %s', 'any tourist attractions in %s',
                               'i would like for it to be in %s', 'i will have a trip in %s',
                               'i \'d like to have a trip in %s', 'i want a place in %s to go'],
            'inform_category': ['i would like to visit some %s', 'i love %s',
                                'this time i will go to see  %s',
                                'find some %s to visit', 'we are on a trip to some %s',
                                'i am looking for some %s', 'any attractions like %s',
                                'i \'d like to go to %s', 'some place like %s'],
            'deny': ['no', 'no that \'s ok', 'oh no'],
            'affirm': ['that \'s correct', 'yes', 'yeah',
                       'you are right', 'good', 'ok',
                       'yep', 'cool',
                       'sounds better',
                       'of course', 'that \'s right'],
            'change': ['in fact i would prefer %s', 'instead could it be %s', 'could you please update it %s',
                       'sorry i actually want it be %s', 'can i make it %s', 'it would be better %s',
                       'i \'d rather it %s'],
            'refuse': ['i do n\'t want it', 'no that does not work', 'i \'ll think about it',
                       'do you have another attraction matching my needs',
                       'get me another tourist attraction', 'well do you have other choices',
                       'suggest me another place to go', 'are there any other attractions'],
            'agree': ['i like that', 'i am with you', 'let \'s do it', 'that looks really good',
                      'alright that seems ok', 'i would like to book tickets at this place',
                      'that suits me well', 'that sounds fine',
                      'ok i would like to have some tickets'],
            'request': ['do you have its %s', 'may i have the %s of the restaurant',
                        'what is the %s of the restaurant', 'can you provide the %s',
                        'can you give me the %s of this restaurant', 'ok what is the %s',
                        'do you know the %s'],
            'request_free entry': ['is it free', 'is the entry free', 'does it charge'],
            'thanks': ['thanks for your information', 'you rock', 'appreciate it', 'thanks a bunch',
                       'thank you thank you', 'nice', 'that \'s cool', 'cheers'],
            'byebye': ['no thanks', 'no thank you', 'that would be all', 'that\'s all i need for now']

        },
        'sys': {
            'welcome': ['i am good what can i help you with'],
            'request_category': ['any preference on a type of tourist attractions'],
            'request_country': ['which country do you want to travel'],
            'req_change': ['no problem anything else to update'],
            'recommend': ['is this movie entityOrder=%d ok'],  # entityOrder=*
            'next_recommend': ['what do you think about entityOrder=%d'],
            'reserve': ['great let me contact to get you tickets'],
            'inform': ['here it is entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['anything else i can help with'],
            'byebye': ['anytime']

        }
    },
    'movies': {
        'user': {
            'welcome': ['how do you do', 'hello', 'hi', 'how you doing', 'how are you'],
            'inform_all': ['can you provide me a movie',
                           'do you have any recent movies',
                           'do you know any films',
                           'help me find some interesting movies',
                           'i \'m looking for some movies',
                           'show me some movies',
                           'can you find me a movie',
                           'can you provide me some good movies',
                           'i am looking for some movies to watch',
                           'any recent films',
                           'help me find some good movies',
                           'can you get me some movies',
                           'i want to watch a movie'],
            'inform_director': ['i would like to watch a film made by %s',
                                '%s is my favorite director', 'i like movies directed by %s',
                                '%s','i want to see %s \'s movies', 'i love %s \'s movies',
                                'the movie i want to watch should be directed by %s',
                                '%s', '%s of course'],
            'inform_actor': ['my idol is %s', '%s', 'does %s have new movies',
                             '%s \'s movies would be nice to watch',
                             'i \'d like to watch movies starred by %s',
                             'some movies %s starred in', 'any movies acted by %s',
                             'find me %s \'s movies'],
            'inform_category': ['i am interested in finding a %s movie that i can watch',
                                'any %s movies to watch', 'i enjoy %s movies',
                                'i want to watch %s movies', 'i love %s films',
                                'get me some %s films', 'in the genre of %s'],
            'deny': ['no', 'no need'],
            'affirm': ['certainly', 'yes', 'yeah', 'good', 'ok',
                       'that seems good for me', 'sounds good', 'absolutely',
                       'that \'s right', 'seems right'],
            'change': ['in fact i would prefer movies %s', 'instead could it be %s', 'can you update it %s',
                       'now i want the movie %s', 'that would be better if it %s',
                       'i \'d rather movies %s'],
            'refuse': ['sorry i do n\'t want it', 'that does not work for me',
                       'do you have another movies matching my needs',
                       'get me another movie', 'do you have other movies',
                       'suggest me another movie to watch',
                       'are there any other movies', 'i am not interested'],
            'agree': ['i like that', 'perfect', 'let \'s play it', 'sure it is good',
                      'alright play it now', 'that suits me well', 'that sounds fine',
                      'ok i would like to watch it', 'definitely this one'],
            'request_cast': ['do you know its cast', 'give me the cast of this movie',
                             'can you provide the cast of this film'],
            'request_free': ['is this movie free', 'can i watch it for free',
                             'does it charge', 'is the film free'],
            'request_length': ['how long is the movie', 'how long does it take', 'what \'s the movie length'],
            'request_introduction': ['can you introduce it', 'what \'s the introduction',
                                     'give me the film introduction'],
            'thanks': ['thanks for the information', 'many thanks', 'sweet', 'thanks a lot',
                       'thank you so much', 'nice ', 'that \'s cool'],
            'byebye': ['no thanks', 'no thank you', 'that would be all thanks', 'no that \'s all i need for now']
        },
        'sys': {
            'welcome': ['hello may i help you'],
            'request_category': ['which genre do you prefer'],
            'request_director': ['which director do you like'],
            'request_actor': ['any preference on the movie stars'],
            'req_change': ['is there anything else to update'],
            'recommend': ['i find this one : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['ok how about this movie : entityOrder=%d'],
            'reserve': ['great let me play this movie for you'],
            'inform': ['here you are entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['anything else'],
            'byebye': ['anytime']
        }
    },
    'music': {
        'user': {
            'welcome': ['how you doing', 'how are you', 'good morning', 'how do you do'],
            'inform': [
                'i need to find a song for a party', 'i would like to hear songs',
                'i \'d like to hear a song', 'can you play some music for me',
                'how can i find music', 'give me some music',
                'show me some music', 'play some music please'
                'can you recommend me a song'],
            'inform_all': ['find me a %s song of %s',
                           'any %s music played by %s',
                           'i \'m looking for some %s music of %s',
                           'can you find me a %s song by %s',
                           'do you know any %s music by %s'],
            'inform_category': ['i would like to hear some %s songs',
                                'do you have %s music', 'can you find %s music',
                                'any %s songs to play', 'play some %s music for me',
                                'i want some %s songs', 'find some %s music',
                                'can you play a %s song'],
            'inform_singer': ['give some music of my idol %s',
                              'i \'d like a song by %s',
                              'i love %s \'s songs',
                              'i \'d like to hear %s \'s music',
                              'does %s release new songs',
                              'i \'d like to listen to songs by %s',
                              'any music by %s',
                              'i would like to listen to %s songs'],
            'deny': ['no', 'nothing to change now'],
            'affirm': ['nice', 'yes', 'yeah', 'good', 'ok',
                       'that \'s right', 'yes please', 'seems good',
                       'you bet'],
            'change_category': ['in fact i would prefer %s music',
                                'instead could it be %s',
                                'i want to change it into %s',
                                'how about the %s songs'],
            'change_singer': ['i \'d rather %s \'s songs',
                              'now i want to listen to music by %s',
                              'can you play a song by %s instead',
                              'actually i enjoy %s \'s songs'],
            'refuse': ['oh i do n\'t like it', 'i have listened it before',
                       'get me another song please', 'do you have other songs',
                       'do you have other suggestions',
                       'are there any other music', 'i am sorry i do n\'t want it'],
            'agree': ['i love this one', 'play it', 'let \'s do it', 'yes please do',
                      'ok play it for me', 'that suits me well', 'that sounds fine',
                      'ah that \'s the one', 'yes i want this one'],
            'request': ['do you know its %s', 'what \'s its %s',
                        'can you find the %s of this song',
                        'what is the %s of the music'],
            'thanks': ['really good music', 'thanks a lot', 'i truly appreciate it',
                       'thank you very much', 'perfect', 'wonderful music'],
            'byebye': ['no thanks', 'no thank you', 'it would be all', 'nope that \'s all i need for now']
        },
        'sys': {
            'welcome': ['hello what can i do for you'],
            'request_singer': ['any singer in your mind'],
            'request_category': ['what kind of music do you like'],
            'req_change': ['is there anything else to update'],
            'recommend': ['what do you think of this song : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['how about another song : entityOrder=%d'],
            'reserve': ['great let me play this song for you'],
            'inform': ['here you are entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['can i help you with anything else'],
            'byebye': ['you are welcome']
        }
    },
    'buses': {
        'user': {
            'welcome': ['hello', 'hi', 'what \'s up', 'what \'s going on'],
            'inform': ['can you help me out and look for a bus for me',
                       'can you get me a bus ticket',
                       'i \'m going on a quick trip and need to get a bus',],
            'inform_all': ['i am leaving %s',
                           'is there a bus that leaves %s',
                           'i \'m going %s',
                           'can you help me search for a bus %s'],
            'inform_from': ['i am leaving out from %s',
                            'from %s',
                            'leaving from %s',
                            'the origin city is %s'],
            'inform_to': ['i want to visit %s',
                          'to %s',
                          'i am going to %s',
                          'the destination city is %s'],
            'inform_leaving date': ['i am leaving on %s',
                                    'the leaving date is %s',
                                    'i will leaving on %s'],
            'inform_ticket': ['i would like to get %s tickets',
                              '%s tickets please',
                              'i need it for %s people',
                              'for % people'],
            'inform_ticket_single': ['i would like to get one ticket',
                                     'just one ticket',
                                     'i need it for one people',
                                     'only one ticket', 'one please'],
            'deny': ['no', 'no please', 'that \'s all'],
            'affirm': ['correct', 'yes', 'good', 'sure',
                       'sounds ok', 'yes please', 'seems great'],
            'change': ['that \'s not right it \'s %s',
                       'anything else %s',
                       'is there anything else %s',
                       'i \'d like it %s',
                       'in fact i would prefer the bus %s',
                       'instead could it be %s',
                       'i want to change it into %s',
                       'now please change it %s',
                       'actually i need it %s'],
            'refuse': ['i do n\'t like this bus', 'find me another bus',
                       'get me another option please',
                       'do you have other buses',
                       'are there any other buses'],
            'agree': ['that is ok for me', 'that sounds perfect',
                      'sounds great i would like to reserve its tickets',
                      'let \'s buy the tickets',
                      'ok reserve it for me',
                      'yes i want that one',
                      'yes please buy the ticket'],
            'request_fare': ['how much is the ticket',
                             'what is the fare',
                             'how much does it cost totally'],
            'request_address': ['where is the bus station',
                                'how can i go to the station',
                                'what is the address of the station'],
            'thanks': ['thanks so much for your help', 'thanks a million',
                       'all i could say is thanks', 'it \'s perfect', 'yep that sounds good to me'],
            'byebye': ['nope thanks again for helping me',
                       'no thank you so much', 'that would be all thanks a lot']
        },
        'sys': {
            'welcome': ['hello what can i do for you'],
            'request_from': ['where are you leaving from'],
            'request_to': ['where are you going'],
            'request_ticket': ['how many tickets do you want'],
            'request_leaving date': ['when will you leave'],
            'req_change': ['is there anything else to update'],
            'recommend': ['what do you think of this bus : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['how about another bus : entityOrder=%d'],
            'reserve': ['great your tickets will be reserved'],
            'inform': ['yes entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['can i help you with anything else'],
            'byebye': ['not at all']
        }
    },
    'flights': {
        'user': {
            'welcome': ['hey', 'hi', 'hello', 'how \'s it going', 'how are you doing'],
            'inform': ['can you help me out and look for a flight for me',
                       'can you get me a flight ticket',
                       'can you find me some round trip flights',
                       'i am in a hurry find some flights for me',
                       'i would like to book a flight',
                       'i would like to get a flight',
                       'can you find some flights please'],
            'inform_all': ['i want to fly %s',
                           'i will be flying %s',
                           'i \'m leaving %s',
                           'can you help me search for a flight %s',
                           'i want to get a flight %s',
                           'please help me to find a flight %s',
                           'any flights %s',
                           'help me to find some flights %s'],
            'inform_from': ['i am leaving out from %s',
                            'from %s', 'help me get out of %s',
                            'leaving from %s',
                            'the departure city is %s'],
            'inform_to': ['i \'d like visit %s',
                          'to %s', 'i want to go to %s',
                          'i am going to %s', '%s please',
                          'the destination city is %s'],
            'inform_leaving date': ['i am leaving on %s',
                                    'the leaving date is %s',
                                    'i will leaving on %s',
                                    'on %s', 'maybe on %s'],
            'inform_ticket': ['i would like to get %s tickets',
                              '%s tickets please',
                              'i need it for %s people',
                              'for %s people',
                              'i need %s tickets please'],
            'inform_ticket_single': ['i would like to get one ticket',
                                     'just one ticket',
                                     'i need it for one people',
                                     'only one ticket', 'one please',
                                     'just one'],
            'deny': ['no', 'that \'s all', 'nothing to update'],
            'affirm': ['correct', 'yeah right', 'good', 'sure',
                       'sounds ok', 'yes please', 'seems great',
                       'that seems nice'],
            'change': ['that \'s not right it \'s %s',
                       'any flights else %s',
                       'i \'d like it %s',
                       'in fact i would prefer the flight %s',
                       'instead could it be %s',
                       'i want to change it %s',
                       'now please change it %s',
                       'actually i need it %s'],
            'refuse': ['i do n\'t like this flight',
                       'find me another flight',
                       'get me another option please',
                       'do you have other flights',
                       'are there any other flights',
                       'sorry i want other flights'],
            'agree': ['that is ok for me',
                      'that sounds perfect',
                      'sounds great i would like to reserve this flight',
                      'let \'s buy the tickets',
                      'ok book the flight for me',
                      'yes i want that one',
                      'yes please buy the ticket',
                      'can not agree with you more'
                      ],
            'request_fare': ['how much is the ticket',
                             'what is the fare',
                             'how much does it cost totally'],
            'request_airport': ['where is the airport',
                                'how can i go to the airport',
                                'what is the address of the airport'],
            'thanks': ['thanks so much for your help',
                       'thanks a lot',
                       'thank you very much',
                       'it \'s perfect',
                       'yep that sounds good to me'],
            'byebye': ['nope thanks a million',
                       'no that would be all', 'that \'s all thanks']
        },
        'sys': {
            'welcome': ['hi what can i do for you'],
            'request_from': ['where are you leaving from'],
            'request_to': ['where are you going'],
            'request_ticket': ['how many tickets do you want'],
            'request_leaving date': ['when will you leave'],
            'req_change': ['is there anything else to update'],
            'recommend': ['do you like this flight : entityOrder=%d'],  # entityOrder=*
            'next_recommend': ['sure is entityOrder=%d ok for you'],
            'reserve': ['great your flight will be reserved'],
            'inform': ['it is entityOrder=%d %s'],  # entityOrder=* + requestable
            'req_more': ['can i help you with anything else'],
            'byebye': ['my pleasure']
        }
    },
    'weather': {
        'user': {
            'welcome': ['hello', 'good morning', 'hey'],
            'inform': ['can you help me check the weather',
                       'please check the weather for me',
                       'find me the weather forecast',
                       'i am leaving soon can you check the weather'],
            'inform_all': ['please check the weather %s',
                           'how \'s the weather %s',
                           'what \'s the temperature %s',
                           'i need the weather forecast %s',
                           'i would like to check the weather %s',
                           'i want to know the weather %s'],
            'inform_location': ['in %s', '%s',
                                'weather in %s',
                                'please check %s',
                                'can you check the weather in %s for me'],
            'inform_date': ['%s', 'i want to know the weather %s',
                            'i would like %s', 'give me %s weather',
                            'find me weather %s'],
            'deny': ['no', 'that \'s all', 'nothing to update'],
            'change': ['what \'s the weather %s',
                       'how about the weather %s',
                       'what \'s the temperature %s'],
            'byebye': ['thanks for the information', 'thanks a lot',
                       'thank you very much', 'thanks', 'that would be all']
        },
        'sys': {
            'welcome': ['hello how can help you'],
            'request_location': ['which city would you like to check'],
            'request_date': ['which date do you want to check'],
            'req_more': ['can i help you with anything else'],
            'byebye': ['it \'s my pleasure']
        }
    },
}