/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.CharEncUtils;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.basic.Utils;
import fig.record.CommandProcessor;
import fig.record.Receiver;
import fig.record.RecordServerInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.util.ArrayList;

public class RecordShell {
    private Options options;
    private RecordServerInterface server;

    public RecordShell(Options options) {
        this.options = options;
        this.connectToServer();
    }

    private void connectToServer() {
        try {
            this.server = (RecordServerInterface)Naming.lookup("//" + this.options.serverHost + "/RecordServer/" + this.options.id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void printStackTrace(Throwable t) {
        LogInfo.stderr.println("EXCEPTION: " + t.getMessage());
        LogInfo.stderr.print(Utils.getStackTrace(t, "sun.reflect"));
        LogInfo.stderr.flush();
    }

    public void run() {
        new CommandProcessor(this.server, this.options.baseTempDir, true, this.options.firewall).processCommandFiles(this.options.commandFiles);
        if (!this.options.interactive) {
            return;
        }
        IOUtils.LineMunger munger = new IOUtils.LineMunger(){

            @Override
            public void beforeLine(boolean isContinuation) {
                try {
                    if (isContinuation) {
                        LogInfo.stdout.print("... ");
                    } else {
                        LogInfo.stdout.print(RecordShell.this.server.getPrompt());
                    }
                    LogInfo.stdout.flush();
                }
                catch (ConnectException e) {
                    LogInfo.stderr.println("Connection to server lost, reconnecting...");
                    RecordShell.this.connectToServer();
                }
                catch (Throwable t) {
                    RecordShell.printStackTrace(t);
                }
            }

            @Override
            public void afterFullLine(String line) {
                try {
                    String pipeCmd = null;
                    String outFile = null;
                    int i = line.indexOf(" | ");
                    if (i != -1) {
                        pipeCmd = line.substring(i + 3).trim();
                        line = line.substring(0, i);
                    }
                    if ((i = line.indexOf(" > ")) != -1) {
                        outFile = line.substring(i + 3).trim();
                        line = line.substring(0, i);
                    }
                    BufferedReader in = null;
                    BufferedReader err = null;
                    PrintWriter out = null;
                    Process proc = null;
                    if (pipeCmd != null) {
                        proc = Utils.openSystem("cat | " + pipeCmd);
                        out = CharEncUtils.getWriter(proc.getOutputStream());
                        in = CharEncUtils.getReader(proc.getInputStream());
                        err = CharEncUtils.getReader(proc.getErrorStream());
                    } else {
                        out = outFile != null ? IOUtils.openOutHard(outFile) : LogInfo.stdout;
                    }
                    Receiver receiver = new Receiver(((RecordShell)RecordShell.this).options.baseTempDir, out, LogInfo.stderr);
                    new CommandProcessor(RecordShell.this.server, receiver, true, ((RecordShell)RecordShell.this).options.firewall).processCommand(line);
                    if (out != LogInfo.stdout) {
                        out.close();
                    }
                    if (proc != null) {
                        IOUtils.copy(err, LogInfo.stderr);
                        err.close();
                        IOUtils.copy(in, LogInfo.stdout);
                        in.close();
                        Utils.closeSystemEasy("cat | " + pipeCmd, proc);
                    }
                }
                catch (ConnectException e) {
                    LogInfo.stderr.println("Connection to server lost, reconnecting...");
                    RecordShell.this.connectToServer();
                }
                catch (Throwable t) {
                    RecordShell.printStackTrace(t);
                }
            }
        };
        try {
            IOUtils.doProgramLines(LogInfo.stdin, munger);
            LogInfo.stdout.println("");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Options options = new Options();
        if (!new OptionsParser().register("main", options).parse(args)) {
            return;
        }
        try {
            RecordShell shell = new RecordShell(options);
            shell.run();
        }
        catch (Throwable t) {
            RecordShell.printStackTrace(t);
        }
    }

    public static class Options {
        @Option(gloss="Hostname of record server.")
        public String serverHost = "localhost";
        @Option(gloss="Local command files files to process.")
        public ArrayList<String> commandFiles = new ArrayList();
        @Option(gloss="Interactive mode.")
        public boolean interactive = true;
        @Option(gloss="Temporary directory")
        public String baseTempDir = "tmp";
        @Option(gloss="Whether the client is behind a firewall")
        public boolean firewall = true;
        @Option(gloss="Identifier of the record server to connect to.", required=true)
        public String id;
    }
}

