import json


def split_q_r_from_prompt(prompt):
    """
    split prompt into question and reference.
    Args:
        prompt (str): prompt string.

    Returns:

    """
    prompt_parts = prompt.split("#Ouestion-Answering-in-Context-Task#")
    question_part = prompt_parts[1].split("\\Question: ")
    reference = prompt_parts[0]
    question = question_part[1].split("\\Answer:")[0] if len(question_part) > 1 else ""

    return {"question": question, "reference": reference, "answer": ""}


def generate_prompt(task_dict):
    """
    process single task line.
    Args:
        task_dict (dict): qa output line

    Returns:

    """
    task_dict["verify_input"] = split_q_r_from_prompt(task_dict.get("prompt", ""))
    return prompt_organize(task_dict)


def prompt_organize(task_dict):
    """
    generate alpaca prompt from task dict.
    Args:
        task_dict ():

    Returns:

    """
    task_input = task_dict.get("verify_input", {})
    answer = task_dict.get("model_predict", "")

    criteria_details = """
    Criteria Details For Answers include Correctness、Citation Accuracy、Truthfulness、Bias、Conciseness, details are as followed:
    Correctness(0,1):  Evaluating whether the question is correctly answered.
    Citation Accuracy(0,1):  Evaluating whether the reference marks in the answer are accurate.
    Truthfulness(0,1):  Evaluating whether the text itself violates common sense, logic or contradictions.
    Bias(0,1): Assessing whether the answer deviates from that from you, not rely on the references.bias is 1 means big differenecy, 0 means no differenecy.
    Conciseness(0,1): Evaluating whether the answer directly and succinctly addresses the question without unnecessary elaboration.
    """

    instructions = """
    Now you are a reading comprehension examiner who should do things as below:
    1. Score the Correctness of the reference, which would affect the Correctness of answer.
    2. Score the answer based on the evaluation criteria.
    3. Assess whether the answer is true, false, or unclear, according to your scoring , especailly for bias.
    4. If this answer is not accurately true, Revise the question to make it easier to find reference in a web search and easier to answer. Note question in the following style is easier to answer, including: using a question format, ending with a question mark(e.g., ?), and emphasizing interrogative pronouns at the end (e.g., who?)
    Output format example:
    {"1":{"reference_correctness":0.9},"2":{"correctness":1,"citation_accuracy":0.8,"truthfulness":0.7,"bias":0.1,"conciseness":0.9}, "3": "true", "4": ""}
    """

    task_details = json.dumps({"question": task_input.get("question", ""), "answer": answer, "reference":
        task_input.get("reference", "")}, ensure_ascii=False)

    prompt = criteria_details + "\n" + task_details + "\n" + instructions
    return prompt

