import json
import os
import argparse
import concurrent
from request_llms import request_chatgpt
from agent import SearchAgent
from tqdm import tqdm

parser = argparse.ArgumentParser()
parser.add_argument("--max_context_len", type=int, help="Maximum context length", default=4000)
parser.add_argument("--input_path", type=str, help="Maximum context length")
parser.add_argument("--out_path", type=str, help="Maximum context length")

args = parser.parse_args()

def get_existing_data(save_file):
    fi = open(save_file, 'r')
    data = []
    for line in fi:
        data.append(json.loads(line.strip('\n')))
    return data


def process_agent_run_step(agent, index):
    return agent.run(index)

import sys
if __name__ == '__main__':

    f_profile = open(args.input_path, 'r')
    save_file = args.out_path
 
    if os.path.exists(save_file):
        existing_data = get_existing_data(save_file)
       
        print(f"Existing data length: " + str(len(existing_data)))
        profiles = [profile.strip('\n') for profile in f_profile][len(existing_data):]
       
    else:
        profiles = [profile.strip('\n') for profile in f_profile]

    agents = [SearchAgent(profile, args.max_context_len) for profile in profiles]
    sessions = {}
    completed_count = 0
    

    with concurrent.futures.ThreadPoolExecutor(max_workers=1) as executor:
        future_to_index = {executor.submit(process_agent_run_step, agent, i): i for i, agent in enumerate(agents)}

        for future in tqdm(concurrent.futures.as_completed(future_to_index)):
            index = future_to_index[future]
            sessions[index] = future.result()

            while completed_count in sessions:
                fo.writelines(json.dumps(sessions[completed_count], ensure_ascii=False) + '\n')
                all_datas.append(json.dumps(sessions[completed_count]))
                
                del sessions[completed_count]
                completed_count += 1


 