#!/bin/bash
python=path to python

mkdir -p logs

CUDA=$1
echo $CUDA

export CUDA_VISIBLE_DEVICES=$CUDA
export VLLM_USE_MODELSCOPE="False"

model_ckpt=$2
model_config=$3

output_dir=path_to_output
qafs=(
    path_to_test_data
)

for qaf in ${qafs[@]}; do
    echo $qaf
    timestamp=$( date +"%Y%m%d_%H%M%S")
    echo $timestamp
    $python ../../../n_sbs/solver_demo.py \
    --custom_cfg $model_config \
    --qaf $qaf \
    --output_dir $output_dir \
    --model_ckpt $model_ckpt > ./logs/$(basename ${qaf})_$timestamp.log 2>&1
    wait
done
