import os


def get_user_path() -> str:
	"""
	Helper function that reads the user_path.txt and return its path.

	Returns:
		str: The data path.
	"""
	with open(os.path.join(os.path.dirname(__file__), '..', 'configuration', 'user_path.txt'), 'r') as path_file:
		return path_file.read()


class PathManager():
	# Since we want to allow devs to call different parts of the application without going through `filtering.py` we need a way of getting
	# the correct data path without havign to call `manage_data_path`, which is why we use `get_user_path()`.
	# Note: The `PathManager` is smart and knows if it has already called `get_user_path()`, so each time the program is run it will
	# only get called once, even when `PathManager.user_path` is used multiple times.
	user_path = get_user_path()

	@classmethod
	def get_results_path(cls):
		results_path = os.path.join(cls.user_path, 'results')
		# os.makedirs(results_path, exist_ok=True)
		return results_path

	@classmethod
	def get_data_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'data/subreddits')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_preprocessing_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'preprocessing')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_analysis_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'analysis')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_filtered_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'filtered')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_filtered_all_comments_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'filtered_all_comments')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_question_answers_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'question_answers')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def get_poll_data_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'poll_data')
		# os.makedirs(data_path, exist_ok=True)
		return data_path
	
	@classmethod
	def get_preprocessed_data_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'preprocessed_data')
		# os.makedirs(data_path, exist_ok=True)
		return data_path
	
	@classmethod
	def get_special_submission_ids_path(cls) -> str:
		data_path = os.path.join(cls.user_path, 'special_submission_ids')
		# os.makedirs(data_path, exist_ok=True)
		return data_path

	@classmethod
	def info(cls):
		print('This is just the path manager, please run `filtering.py` if you want any action.')
		print(f'The current user path is "{PathManager.user_path}".')
		print(f'The data will be saved under "{PathManager.get_data_path()}".')
		print(f'The results will be saved under "{PathManager.get_results_path()}".')


if __name__ == '__main__':
	PathManager.info()