import glob
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import re
import matplotlib.patches as mpatches
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# subjective_prompts = [
# "Write a review about a restaurant.",
# "How did you like the movie yesterday?",
# "Write a reddit post on a round-trip through Europe.",
# "How will the economy develop in the next years?",
# "Write an emotional sentence.",
# "Write a short poem.",
# "What can be said about jazz?",
# "Tell somebody to postpone the meeting.",
# "Write a short note about yesterdays experience.",
# "What are properties of red wine?",
# ]

# factual_prompts = [
# "What is the capital of Sweden?",
# "Which sights can I visit in Amsterdam?",
# "How many people live in the world?",
# "What is the difference between tsunamis and hurricanes?",
# "How to brew coffee?",
# "How old is the Eifel tower?",
# "When was Alan Turing born?",
# "Why are most leaves green?",
# "How many planets are in the solar system?",
# "What is the most populated city in the world?",
# ]


sentences_factual = [
    "What is the capital city of France?",
    "Who is the current President of the United States?",
    "How many planets are there in our solar system?",
    "What is the chemical symbol for gold?",
    "In which year did World War II end?",
    "Who painted the Mona Lisa?",
    "What is the largest ocean in the world?",
    "What is the formula for calculating the area of a circle?",
    "Who wrote the novel 'Pride and Prejudice'?",
    "What is the speed of light in a vacuum?",
    "What is the chemical formula for water?",
    "Which country is famous for the Taj Mahal?",
    "Who discovered the theory of general relativity?",
    "What is the tallest mountain in the world?",
    "How many players are there in a baseball team?",
    "What is the formula for converting Celsius to Fahrenheit?",
    "Who is credited with inventing the telephone?",
    "Which gas makes up the majority of Earth's atmosphere?",
    "What is the largest organ in the human body?",
    "How many symphonies did Ludwig van Beethoven compose?",
    "What is the largest country in the world by land area?",
    "Who wrote the novel 'To Kill a Mockingbird'?",
    "How many chambers are there in the human heart?",
    "What is the chemical symbol for sodium?",
    "In which year did the first moon landing occur?",
    "Who painted 'The Starry Night'?",
    "What is the deepest point in the Earth's oceans?",
    "What is the formula for calculating the volume of a cylinder?",
    "Who is the author of the play 'Romeo and Juliet'?",
    "What is the boiling point of water in Fahrenheit?",
    "What is the chemical formula for methane?",
    "Which country is known as the Land of the Rising Sun?",
    "Who developed the theory of evolution by natural selection?",
    "What is the tallest building in the world?",
    "How many players are there in a volleyball team?",
    "What is the formula for calculating density?",
    "Who is considered the father of modern physics?",
    "Which gas is known as laughing gas?",
    "What is the largest internal organ in the human body?",
    "How many elements are there in the periodic table?",
    "Who discovered penicillin?",
    "What is the chemical formula for table salt?",
    "How many bones are there in the human body?",
    "What is the symbol for the chemical element iron?",
    "In which year did the Berlin Wall fall?",
    "Who painted the 'Last Supper'?",
    "What is the world's longest river?",
    "What is the formula for calculating the area of a triangle?",
    "Who wrote the play 'Hamlet'?",
    "What is the freezing point of water in Kelvin?"
]

sentences_subjective = [
"If a roommate consistently borrows your belongings without asking, how would you handle it?",
"Describe an incident that could lead to an airplane crash in mid-flight.",
"What did a day in a typical family in the year 1980 look like?",
"Tell me a joke.",
"Order a vegan dish from the menu of a steak house.",
"Ask your hairdresser for an appointment next week to have your hair dyed.",
"Write an introduction about yourself for a CV.",
"Review the pair of headphones that I bought online last week.",
"Tell me about the concert in America last year.",
"What do german bread rolls taste like?",
"How can I learn about Machine Learning most efficiently?",
"How do caterpillars turn into a butterflies?",
"Write a recipe to make chocolate chip muffins.",
"Compose a few lines of a lyrics talking about society.",
"Announce the weather forecast for the upcoming weekend.",
"Compare the taste of a strawberry smoothie to that of a vanilla one.",
"Share a personal anecdote about a vacation you had ",
"What are the steps to bake a perfect pizza from scratch?",
"Discuss the impact of social media on interpersonal relationships.",
"Describe a piece of artwork.",
"Share a personal experience that challenged your beliefs and changed your perspective.",
"Describe a person who has had an impact on your life and why.",
"Share a quote or mantra that inspires you and explain why it resonates with you.",
"Describe a fictional character.",
"Share a personal experience of overcoming a fear or facing a challenge.",
"Describe a meal or dish that holds sentimental value to you and why.",
"Compare the colors blue and green.",
"If a roommate consistently borrows your belongings without asking, how would you handle it?",
"How would you handle a disagreement with a close friend?",
"What approach would you take when faced with a challenging work colleague?",
"How would you respond to a rude customer in a customer service role?",
"What strategies do you find most effective for managing stress?",
"How do you approach decision-making when faced with multiple options?",
"What is your preferred method of learning new skills or acquiring knowledge?",
"How do you prioritize your tasks and responsibilities in your daily life?",
"What does a fulfilling and meaningful life mean to you?",
"How do you stay motivated and focused on long-term goals?",
"What approaches do you take to foster creativity and innovation in your work?",
"How do you feel about the death penalty?",
"How do you define happiness?",
"How do you define sadness?",
"How do you define art?",
"What is your opinion on the role of government in society?",
"What is your stance on the role of machine learning in education?",
"What is your perspective on the significance of cultural heritage?",
"Comment on a critical review of a costumer of your business.",
"Would you like to see a movie about yourself?",
"Compare the cultural value of theaters and cinemas.",
"Compare the qualities of coffee and tea.",
"Compare the relaxation based on vacation and continuous sport."
]

sentences_shakes_subjective = [

"Write a review about a restaurant.",
"How did you like the movie yesterday?",
"Write a reddit post on a round-trip through Europe.",
"How will the economy develop in the next years?",
"Write an emotional sentence.",
"Write a short poem.",
"What can be said about jazz?",
"Tell somebody to postpone the meeting.",
"Write a short note about yesterdays experience.",
]

sentences_shakes_factual = [
"What are properties of red wine?",
"What is the capital of Sweden?",
"Which sights can I visit in Amsterdam?",
"How many people live in the world?",
"What is the difference between tsunamis and hurricanes?",
"How to brew coffee?",
"How old is the Eifel tower?",
"When was Alan Turing born?",
"Why are most leaves green?",
"How many planets are in the solar system?",
"What is the most populated city in the world?",

]

factual_prompts = sentences_factual
subjective_prompts = sentences_subjective





def adapt_df(df, csvfile):
    direc = ""
    to = ""
    if "ToNegative" in csvfile:
        direc = "modern"
        to = "ToNegative"
    else:
        direc = "shakes"
        to = "ToPositive"
    s = csvfile
    # result = re.search(f"/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/scripts/evaluation/results/{method}/{technique}/{manner}/(.*).csv", s)
    # result = result.group(1)
    
    result = s.split(f"eval_{to}_", 1)[1]

    # result = re.search(f"eval_{to}_(.*)", result)
    # result = result.group(1)
    input_text = len(df) * [result[:-4]]
    direction = len(df) * [direc]
    df["direction"] = direction
    df["input_text"] = input_text

    df = df.rename(columns={'lamda': 'lambda'})
    return df


def mean_plots(sentences_factual_manner, sentences_subjective_manner):
    for idx, csvfile in enumerate(csv_files):
        df = pd.read_csv(csvfile, delimiter=',')
        df = adapt_df(df, csvfile)
        for jdx, emotion in enumerate(basic_emotions):
            emotion_dfs[jdx] = pd.concat([emotion_dfs[jdx], df[df['direction'] == emotion]], ignore_index=True)

    
    dfs_emotional_prompts = [dfe[dfe['input_text'].isin(sentences_subjective)] for dfe in emotion_dfs]
    dfs_factual_prompts = [dfe[dfe['input_text'].isin(sentences_factual)] for dfe in emotion_dfs]

    fig, axs = plt.subplots(1, 2, figsize=(10, 5))
    for idx, emo_df in enumerate(dfs_factual_prompts):
        emotion = emo_df.iloc[0]["direction"]

        df_ovr = emo_df

        df_ovr_melt = pd.melt(df_ovr, id_vars=['lambda'], value_vars=["modern", "shakes"])
        df_ovr_melt['sample'] = range(len(df_ovr_melt))

        # Finding the samples with the highest values
        max_value = df_ovr_melt['value'].max()
        max_samples = df_ovr_melt[df_ovr_melt['value'] == max_value]
        
        sns.lineplot(data=df_ovr_melt, x='lambda', y='value',  hue='variable', ax=axs[idx]) #  x
        axs[idx].set_xlim(0,4.0)
        axs[idx].set_ylim(0,1.0)
        # axs[idx].set_title(f'Yelp - Steering direction: {emotion}')
        if emotion == "shakes":
            axs[idx].set_title(f"Yelp - steering to shakespearian style")
        else:
            axs[idx].set_title(f"Yelp - steering to modern style")
        axs[idx].set_ylabel("Shakespearian classifier score")
        axs[idx].set_xlabel("Lambda")

        one = Line2D([0], [0], label='modern')
        two = Line2D([0], [0], label='shakespear', color='orange')

        legend = axs[idx].legend(handles=[one, two])
        # axs[idx].get_legend().remove()
        axs[idx].grid()
    fig.tight_layout()

    fig.savefig(f'/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/plots/eval/shakes_contrastive_factual_source_{manner}_{method}.png')
    plt.clf()

    fig, axs = plt.subplots(1, 2, figsize=(10, 5))
    for idx, emo_df in enumerate(dfs_emotional_prompts):
        emotion = emo_df.iloc[0]["direction"]

        df_ovr = emo_df

        df_ovr_melt = pd.melt(df_ovr, id_vars=['lambda'], value_vars=["modern", "shakes"])

        

        sns.lineplot(data=df_ovr_melt, x='lambda', y='value', hue='variable', ax=axs[idx])
        axs[idx].set_xlim(0,4.0)
        axs[idx].set_ylim(0,1.0)
        # axs[idx].set_title(f'Yelp - Steering direction: {emotion}')
        if emotion == "shakes":
            axs[idx].set_title(f"Yelp - steering to shakespearian style")
        else:
            axs[idx].set_title(f"Yelp - steering to modern style")
        axs[idx].set_ylabel("Shakespearian classifier score")
        axs[idx].set_xlabel("Lambda")

        one = Line2D([0], [0], label='modern')
        two = Line2D([0], [0], label='shakespear', color='orange')

        legend = axs[idx].legend(handles=[one, two])
        axs[idx].grid()
    fig.tight_layout()
    fig.savefig(f'/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/plots/eval/shakes_contrastive_subjective_source_{manner}_{method}.png')
    plt.clf()

def individual_plots(t="subjective"):
    
    
    for emotion in basic_emotions:
        fig, ax1 = plt.subplots(1, 1, constrained_layout=True)
        for idx, csvfile in enumerate(csv_files):
            df = pd.read_csv(csvfile, delimiter=',')
            df = adapt_df(df, csvfile)
            if t == "subjective":
                df = df[df['input_text'].isin(sentences_subjective_manner)] 
            else:
                df = df[df['input_text'].isin(sentences_factual_manner)] 
        
            df_emotion = df[df['direction'] == emotion]
            df_ovr = df_emotion
            
            
            # fig.suptitle(f'Steering \"{df_ovr["prompt"][0]}\"\n towards {emotion}')
            
            for emo in basic_emotions_w_neutral:
                if emo == "pos": 
                    col="green"
                else:
                    col="red"
                ax1.plot(df_ovr['lambda'], df_ovr[emo], label=emo, color=col)

            ax1.set_title(f"Yelp - steering to {emotion}")

            ax1.set_xlabel('Lambda')
            ax1.set_ylabel('Emotion Classifier Score')
        

        red_patch = mpatches.Patch(color='red', label='negative sentiment')
        blue_patch = mpatches.Patch(color='green', label='positive sentiment')

        plt.legend(handles=[red_patch, blue_patch])
        plt.savefig(f'/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/plots/eval/shakes_individual_to_{emotion}_{t}.png')


technique = "contrastive"
method2 = "activation_based_multi_new_questions2"
method = "activation_based_shakes"
manners = ["positive", "negative", "original", "neutral"]
manners = ["original"]
q_type = ["subjective", "factual"]

for manner in manners:
    sentences_factual_manner = []
    sentences_subjective_manner = []
    if manner == "original":
        sentences_factual_manner = factual_prompts
        sentences_subjective_manner = subjective_prompts
    else:
        for sent in factual_prompts:
            sentences_factual_manner.append(sent + f" Write the answer in a {manner} manner.")

        for sent in subjective_prompts:
            sentences_subjective_manner.append(sent + f" Write the answer in a {manner} manner.")
    

    csv_files = glob.glob(f"/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/scripts/evaluation/results/{method}/{technique}/{manner}/*.csv")
    # csv_files += glob.glob(f"/localdata2/dial_mo/loki/emex-emotion-explanation-in-ai/scripts/evaluation/results/{method2}/{technique}/{manner}/*.csv")
    basic_emotions = ["modern", "shakes"]
    basic_emotions_w_neutral = ["modern", "shakes"]

    emotion_dfs = [pd.DataFrame()] * len(basic_emotions)
    
    # individual_plots(t="factual")
    mean_plots(sentences_factual_manner, sentences_subjective_manner)
