/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.ling.tokensregex.types.ValueFunctions;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.time.Options;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.time.TimeExpressionPatterns;
import edu.stanford.nlp.time.TimeFormatter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;

public class GenericTimeExpressionPatterns
implements TimeExpressionPatterns {
    Env env;
    Options options;

    public GenericTimeExpressionPatterns(Options options) {
        this.options = options;
        this.initEnv();
        if (options.binders != null) {
            for (Env.Binder binder : options.binders) {
                binder.bind(this.env);
            }
        }
    }

    @Override
    public CoreMapExpressionExtractor createExtractor() {
        List<String> filenames = StringUtils.split(this.options.grammarFilename, "\\s*[,;]\\s*");
        return CoreMapExpressionExtractor.createExtractorFromFiles(this.env, filenames);
    }

    private void initEnv() {
        this.env = TokenSequencePattern.getNewEnv();
        this.env.setDefaultResultsAnnotationExtractor(TimeExpression.TimeExpressionConverter);
        this.env.setDefaultTokensAnnotationKey(CoreAnnotations.NumerizedTokensAnnotation.class);
        this.env.setDefaultResultAnnotationKey(TimeExpression.Annotation.class);
        this.env.setDefaultNestedResultsAnnotationKey(TimeExpression.ChildrenAnnotation.class);
        this.env.setDefaultTokensAggregators(CoreMapAttributeAggregator.DEFAULT_NUMERIC_TOKENS_AGGREGATORS);
        this.env.bind("nested", TimeExpression.ChildrenAnnotation.class);
        this.env.bind("time", new TimeFormatter.TimePatternExtractRuleCreator());
        this.env.setDefaultStringPatternFlags(2);
        this.env.bind("options", this.options);
        this.env.bind("TIME_REF", SUTime.TIME_REF);
        this.env.bind("TIME_REF_UNKNOWN", SUTime.TIME_REF_UNKNOWN);
        this.env.bind("TIME_UNKNOWN", SUTime.TIME_UNKNOWN);
        this.env.bind("TIME_NONE", SUTime.TIME_NONE);
        this.env.bind("ERA_AD", 1);
        this.env.bind("ERA_BC", 0);
        this.env.bind("ERA_UNKNOWN", -1);
        this.env.bind("HALFDAY_AM", 0);
        this.env.bind("HALFDAY_PM", 1);
        this.env.bind("HALFDAY_UNKNOWN", -1);
        this.env.bind("RESOLVE_TO_THIS", 32);
        this.env.bind("RESOLVE_TO_PAST", 64);
        this.env.bind("RESOLVE_TO_FUTURE", 128);
        this.env.bind("RESOLVE_TO_CLOSEST", 512);
        this.env.bind("numcomptype", CoreAnnotations.NumericCompositeTypeAnnotation.class);
        this.env.bind("numcompvalue", CoreAnnotations.NumericCompositeValueAnnotation.class);
        this.env.bind("temporal", TimeExpression.Annotation.class);
        this.env.bind("::IS_TIMEX_DATE", new TimexTypeMatchNodePattern(SUTime.TimexType.DATE));
        this.env.bind("::IS_TIMEX_DURATION", new TimexTypeMatchNodePattern(SUTime.TimexType.DURATION));
        this.env.bind("::IS_TIMEX_TIME", new TimexTypeMatchNodePattern(SUTime.TimexType.TIME));
        this.env.bind("::IS_TIMEX_SET", new TimexTypeMatchNodePattern(SUTime.TimexType.SET));
        this.env.bind("::IS_TIME_UNIT", new MatchedExpressionValueTypeMatchNodePattern("TIMEUNIT"));
        this.env.bind("::MONTH", new MatchedExpressionValueTypeMatchNodePattern("MONTH_OF_YEAR"));
        this.env.bind("::DAYOFWEEK", new MatchedExpressionValueTypeMatchNodePattern("DAY_OF_WEEK"));
        for (SUTime.TemporalOp temporalOp : SUTime.TemporalOp.values()) {
            this.env.bind(temporalOp.name(), new Expressions.PrimitiveValue<SUTime.TemporalOp>("TemporalOp", temporalOp, new String[0]));
        }
        for (Enum enum_ : SUTime.TimeUnit.values()) {
            if (enum_.equals((Object)SUTime.TimeUnit.UNKNOWN)) continue;
            this.env.bind(enum_.name(), new Expressions.PrimitiveValue<SUTime.Duration>("TIMEUNIT", ((SUTime.TimeUnit)enum_).getDuration(), new String[0]));
        }
        for (Enum enum_ : SUTime.StandardTemporalType.values()) {
            this.env.bind(enum_.name(), new Expressions.PrimitiveValue<Enum>("TemporalType", enum_, new String[0]));
        }
        this.env.bind("Duration", new Expressions.PrimitiveValue<1>("FUNCTION", new ValueFunctions.NamedValueFunction("Duration"){

            private SUTime.Temporal addEndPoints(SUTime.Duration d, SUTime.Time beginTime, SUTime.Time endTime) {
                SUTime.Temporal t = d;
                if (d != null && (beginTime != null || endTime != null)) {
                    SUTime.Time b = beginTime;
                    SUTime.Time e = endTime;
                    if (b == SUTime.TIME_REF_UNKNOWN) {
                        b = new SUTime.RefTime("UNKNOWN");
                    } else if (b == SUTime.TIME_UNKNOWN) {
                        b = new SUTime.SimpleTime("UNKNOWN");
                    }
                    if (e == SUTime.TIME_REF_UNKNOWN) {
                        e = new SUTime.RefTime("UNKNOWN");
                    } else if (e == SUTime.TIME_UNKNOWN) {
                        e = new SUTime.SimpleTime("UNKNOWN");
                    }
                    t = new SUTime.Range(b, e, d);
                }
                return t;
            }

            @Override
            public boolean checkArgs(List<Value> in) {
                return true;
            }

            @Override
            public Value apply(Env env, List<Value> in) {
                if (in.size() == 2) {
                    SUTime.Duration d = (SUTime.Duration)in.get(0).get();
                    if (in.get(1).get() instanceof Number) {
                        int m = ((Number)in.get(1).get()).intValue();
                        return new Expressions.PrimitiveValue<SUTime.Duration>("DURATION", d.multiplyBy(m), new String[0]);
                    }
                    if (in.get(1).get() instanceof String) {
                        Integer n = Integer.parseInt((String)in.get(1).get());
                        if (n != null) {
                            return new Expressions.PrimitiveValue<SUTime.Duration>("DURATION", d.multiplyBy(n), new String[0]);
                        }
                        return null;
                    }
                    throw new IllegalArgumentException("Invalid arguments to " + this.name);
                }
                if (in.size() == 5 || in.size() == 3) {
                    List durationStartTokens = (List)in.get(0).get();
                    Number durationStartVal = durationStartTokens != null ? (Number)((Number)((CoreMap)durationStartTokens.get(0)).get(CoreAnnotations.NumericCompositeValueAnnotation.class)) : (Number)null;
                    List durationEndTokens = (List)in.get(1).get();
                    Number durationEndVal = durationEndTokens != null ? (Number)((Number)((CoreMap)durationEndTokens.get(0)).get(CoreAnnotations.NumericCompositeValueAnnotation.class)) : (Number)null;
                    List durationUnitTokens = (List)in.get(2).get();
                    TimeExpression te = durationUnitTokens != null ? (TimeExpression)((CoreMap)durationUnitTokens.get(0)).get(TimeExpression.Annotation.class) : null;
                    SUTime.Duration durationUnit = (SUTime.Duration)te.getTemporal();
                    SUTime.Duration durationStart = durationStartVal != null ? durationUnit.multiplyBy(durationStartVal.intValue()) : null;
                    SUTime.Duration durationEnd = durationEndVal != null ? durationUnit.multiplyBy(durationEndVal.intValue()) : null;
                    SUTime.Duration duration = durationStart;
                    if (duration == null) {
                        duration = durationEnd != null ? durationEnd : new SUTime.InexactDuration(durationUnit);
                    } else if (durationEnd != null) {
                        duration = new SUTime.DurationRange(durationStart, durationEnd);
                    }
                    SUTime.Time beginTime = in.size() > 3 ? (SUTime.Time)in.get(3).get() : null;
                    SUTime.Time endTime = in.size() > 4 ? (SUTime.Time)in.get(4).get() : null;
                    SUTime.Temporal temporal = this.addEndPoints(duration, beginTime, endTime);
                    if (temporal instanceof SUTime.Range) {
                        return new Expressions.PrimitiveValue<SUTime.Temporal>("RANGE", temporal, new String[0]);
                    }
                    return new Expressions.PrimitiveValue<SUTime.Temporal>("DURATION", temporal, new String[0]);
                }
                throw new IllegalArgumentException("Invalid number of arguments to " + this.name);
            }
        }, new String[0]));
        this.env.bind("DayOfWeek", new Expressions.PrimitiveValue<2>("FUNCTION", new ValueFunctions.NamedValueFunction("DayOfWeek"){

            @Override
            public boolean checkArgs(List<Value> in) {
                if (in.size() != 1) {
                    return false;
                }
                return in.get(0) != null && in.get(0).get() instanceof Number;
            }

            @Override
            public Value apply(Env env, List<Value> in) {
                if (in.size() == 1) {
                    return new Expressions.PrimitiveValue<SUTime.Temporal>(SUTime.StandardTemporalType.DAY_OF_WEEK.name(), SUTime.StandardTemporalType.DAY_OF_WEEK.createTemporal(((Number)in.get(0).get()).intValue()), new String[0]);
                }
                throw new IllegalArgumentException("Invalid number of arguments to " + this.name);
            }
        }, new String[0]));
        this.env.bind("MonthOfYear", new Expressions.PrimitiveValue<3>("FUNCTION", new ValueFunctions.NamedValueFunction("MonthOfYear"){

            @Override
            public boolean checkArgs(List<Value> in) {
                if (in.size() != 1) {
                    return false;
                }
                return in.get(0) != null && in.get(0).get() instanceof Number;
            }

            @Override
            public Value apply(Env env, List<Value> in) {
                if (in.size() == 1) {
                    return new Expressions.PrimitiveValue<SUTime.Temporal>(SUTime.StandardTemporalType.MONTH_OF_YEAR.name(), SUTime.StandardTemporalType.MONTH_OF_YEAR.createTemporal(((Number)in.get(0).get()).intValue()), new String[0]);
                }
                throw new IllegalArgumentException("Invalid number of arguments to " + this.name);
            }
        }, new String[0]));
        this.env.bind("MakePeriodicTemporalSet", new Expressions.PrimitiveValue<4>("FUNCTION", new ValueFunctions.NamedValueFunction("MakePeriodicTemporalSet"){

            @Override
            public boolean checkArgs(List<Value> in) {
                if (in.size() < 3) {
                    return false;
                }
                if (in.get(0) == null || !(in.get(0).get() instanceof SUTime.Temporal) && !(in.get(0).get() instanceof TimeExpression)) {
                    return false;
                }
                if (in.get(1) == null || !(in.get(1).get() instanceof String) && !(in.get(1).get() instanceof List)) {
                    return false;
                }
                return in.get(2) != null && in.get(2).get() instanceof Number;
            }

            @Override
            public Value apply(Env env, List<Value> in) {
                if (in.size() >= 1) {
                    SUTime.Duration period;
                    Number arg2;
                    SUTime.Temporal temporal = null;
                    Object t = in.get(0).get();
                    if (t instanceof SUTime.Temporal) {
                        temporal = (SUTime.Temporal)in.get(0).get();
                    } else if (t instanceof TimeExpression) {
                        temporal = ((TimeExpression)t).getTemporal();
                    } else {
                        throw new IllegalArgumentException("Type mismatch on arg0: Cannot apply " + this + " to " + in);
                    }
                    String quant = null;
                    int scale = 1;
                    if (in.size() >= 2 && in.get(1) != null) {
                        Object arg1 = in.get(1).get();
                        if (arg1 instanceof String) {
                            quant = (String)arg1;
                        } else if (arg1 instanceof List) {
                            List cms = (List)arg1;
                            quant = ChunkAnnotationUtils.getTokenText(cms, CoreAnnotations.TextAnnotation.class);
                            if (quant != null) {
                                quant = quant.toLowerCase();
                            }
                        } else {
                            throw new IllegalArgumentException("Type mismatch on arg1: Cannot apply " + this + " to " + in);
                        }
                    }
                    if (in.size() >= 3 && in.get(2) != null && (arg2 = (Number)in.get(2).get()) != null) {
                        scale = arg2.intValue();
                    }
                    if ((period = temporal.getPeriod()) != null && scale != 1) {
                        period = period.multiplyBy(scale);
                    }
                    return new Expressions.PrimitiveValue<SUTime.PeriodicTemporalSet>("PeriodicTemporalSet", new SUTime.PeriodicTemporalSet(temporal, period, quant, null), new String[0]);
                }
                throw new IllegalArgumentException("Invalid number of arguments to " + this.name);
            }
        }, new String[0]));
        this.env.bind("TemporalCompose", new Expressions.PrimitiveValue<5>("FUNCTION", new ValueFunctions.NamedValueFunction("TemporalCompose"){

            @Override
            public boolean checkArgs(List<Value> in) {
                if (in.size() < 1) {
                    return false;
                }
                return in.get(0) != null && in.get(0).get() instanceof SUTime.TemporalOp;
            }

            @Override
            public Value apply(Env env, List<Value> in) {
                if (in.size() > 1) {
                    SUTime.TemporalOp op = (SUTime.TemporalOp)((Object)in.get(0).get());
                    boolean allTemporalArgs = true;
                    Object[] args = new Object[in.size() - 1];
                    for (int i = 0; i < args.length; ++i) {
                        Value v = in.get(i + 1);
                        if (v == null) continue;
                        args[i] = v.get();
                        if (args[i] instanceof MatchedExpression) {
                            Value v2 = ((MatchedExpression)args[i]).getValue();
                            Object object = args[i] = v2 != null ? (Object)v2.get() : null;
                        }
                        if (args[i] == null || args[i] instanceof SUTime.Temporal) continue;
                        allTemporalArgs = false;
                    }
                    if (allTemporalArgs) {
                        SUTime.Temporal[] temporalArgs = new SUTime.Temporal[args.length];
                        for (int i = 0; i < args.length; ++i) {
                            temporalArgs[i] = (SUTime.Temporal)args[i];
                        }
                        return new Expressions.PrimitiveValue<SUTime.Temporal>(null, op.apply(temporalArgs), new String[0]);
                    }
                    return new Expressions.PrimitiveValue<SUTime.Temporal>(null, op.apply(args), new String[0]);
                }
                throw new IllegalArgumentException("Invalid number of arguments to " + this.name);
            }
        }, new String[0]));
    }

    @Override
    public int determineRelFlags(CoreMap annotation, TimeExpression te) {
        Value v;
        int flags = 0;
        boolean flagsSet = false;
        if (te.value.getTags() != null && (v = te.value.getTags().getTag("resolveTo")) != null && v.get() instanceof Number) {
            flags = ((Number)v.get()).intValue();
            flagsSet = true;
        }
        if (!flagsSet && te.getTemporal() instanceof SUTime.PartialTime) {
            flags = 512;
        }
        return flags;
    }

    private static class MatchedExpressionValueTypeMatchNodePattern
    extends NodePattern<MatchedExpression> {
        String valueType;

        public MatchedExpressionValueTypeMatchNodePattern(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public boolean match(MatchedExpression me) {
            Value v;
            Value value = v = me != null ? me.getValue() : null;
            if (v != null) {
                return this.valueType.equals(v.getType());
            }
            return false;
        }
    }

    private static class TimexTypeMatchNodePattern
    extends NodePattern<TimeExpression> {
        SUTime.TimexType type;

        public TimexTypeMatchNodePattern(SUTime.TimexType type) {
            this.type = type;
        }

        @Override
        public boolean match(TimeExpression te) {
            SUTime.Temporal t;
            if (te != null && (t = te.getTemporal()) != null) {
                return this.type.equals((Object)t.getTimexType());
            }
            return false;
        }
    }
}

