import pandas as pd
import matplotlib.pyplot as plt

# 读取CSV文件
df = pd.read_csv('temp.csv')

# 提取数据
steps = df.columns[1:].astype(int)  # 提取步数
scores = df.values[:, 1:].astype(float)  # 提取分数

# 绘制折线图
plt.figure(figsize=(4, 2.5))

# 绘制VLEU折线
plt.plot(steps, scores[0], marker='o', label='Naive Finetuning', markersize=2)
# 绘制IS折线
plt.plot(steps, scores[1], marker='o', label='DreamBooth', color='green', markersize=2)
# 绘制FID折线
# plt.plot(steps, scores[2], marker='o', label='FID', color='orange', markersize=3)

# 添加标题和标签
plt.xlabel('Steps', fontsize=11)
plt.ylabel('VLEU', fontsize=11)
plt.xticks(fontsize=9)
plt.yticks(fontsize=9)

# 添加图例
plt.legend(frameon=False)

plt.gca().spines['top'].set_visible(False)
plt.gca().spines['right'].set_visible(False)

# 显示图形
# plt.grid(True)
plt.tight_layout()
plt.show()
