import logging
import sys
import os


def setup_logger(logger_level=logging.DEBUG):
    # if current process is not master process, we create a child logger for it,
    # and don't propagate this child logger's message to the root logger.
    # We don't create any handlers to this child logger, so that no message will be ouput from this process.
    if int(os.environ.get("LOCAL_RANK", -1)) != -1:
        logger_child = logging.getLogger(name=__name__)
        logger_child.propagate = False
        return logger_child

    # if current process is master process, we create a root logger for it,
    # and create handlers for the root logger.
    root_logger = logging.getLogger()
    root_logger.setLevel(logger_level)
    handler = logging.StreamHandler(stream=sys.stdout)
    handler.setLevel(logger_level)
    formatter = logging.Formatter("%(asctime)s - %(filename)s[line:%(lineno)d] - %(levelname)s: %(message)s")
    handler.setFormatter(formatter)
    root_logger.addHandler(handler)

    return root_logger
