theory question_76_8
imports Main

begin

typedecl entity
typedecl event

consts
  Organism :: "entity ⇒ bool"
  TooHot :: "entity ⇒ bool"
  Becomes :: "event ⇒ bool"
  Dies :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Decomposers :: "entity ⇒ bool"
  Cycle :: "entity ⇒ bool"
  Death :: "entity ⇒ bool"
  Triggers :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Completion :: "event ⇒ bool"
  Complete :: "event ⇒ bool"

(* Explanation 1: When an organism becomes too hot, it dies. *)
axiomatization where
  explanation_1: "∀x e1 e2. Organism x ∧ TooHot x ∧ Becomes e1 ∧ Agent e1 x ⟶ (Dies e2 ∧ Agent e2 x)"

(* Explanation 2: The death of an organism triggers the completion of the decomposers' cycle. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Organism x ∧ Decomposers y ∧ Cycle y ∧ Death e1 ∧ Agent e1 x ⟶ (Triggers e2 ∧ Agent e2 e1 ∧ Patient e2 y ∧ Completion e2)"

theorem hypothesis:
  assumes asm: "Organism x ∧ TooHot x ∧ Becomes e1 ∧ Agent e1 x"
  (* Hypothesis: If an organism becomes too hot, then decomposers complete their cycle. *)
  shows "∃e2 y. Decomposers y ∧ Cycle y ∧ Complete e2 ∧ Agent e2 y"
proof -
  from asm have "Organism x ∧ TooHot x ∧ Becomes e1 ∧ Agent e1 x" by simp
  then obtain e2 where e2: "Dies e2 ∧ Agent e2 x" using explanation_1 by blast
  then obtain y where y: "Decomposers y ∧ Cycle y ∧ Triggers e2 ∧ Agent e2 y ∧ Completion e2" using explanation_2 by blast
  have conclusion: "Decomposers y ∧ Cycle y ∧ Complete e2 ∧ Agent e2 y" using y by simp
  show ?thesis using asm conclusion by blast
qed

end
