theory question_7_0

imports Main

begin
typedecl entity
typedecl event

consts
  Jumping :: "event ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  Yellow :: "entity ⇒ bool"
  Rope :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Girl :: "entity ⇒ bool"
  LittleGirl :: "entity ⇒ bool"

(* Explanation 1: jumping over a yellow rope is same as jumps rope. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Jumping e1 ∧ Over e1 z ∧ Yellow z ∧ Rope y ∧ Patient e1 y ∧ Jumps e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: A little girl is jumping over a yellow rope. *)
  assumes asm: "LittleGirl x ∧ Jumping e ∧ Agent e x ∧ Over e z ∧ Yellow z ∧ Rope y ∧ Patient e y"
  (* Hypothesis: A girl jumps rope. *)
  shows "∃x y e. Girl x ∧ Rope y ∧ Jumps e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "LittleGirl x ∧ Jumping e ∧ Agent e x ∧ Over e z ∧ Yellow z ∧ Rope y ∧ Patient e y" by blast
  then have "Jumping e ∧ Over e z ∧ Yellow z ∧ Rope y ∧ Patient e y ∧ Jumps e' ∧ Agent e' x ∧ Patient e' y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
