theory question_22_0
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  WhiteBed :: "entity ⇒ bool"
  Sleeping :: "event ⇒ bool"
  Inside :: "entity ⇒ bool"
  AnimalPrintPants :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Two men sleeping on a white bed implies that they are inside. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ Man y ∧ WhiteBed e ∧ Sleeping e ⟶ Inside x ∧ Inside y"

theorem hypothesis:
  (* Premise: Two men in animal print pants sleep on a white bed. *)
  assumes asm: "Man x ∧ Man y ∧ AnimalPrintPants x ∧ WhiteBed e ∧ Sleeping e ∧ On x e"
  (* Hypothesis: Two men are inside. *)
  shows "∃x y e. Man x ∧ Man y ∧ Inside x ∧ Inside y"
proof -
  from asm have "Man x ∧ Man y ∧ WhiteBed e ∧ Sleeping e" by blast
  then have "Inside x ∧ Inside y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
