Affirmative Interpretation Generation System
===================================================================
Note: The updated code can be found in the GitHub repository below.  
https://github.com/mosharafhossain/AFIN



## Requirements
Python 3.7 (or higher; list of packages are included in ./env-setup/requirements.txt file) 
Download the T5-Large model from https://huggingface.co/t5-large and then put the files inside "./model/pre-trained/T5-large" directory.

```bash
# Create a virtual environment 
python3 -m venv local_dir/afin
source local_dir/afin/bin/activate

# Install the required packages 
pip install -r ./env-setup/requirements.txt
```

## Commands to Run the Experiments:

### Training Step: Commands to train the system using the training split (and with the development split to select the best model): 
```bash
  python train.py --config_path ./config/config_with_verb.json  (input setup: with verb)
  python train.py --config_path ./config/config_without_verb.json  (input setup: without verb)
```
  + Arguments:
	  - --config_path: path to the configuration file that contains all the hyperparameters
  
### Generation Step: Commands to generate affirmative interpretaions on the test split. 
```bash
  python predict.py --config_path ./config/config_with_verb.json  (input setup: with verb)
  python predict.py --config_path ./config/config_without_verb.json  (input setup: without verb)
```
  + Arguments:
	  - --config_path: path to the configuration file that contains all the hyperparameters 

## Data example:
The directory "./data" contains three splits: train.jsonl, dev.jsonl, and test.jsonl.  

A sample row (json object) in the files is given below:  
{"sentence": "It was not made by living organisms .", "unique_id": 10, "verb": "made", "neg_cue": "not", "q1": "What was made by something?", "a1": "It", "s1": 4, "q2": "What was something made by?", "a2": "inanimate organisms", "s2": 4, "num_qa": 2, "q0": "Was something made by something?", "a0": "yes", "afin": "It was made by inanimate organisms."} 

Attributes:  
sentence: the negated sentence
verb: the target negated verb
neg_cue: the negation cue in the negated sentence
q0: predicate question (yes/no answer) relating to the target verb 
q1-q8: argument questions  relating to the target verb
a0: answer to the predicate question (i.e., yes/no)
a1-a8: answers to the argument questions q1-q2
s1-s8: confidence scores of the answers a1-a8, and 
afin: affirmative interpretation of the negated statement

