#!/usr/bin/env bash
set -e 
set -x 


GPU='0'
TRG_DIS='40'

SEED=('42')

for s in "${SEED[@]}"
do
CKPT_NAME='iterative_decoding_'${s}
CKPT_NUM=('5')

for zone in "${CKPT_NUM[@]}"
do
python test_iterative.py \
     --ckpt_name=${CKPT_NAME}-pred \
     --load_ckpt=checkpoints/${CKPT_NAME}/epoch_${zone}.ckpt \
     --num_iterative_epochs 6 \
     --gpus ${GPU} \
     --data_file=preprocessed/preprocessed_${CKPT_NAME} \
     --use_info \
     --trg_dis ${TRG_DIS} \
     --seed ${s}
done 

done