import numpy as np
from operator import itemgetter
import sys

def cartesian_to_polar_matrix(m):
    x = np.zeros((m.shape[0], m.shape[1]))
    x[:,0] = np.linalg.norm(m, axis = 1)
    denom = np.reshape(np.power(m[:,-1], 2), (m.shape[0],1))
    for i, q in enumerate(reversed(range(m.shape[1]-1))):
        a = np.reshape(m[:,q], (m.shape[0],1))
        denom += np.power(a,2)
        x[:,-(1+i)] = np.arccos(a/np.sqrt(denom)).flatten()
        if i == 0:
            x[np.where(m[:,-1]<0),-1]= 2*np.pi -x[np.where(m[:,-1]<0),-1]
    x[:,1:] = x[:,1:]/np.pi  
    return x

def cartesian_to_polar(v):
    x = np.zeros(len(v))
    x[0] = np.linalg.norm(v)
    denom = np.power(v[-1],2)
    for i, a in enumerate(v[:len(v)-1][::-1]):
        denom += np.power(a,2)
        x[-(1+i)]= np.arccos(a/np.sqrt(denom))
        if i == 0 and v[-1] < 0:
            x[-1] = 2*np.pi - x[-1]
    x[1:] = x[1:]/np.pi
    return x

def polar_to_cartesian_matrix(m):
    r = np.tile(np.reshape(m[:,0], (m.shape[0],1)), m.shape[1])
    x = np.zeros((m.shape[0], m.shape[1]))
    s = np.ones(m.shape[0])
    for i in range(m.shape[1]-1):
        x[:,i] = s*np.cos(m[:,i+1]*np.pi)
        s *= np.sin(m[:,i+1]*np.pi)
    x[:,m.shape[1]-1] = s


    return x*r
    


def polar_to_cartesian(v):
    r = v[0]
    omega = v[1:]
    """omega: the n-2 values between [0,\pi) and last one between [0,2\pi)
    """
    x = np.zeros(len(v))
    s = 1
    for i, a in enumerate(omega):
        x[i] = s*np.cos(a*np.pi)
        s *= np.sin(a*np.pi)
    x[len(v)-1] = s

    return x*r



def r_cos_simc(v1,v2):#cartesian
    return np.dot(v1, v2) 
def cos_simc(v1, v2):#cartesian
    return np.dot(v1, v2) / (np.linalg.norm(v1) * np.linalg.norm(v2))

def cos_simc_matrix(m1, m2):
    return np.sum(m1*m2, axis = 1) /  (np.linalg.norm(m1, axis = 1)* np.linalg.norm(m2, axis = 1))

def euclidean_simc_matrix(m1, m2):
    return np.linalg.norm(m1-m2, axis = 1)

def euclidean_simc(v1,v2):#cartesian
    return np.linalg.norm(v1-v2)

def siblings_simp(v1,v2): #polar [0:1??]
    sim = np.sum(np.abs(np.cos(v1[1:]*np.pi)-np.cos(v2[1:]*np.pi)))/(len(v1)-1)
    return sim

def hyperhypo_simp(v1,v2):#polar (-inf,1]??
    sim = (v2[0]-v1[0])/v1[0]
    return sim


if __name__ == "__main__":

    c_v1 = np.array([1, 2, 3])
    c_v2 = np.array([4, 5, 6])
    p_v1 = np.array([1, 0.3, 0.2])
    p_v2 = np.array([2, 0.5, 0.4]) 
    print(euclidean_simc(c_v1, c_v2))
    print(cos_simc(c_v1, c_v2))
    print(siblings_simp(p_v1, p_v2))
    print(hyperhypo_simp(p_v1, p_v2))
    print(cartesian_to_polar(c_v1))
    print(polar_to_cartesian(cartesian_to_polar(c_v1)))


