import React, { Component } from 'react';
import { withTracker } from 'meteor/react-meteor-data';
import { Link } from "react-router-dom";

import TextDoc from './TextDoc.jsx';
import { Texts, Annotations, Assignments, Tutorials } from '../api/documents';
import { gup } from '../util/gup.js';

export class View extends Component {
  constructor(props) {
    super(props);

    this.ignoreValidate = this.ignoreValidate.bind(this);
    this.getFocus = this.getFocus.bind(this);
  }

  ignoreValidate(message) {
    // Placeholder for validation
  }

  getFocus(text_id) {
    if (this.props.assignments.length > 0) {
      const assignment = this.props.assignments[0];
      return assignment.focus_mention;
    } else if (this.props.tutorials.length > 0) {
      // This is needed for the case of tutorials being viewed
      return this.props.tutorials[0].tasks.filter(task => {
        return task.text_id == text_id;
      }).map(task => task.focus_mention)[0];
    } else {
      return undefined;
    }
  }

  render() {
    if (this.props.areReady) {
      const annotation = this.props.annotations[0];
      const text = this.props.texts.find(t => t._id == annotation.text_id);
      const focus = this.getFocus(text._id);

      const returnPath = "/" +
        "?action=" + gup("action") +
        "&annoId=" + gup("annoId") +
        "&textId=" + gup("textId") +
        "&tutId=" + gup("tutId") +
        "&ui=" + gup("ui");

      if (annotation != undefined) {
        return (
          <div> 
            <TextDoc
              text={text}
              clusters={annotation.clusters}
              checks={annotation.checks}
              key={annotation._id}
              ann_id={annotation._id}
              labelOptions={annotation.labels}
              ui={this.props.match.params.ui}
              readOnly={true}
              validate={this.ignoreValidate}
              focusMention={focus}
            />
            <div className="clear">
            </div>
            <Link to={returnPath}>Done</Link>
          </div>
        );
      }
    }

    return (
      <p>
      Loading...
      </p>
    );
  }
}

export default ViewContainer = withTracker(() => {
  const text_id = gup("textId");
  const ann_id = gup("annoId");
  const assign_id = gup("internalAssignment");
  const tut_id = gup("tutId");

  const handles = [
    Meteor.subscribe('texts-single', text_id),
    Meteor.subscribe('annotations-single', ann_id),
    Meteor.subscribe('assignments-single', assign_id),
    Meteor.subscribe('tutorials-single', tut_id),
    Meteor.subscribe('texts-tutorials'),
  ];
 
  return {
    texts: Texts.find().fetch(),
    annotations: Annotations.find().fetch(),
    assignments: Assignments.find().fetch(),
    tutorials: Tutorials.find().fetch(),
    areReady: handles.every(handle => handle.ready()),
  };
})(View);
