# Attack SAM

This repo contains the code to attack SAM Model.

## Prepare SAM model

The SAM model is trained by ourselves. 

We put the code in root directory, which is based on this [github repo](https://github.com/ExplorerFreda/Structured-Self-Attentive-Sentence-Embedding).

You can reproduce the results by running:

```
python train.py \
--emsize [word embedding size default 300] \
--nhid [hidden layer size, default 300] \
--nlayers [hidden layer numbers in Bi-LSTM, default 2] \
--attention-unit [attention unit number, d_a in the paper, default 350] \
--attention-hops [hop number, r in the paper, default 1] \
--dropout [dropout ratio, default 0.5] \
--nfc [hidden layer size for MLP in the classifier, default 512] \
--lr [learning rate, default 0.001] \
--epochs [epoch number for training, default 40] \
--seed [initial seed for reproduction, default 1111] \
--log-interval [the interval for reporting training loss, default 200] \
--batch-size [size of a batch in training procedure, default 32] \
--optimizer [type of the optimizer, default Adam] \
--penalization-coeff [coefficient of the Frobenius Norm penalization term, default 1.0] \
--class-number [number of class for the last step of classification] \
--save [path to save model] \
--dictionary [location of the dictionary generated by the tokenizer] \
--word-vector [location of the initial word vector, e.g. GloVe, should be a torch .pt model] \
--train-data [location of training data, should be in the same format with tokenized productions] \
--val-data [development set] \
--test-data [location of testing dataset] \
--cuda [whether using GPU for training, remove this when using CPU] 
```

We are using the following hyper-parameters:
```
attention_hops = 10
nfc = 512
batch_size = 256
seed = 2334 
```

## Attack 

You may read our `attack.py` for more information. You can try different attack methods (word-level/sentence-level).

