/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import javax.swing.JTextArea;

public class TranslatedDocument
implements Iterable<ParallelSentence> {
    private final List<ParallelSentence> parallelSentences;

    private TranslatedDocument(List<ParallelSentence> parallelSentences) {
        this.parallelSentences = parallelSentences;
    }

    public int size() {
        return this.parallelSentences.size();
    }

    public ParallelSentence get(int index) {
        return this.parallelSentences.get(index);
    }

    public void populateUneditableSourceTextArea(JTextArea textArea) {
        textArea.setText(null);
        StringBuilder s = new StringBuilder();
        for (ParallelSentence p : this.parallelSentences) {
            String[] stringArray = p.sourceWords;
            int n = p.sourceWords.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                s.append(word);
                s.append(" ");
                ++n2;
            }
            s.append(System.getProperty("line.separator"));
        }
        textArea.setText(s.toString());
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setRows(this.size());
    }

    public void populateUneditableTargetTextArea(JTextArea textArea) {
        textArea.setText(null);
        StringBuilder s = new StringBuilder();
        for (ParallelSentence p : this.parallelSentences) {
            String[] stringArray = p.targetWords;
            int n = p.targetWords.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                s.append(word);
                s.append(" ");
                ++n2;
            }
            s.append(System.getProperty("line.separator"));
        }
        textArea.setText(s.toString());
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setRows(this.size());
    }

    public static List<TranslatedDocument> collateTranslatedDocuments(String postEditedPath, String sourcePath, String targetPath, String alignmentsPath, String svgListPath) {
        ArrayList<TranslatedDocument> list = new ArrayList<TranslatedDocument>();
        ArrayList<ParallelSentence> parallelSentences = new ArrayList<ParallelSentence>();
        try {
            Scanner postEditScanner = new Scanner(new File(postEditedPath), "UTF-8");
            Scanner sourceScanner = new Scanner(new File(sourcePath), "UTF-8");
            Scanner targetScanner = new Scanner(new File(targetPath), "UTF-8");
            Scanner alignmentsScanner = new Scanner(new File(alignmentsPath), "UTF-8");
            Scanner svgListScanner = new Scanner(new File(svgListPath), "UTF-8");
            while (postEditScanner.hasNextLine() && sourceScanner.hasNextLine() && targetScanner.hasNextLine() && alignmentsScanner.hasNextLine() && svgListScanner.hasNextLine()) {
                String postEdit = postEditScanner.nextLine();
                String sourceLine = sourceScanner.nextLine();
                String targetLine = targetScanner.nextLine();
                String alignments = alignmentsScanner.nextLine();
                String svgPath = svgListScanner.nextLine();
                String[] sourceParts = sourceLine.split("\\s+");
                String[] targetParts = targetLine.split("\\s+");
                String[] alignmentParts = alignments.split("\\s+");
                if (TranslatedDocument.valid(sourceParts) && TranslatedDocument.valid(targetParts) && TranslatedDocument.valid(alignmentParts)) {
                    ParallelSentence parallelSentence = new ParallelSentence(postEdit, sourceParts, targetParts, alignmentParts, svgPath, parallelSentences.size());
                    parallelSentences.add(parallelSentence);
                    continue;
                }
                if (parallelSentences.isEmpty()) continue;
                list.add(new TranslatedDocument(parallelSentences));
                parallelSentences = new ArrayList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static boolean valid(String[] line) {
        if (line == null) {
            return false;
        }
        if (line.length == 0) {
            return false;
        }
        return line.length != 1 || !line[0].equals("=================================") && !line[0].equals("");
    }

    @Override
    public Iterator<ParallelSentence> iterator() {
        return this.parallelSentences.iterator();
    }
}

