#include "headers/main.ih"


int main(int argc, char *argv[])
{
    argc-=(argc>0); argv+=(argc>0); // skip program name argv[0] if present
    option::Stats  stats(usage, argc, argv);
    std::vector<option::Option> options(stats.options_max);
    std::vector<option::Option> buffer(stats.buffer_max);
    option::Parser parse(usage, argc, argv, &options[0], &buffer[0]);

    if (parse.error() || options[HELP] || argc == 0)
    {
        option::printUsage(std::cerr, usage);
        return (parse.error())? 1: 0;
    }
   
    if (!options[MODE])
    {
        std::cerr << "Please use -m to specify mode: TRain TEst or RUn\nOr run ./monoise -h for help.\n";
        return 0;
    }
    

    char mode1 = toupper(options[MODE].arg[0]);
    char mode2 = toupper(options[MODE].arg[1]);
    
    enum Mode { TRAIN, TEST, DEV, RUN, INT, UNK};
    Mode curMode = UNK; 
    if (mode1 == 'T' && mode2 == 'R')
        curMode = TRAIN; 
    else if (mode1 == 'T' && mode2 == 'E')
        curMode = TEST;
    else if (mode1 == 'D' && mode2 == 'E')
        curMode = DEV;
    else if (mode1 == 'R' && mode2 == 'U')
        curMode = RUN;
    else if (mode1 == 'I' && mode2 == 'N')
        curMode = INT;
    else
        std::cerr << "Unknown mode entered as argument; please use TRain TEst DEv or RUn\nOr try ./monoise -h for help\n";
         
    if (!options[RANDOMF] && !(options[UNSUPERVISED]))
    {
        std::cerr << "Please specify path to random forest classifier with -r. Or run unsupervised with -u.\n";
        return 0;
    }

    Config myConfig;
    readConfig(&myConfig, options, ((options[NL])?"config.nl": "config.en"));
    myConfig.train = (curMode == TRAIN);
    Model myModel(&myConfig);
 
    std::istream *input = &std::cin; 
    std::ifstream in2;
    if(options[INPUT])
    {
        in2.open(options[INPUT].arg);
        input = &in2;
    }
    if (!input->good())
    {
        std::cerr << "Could not read input\n";
        exit(1);
    }
    std::ostream *output = &std::cout;
    std::ofstream out2;
    if(options[OUTPUT])
    {
        out2.open(options[OUTPUT].arg);
        output = &out2;
    } 
    if (!output->good())
    {
        std::cerr << "Could not write output\n";
        exit(1);
    }
   
    switch(curMode)
    {
        case TRAIN:
            myModel.train(options[INPUT].arg, output);
            break;

        case TEST:
            myModel.test(input, output);
            break;

        case DEV:
            myModel.test(input, output, myConfig.numTrain, myConfig.numDev);
            break;

        case RUN:
            myModel.run(input, output);
            break;

        case INT:
            myModel.interactive();
            break;

        case UNK:
            std::cerr << "Unknown mode entered as argument; please use TRain TEst or RUn\nOr try ./monoise -h for help\n";
            break;
    }
}
